/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.streams;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.streams.ReadStreamIterator;
import io.vertx.core.streams.Pipe;
import io.vertx.core.streams.StreamBase;
import io.vertx.core.streams.WriteStream;
import io.vertx.core.streams.impl.PipeImpl;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@VertxGen(concrete=false)
public interface ReadStream<T>
extends StreamBase {
    @Override
    public ReadStream<T> exceptionHandler(@Nullable Handler<Throwable> var1);

    @Fluent
    public ReadStream<T> handler(@Nullable Handler<T> var1);

    @Fluent
    public ReadStream<T> pause();

    @Fluent
    public ReadStream<T> resume();

    @Fluent
    public ReadStream<T> fetch(long var1);

    @Fluent
    public ReadStream<T> endHandler(@Nullable Handler<Void> var1);

    default public Pipe<T> pipe() {
        this.pause();
        return new PipeImpl(this);
    }

    @GenIgnore
    default public <R, A> Future<R> collect(Collector<T, A, R> collector2) {
        PromiseInternal promise = (PromiseInternal)Promise.promise();
        Object cumulation = collector2.supplier().get();
        BiConsumer accumulator = collector2.accumulator();
        this.handler(elt -> accumulator.accept(cumulation, elt));
        this.endHandler(v -> {
            Object result2 = collector2.finisher().apply(cumulation);
            promise.tryComplete(result2);
        });
        this.exceptionHandler(promise::tryFail);
        return promise.future();
    }

    @GenIgnore
    default public Stream<T> blockingStream() {
        Iterator iterator2 = ReadStreamIterator.iterator(this);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator2, 16), false);
    }

    default public Future<Void> pipeTo(WriteStream<T> dst) {
        return new PipeImpl<T>(this).to(dst);
    }
}

