/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.streams.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.streams.Pipe;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;

public class PipeImpl<T>
implements Pipe<T> {
    private final Promise<Void> result;
    private final ReadStream<T> src;
    private boolean endOnSuccess = true;
    private boolean endOnFailure = true;
    private WriteStream<T> dst;

    public PipeImpl(ReadStream<T> src) {
        this.src = src;
        this.result = Promise.promise();
        src.endHandler(this.result::tryComplete);
        src.exceptionHandler(this.result::tryFail);
    }

    @Override
    public synchronized Pipe<T> endOnFailure(boolean end2) {
        this.endOnFailure = end2;
        return this;
    }

    @Override
    public synchronized Pipe<T> endOnSuccess(boolean end2) {
        this.endOnSuccess = end2;
        return this;
    }

    @Override
    public synchronized Pipe<T> endOnComplete(boolean end2) {
        this.endOnSuccess = end2;
        this.endOnFailure = end2;
        return this;
    }

    private void handleWriteResult(AsyncResult<Void> ack) {
        if (ack.failed()) {
            this.result.tryFail(new WriteException(ack.cause()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> to(WriteStream<T> ws) {
        Promise promise = Promise.promise();
        if (ws == null) {
            throw new NullPointerException();
        }
        PipeImpl pipeImpl = this;
        synchronized (pipeImpl) {
            if (this.dst != null) {
                throw new IllegalStateException();
            }
            this.dst = ws;
        }
        Handler<Void> drainHandler = v -> this.src.resume();
        this.src.handler(item2 -> {
            ws.write(item2).onComplete(this::handleWriteResult);
            if (ws.writeQueueFull()) {
                this.src.pause();
                ws.drainHandler(drainHandler);
            }
        });
        this.src.resume();
        this.result.future().onComplete(ar -> {
            try {
                this.src.handler(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.src.exceptionHandler((Handler)null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.src.endHandler(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ar.succeeded()) {
                this.handleSuccess(promise);
            } else {
                Throwable err = ar.cause();
                if (err instanceof WriteException) {
                    this.src.resume();
                    err = err.getCause();
                }
                this.handleFailure(err, promise);
            }
        });
        return promise.future();
    }

    private void handleSuccess(Promise<Void> promise) {
        if (this.endOnSuccess) {
            this.dst.end().onComplete(promise);
        } else {
            promise.complete();
        }
    }

    private void handleFailure(Throwable cause, Promise<Void> completionHandler) {
        if (this.endOnFailure) {
            this.dst.end().transform(ar -> Future.failedFuture(cause)).onComplete(completionHandler);
        } else {
            completionHandler.fail(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        PipeImpl pipeImpl = this;
        synchronized (pipeImpl) {
            this.src.exceptionHandler((Handler)null);
            this.src.handler(null);
            if (this.dst != null) {
                this.dst.drainHandler(null);
                this.dst.exceptionHandler((Handler)null);
            }
        }
        VertxException err = new VertxException("Pipe closed", true);
        if (this.result.tryFail(err)) {
            this.src.resume();
        }
    }

    private static class WriteException
    extends VertxException {
        private WriteException(Throwable cause) {
            super(cause, true);
        }
    }
}

