/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authorization.impl;

import io.vertx.core.MultiMap;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;

public class VariableAwareExpression {
    private final String value;
    private final transient Function<MultiMap, String>[] parts;
    private transient boolean hasVariable = false;

    public VariableAwareExpression(String value) {
        this.value = Objects.requireNonNull(value).trim();
        ArrayList<Function<MultiMap, String>> tmpParts = new ArrayList<Function<MultiMap, String>>();
        int currentPos = 0;
        while (currentPos != -1) {
            int closingCurlyBracePos;
            int openingCurlyBracePos = value.indexOf("{", currentPos);
            if (openingCurlyBracePos == -1) {
                if (currentPos >= value.length()) break;
                String authorizationPart = value.substring(currentPos);
                tmpParts.add(ctx -> authorizationPart);
                break;
            }
            if (openingCurlyBracePos > currentPos) {
                String authorizationPart = value.substring(currentPos, openingCurlyBracePos);
                tmpParts.add(ctx -> authorizationPart);
            }
            if ((closingCurlyBracePos = value.indexOf("}", currentPos + 1)) == -1) {
                throw new IllegalArgumentException("opening '{' without corresponding closing '}'");
            }
            if (closingCurlyBracePos - openingCurlyBracePos == 1) {
                throw new IllegalArgumentException("empty '{}' is not allowed");
            }
            String part = value.substring(openingCurlyBracePos, closingCurlyBracePos + 1);
            String variableName = value.substring(openingCurlyBracePos + 1, closingCurlyBracePos);
            this.hasVariable = true;
            tmpParts.add(ctx -> {
                String result2 = ctx.get(variableName);
                if (result2 != null) {
                    return result2;
                }
                return part;
            });
            currentPos = closingCurlyBracePos + 1;
        }
        this.parts = new Function[tmpParts.size()];
        for (int i = 0; i < tmpParts.size(); ++i) {
            this.parts[i] = (Function)tmpParts.get(i);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariableAwareExpression)) {
            return false;
        }
        VariableAwareExpression other = (VariableAwareExpression)obj;
        return Objects.equals(this.value, other.value);
    }

    public boolean hasVariable() {
        return this.hasVariable;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String resolve(MultiMap context2) {
        if (!this.hasVariable) {
            return this.value;
        }
        if (this.parts.length == 1) {
            return this.parts[0].apply(context2);
        }
        if (this.parts.length > 1) {
            StringBuilder result2 = new StringBuilder();
            for (Function<MultiMap, String> part : this.parts) {
                result2.append(part.apply(context2));
            }
            return result2.toString();
        }
        return "";
    }
}

