/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.impl;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.Authorizations;
import io.vertx.ext.auth.authorization.impl.AuthorizationConverter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class UserConverter {
    private static final String FIELD_PRINCIPAL = "principal";
    private static final String FIELD_AUTHORIZATIONS = "authorizations";
    private static final String FIELD_ATTRIBUTES = "attributes";

    public static JsonObject encode(User value) throws IllegalArgumentException {
        Objects.requireNonNull(value);
        JsonObject json2 = new JsonObject();
        json2.put(FIELD_PRINCIPAL, value.principal());
        Authorizations authorizations = value.authorizations();
        if (authorizations != null && !authorizations.isEmpty()) {
            JsonObject jsonAuthorizations = new JsonObject();
            authorizations.forEach((providerId, authorization) -> {
                JsonArray jsonAuthorizationByProvider;
                if (jsonAuthorizations.containsKey((String)providerId)) {
                    jsonAuthorizationByProvider = jsonAuthorizations.getJsonArray((String)providerId);
                } else {
                    jsonAuthorizationByProvider = new JsonArray();
                    jsonAuthorizations.put((String)providerId, jsonAuthorizationByProvider);
                }
                jsonAuthorizationByProvider.add(AuthorizationConverter.encode(authorization));
            });
            json2.put(FIELD_AUTHORIZATIONS, jsonAuthorizations);
        }
        json2.put(FIELD_ATTRIBUTES, value.attributes());
        return json2;
    }

    public static User decode(JsonObject json2) throws IllegalArgumentException {
        Objects.requireNonNull(json2);
        JsonObject principal = json2.getJsonObject(FIELD_PRINCIPAL);
        User user = User.create(principal);
        JsonObject jsonAuthorizations = json2.getJsonObject(FIELD_AUTHORIZATIONS);
        if (jsonAuthorizations != null) {
            HashMap<String, Set<Authorization>> decodedAuthorizations = new HashMap<String, Set<Authorization>>(jsonAuthorizations.size());
            for (String fieldName : jsonAuthorizations.fieldNames()) {
                Set authorizations;
                JsonArray jsonAuthorizationByProvider = jsonAuthorizations.getJsonArray(fieldName);
                if (jsonAuthorizationByProvider == null) {
                    authorizations = Collections.emptySet();
                } else {
                    authorizations = new HashSet(jsonAuthorizationByProvider.size());
                    for (int i = 0; i < jsonAuthorizationByProvider.size(); ++i) {
                        authorizations.add(AuthorizationConverter.decode(jsonAuthorizationByProvider.getJsonObject(i)));
                    }
                }
                decodedAuthorizations.put(fieldName, authorizations);
            }
            user.authorizations().putAll(decodedAuthorizations);
        }
        user.attributes().mergeIn(json2.getJsonObject(FIELD_ATTRIBUTES, new JsonObject()));
        return user;
    }
}

