/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.common.template;

import io.vertx.core.Vertx;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.ext.web.common.WebEnvironment;
import io.vertx.ext.web.common.template.CachedTemplate;
import io.vertx.ext.web.common.template.TemplateEngine;
import java.util.Objects;

public abstract class CachingTemplateEngine<T>
implements TemplateEngine {
    private final LocalMap<String, CachedTemplate<T>> cache;
    protected String extension;

    protected CachingTemplateEngine(Vertx vertx, String ext) {
        this.cache = !WebEnvironment.development() ? vertx.sharedData().getLocalMap("__vertx.web.template.cache") : null;
        Objects.requireNonNull(ext);
        this.extension = ext.charAt(0) == '.' ? ext : "." + ext;
    }

    public CachedTemplate<T> getTemplate(String filename) {
        if (this.cache != null) {
            return this.cache.get(filename);
        }
        return null;
    }

    public CachedTemplate<T> putTemplate(String filename, CachedTemplate<T> cachedTemplate) {
        if (this.cache != null) {
            return this.cache.put(filename, cachedTemplate);
        }
        return null;
    }

    protected String adjustLocation(String location) {
        if (this.extension != null && !((String)location).endsWith(this.extension)) {
            location = (String)location + this.extension;
        }
        return location;
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }
}

