/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.impl.FileUploadImpl;
import io.vertx.ext.web.impl.RoutingContextInternal;
import java.io.File;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class BodyHandlerImpl
implements BodyHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BodyHandlerImpl.class);
    private long bodyLimit = 0xA00000L;
    private boolean handleFileUploads;
    private String uploadsDir;
    private boolean mergeFormAttributes = true;
    private boolean deleteUploadedFilesOnEnd = false;
    private boolean isPreallocateBodyBuffer = false;
    private static final int DEFAULT_INITIAL_BODY_BUFFER_SIZE = 1024;

    public BodyHandlerImpl() {
        this(true, "file-uploads");
    }

    public BodyHandlerImpl(boolean handleFileUploads) {
        this(handleFileUploads, "file-uploads");
    }

    public BodyHandlerImpl(String uploadDirectory) {
        this(true, uploadDirectory);
    }

    private BodyHandlerImpl(boolean handleFileUploads, String uploadDirectory) {
        this.handleFileUploads = handleFileUploads;
        this.setUploadsDirectory(uploadDirectory);
    }

    @Override
    public void handle(RoutingContext context2) {
        HttpServerRequest request = context2.request();
        HttpServerResponse response2 = context2.response();
        if (!((RoutingContextInternal)context2).seenHandler(2)) {
            boolean hasTransferEncoding;
            ((RoutingContextInternal)context2).visitHandler(2);
            long parsedContentLength = this.parseContentLengthHeader(request);
            boolean bl = hasTransferEncoding = request.version() == HttpVersion.HTTP_2 || request.headers().contains(HttpHeaders.TRANSFER_ENCODING);
            if (!hasTransferEncoding && parsedContentLength == -1L) {
                context2.next();
                return;
            }
            if (this.bodyLimit != -1L && parsedContentLength != -1L && parsedContentLength > this.bodyLimit) {
                context2.fail(413);
                return;
            }
            String expect = request.getHeader(HttpHeaders.EXPECT);
            if (expect != null) {
                if (expect.equalsIgnoreCase("100-continue")) {
                    if (request.version() != HttpVersion.HTTP_1_0) {
                        response2.writeContinue();
                    }
                } else {
                    context2.fail(417);
                    return;
                }
            }
            if (!request.isEnded()) {
                BHandler handler = new BHandler(context2, this.isPreallocateBodyBuffer ? parsedContentLength : -1L);
                request.handler((Handler)handler).endHandler(handler::end).resume();
            } else {
                String failure = "BodyHandler invoked after the request has ended. It should be the first handler invoked. Otherwise, you must pause the request after it's received.";
                context2.fail(new VertxException(failure, true));
            }
        } else {
            if (this.mergeFormAttributes && request.isExpectMultipart()) {
                request.params().addAll(request.formAttributes());
            }
            context2.next();
        }
    }

    @Override
    public BodyHandler setHandleFileUploads(boolean handleFileUploads) {
        this.handleFileUploads = handleFileUploads;
        return this;
    }

    @Override
    public BodyHandler setBodyLimit(long bodyLimit) {
        this.bodyLimit = bodyLimit;
        return this;
    }

    @Override
    public BodyHandler setUploadsDirectory(String uploadsDirectory) {
        this.uploadsDir = uploadsDirectory;
        return this;
    }

    @Override
    public BodyHandler setMergeFormAttributes(boolean mergeFormAttributes) {
        this.mergeFormAttributes = mergeFormAttributes;
        return this;
    }

    @Override
    public BodyHandler setDeleteUploadedFilesOnEnd(boolean deleteUploadedFilesOnEnd) {
        this.deleteUploadedFilesOnEnd = deleteUploadedFilesOnEnd;
        return this;
    }

    @Override
    public BodyHandler setPreallocateBodyBuffer(boolean isPreallocateBodyBuffer) {
        this.isPreallocateBodyBuffer = isPreallocateBodyBuffer;
        return this;
    }

    private long parseContentLengthHeader(HttpServerRequest request) {
        String contentLength = request.getHeader(HttpHeaders.CONTENT_LENGTH);
        if (contentLength == null || contentLength.isEmpty()) {
            return -1L;
        }
        try {
            long parsedContentLength = Long.parseLong(contentLength);
            return parsedContentLength < 0L ? -1L : parsedContentLength;
        }
        catch (NumberFormatException ex) {
            return -1L;
        }
    }

    private class BHandler
    implements Handler<Buffer> {
        private static final int MAX_PREALLOCATED_BODY_BUFFER_BYTES = 65535;
        final RoutingContext context;
        final long contentLength;
        Buffer body;
        boolean failed;
        final AtomicInteger uploadCount = new AtomicInteger();
        boolean ended;
        long uploadSize = 0L;
        final boolean isMultipart;
        final boolean isUrlEncoded;

        public BHandler(RoutingContext context2, long contentLength) {
            this.context = context2;
            this.contentLength = contentLength;
            if (contentLength != -1L) {
                this.initBodyBuffer();
            }
            List<FileUpload> fileUploads = context2.fileUploads();
            String contentType = context2.request().getHeader(HttpHeaders.CONTENT_TYPE);
            if (contentType == null) {
                this.isMultipart = false;
                this.isUrlEncoded = false;
            } else {
                String lowerCaseContentType = contentType.toLowerCase();
                this.isMultipart = lowerCaseContentType.startsWith(HttpHeaderValues.MULTIPART_FORM_DATA.toString());
                this.isUrlEncoded = lowerCaseContentType.startsWith(HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.toString());
            }
            if (this.isMultipart || this.isUrlEncoded) {
                context2.request().setExpectMultipart(true);
                if (BodyHandlerImpl.this.handleFileUploads) {
                    this.makeUploadDir(context2.vertx().fileSystem());
                }
                context2.request().uploadHandler(upload -> {
                    long size2;
                    if (BodyHandlerImpl.this.bodyLimit != -1L && upload.isSizeAvailable() && (size2 = this.uploadSize + upload.size()) > BodyHandlerImpl.this.bodyLimit) {
                        this.failed = true;
                        context2.cancelAndCleanupFileUploads();
                        context2.fail(413);
                        return;
                    }
                    if (BodyHandlerImpl.this.handleFileUploads) {
                        this.uploadCount.incrementAndGet();
                        String uploadedFileName = new File(BodyHandlerImpl.this.uploadsDir, UUID.randomUUID().toString()).getPath();
                        FileUploadImpl fileUpload = new FileUploadImpl(context2.vertx().fileSystem(), uploadedFileName, (HttpServerFileUpload)upload);
                        fileUploads.add(fileUpload);
                        Future<Void> fut = upload.streamToFileSystem(uploadedFileName);
                        fut.onComplete(ar -> {
                            if (fut.succeeded()) {
                                this.uploadEnded();
                            } else {
                                context2.cancelAndCleanupFileUploads();
                                context2.fail(ar.cause());
                            }
                        });
                    }
                });
            }
            context2.request().exceptionHandler(t -> {
                context2.cancelAndCleanupFileUploads();
                int sc = 200;
                if (t instanceof DecoderException) {
                    sc = 400;
                    if (t.getCause() != null) {
                        t = t.getCause();
                    }
                }
                context2.fail(sc, (Throwable)t);
            });
        }

        private void initBodyBuffer() {
            int initialBodyBufferSize = this.contentLength < 0L ? 1024 : (this.contentLength > 65535L ? 65535 : (int)this.contentLength);
            if (BodyHandlerImpl.this.bodyLimit != -1L) {
                initialBodyBufferSize = (int)Math.min((long)initialBodyBufferSize, BodyHandlerImpl.this.bodyLimit);
            }
            this.body = Buffer.buffer(initialBodyBufferSize);
        }

        private void makeUploadDir(FileSystem fileSystem) {
            if (!fileSystem.existsBlocking(BodyHandlerImpl.this.uploadsDir)) {
                fileSystem.mkdirsBlocking(BodyHandlerImpl.this.uploadsDir);
            }
        }

        @Override
        public void handle(Buffer buff) {
            if (this.failed) {
                return;
            }
            this.uploadSize += (long)buff.length();
            if (BodyHandlerImpl.this.bodyLimit != -1L && this.uploadSize > BodyHandlerImpl.this.bodyLimit) {
                this.failed = true;
                this.context.cancelAndCleanupFileUploads();
                this.context.fail(413);
            } else if (!this.isMultipart) {
                if (this.body == null) {
                    this.initBodyBuffer();
                }
                this.body.appendBuffer(buff);
            }
        }

        void uploadEnded() {
            int count2 = this.uploadCount.decrementAndGet();
            if (this.ended && count2 == 0) {
                this.doEnd();
            }
        }

        void end(Void v) {
            this.ended = true;
            if (this.uploadCount.get() == 0) {
                this.doEnd();
            }
        }

        void doEnd() {
            if (this.failed || this.context.failed()) {
                this.context.cancelAndCleanupFileUploads();
                return;
            }
            if (BodyHandlerImpl.this.deleteUploadedFilesOnEnd) {
                this.context.addBodyEndHandler(x2 -> this.context.cancelAndCleanupFileUploads());
            }
            HttpServerRequest req = this.context.request();
            if (BodyHandlerImpl.this.mergeFormAttributes && req.isExpectMultipart()) {
                req.params().addAll(req.formAttributes());
            }
            ((RoutingContextInternal)this.context).setBody(this.body);
            this.body = null;
            this.context.next();
        }
    }
}

