/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.ext.auth.prng.VertxContextPRNG;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.CSRFHandler;
import io.vertx.ext.web.impl.Origin;
import io.vertx.ext.web.impl.RoutingContextInternal;
import io.vertx.ext.web.impl.Signature;
import io.vertx.ext.web.impl.Utils;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;

public class CSRFHandlerImpl
implements CSRFHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CSRFHandlerImpl.class);
    private final VertxContextPRNG random;
    private final Signature signature;
    private boolean nagHttps;
    private String cookieName = "XSRF-TOKEN";
    private String cookiePath = "/";
    private String headerName = "X-XSRF-TOKEN";
    private long timeout = 1800000L;
    private Origin origin;
    private boolean httpOnly;
    private boolean cookieSecure;

    public CSRFHandlerImpl(Vertx vertx, String secret) {
        this.random = VertxContextPRNG.current(vertx);
        this.signature = new Signature(secret);
    }

    @Override
    public CSRFHandler setOrigin(String origin2) {
        this.origin = Origin.parse(origin2);
        return this;
    }

    @Override
    public CSRFHandler setCookieName(String cookieName) {
        this.cookieName = cookieName;
        return this;
    }

    @Override
    public CSRFHandler setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
        return this;
    }

    @Override
    public CSRFHandler setCookieHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    @Override
    public CSRFHandler setCookieSecure(boolean secure) {
        this.cookieSecure = secure;
        return this;
    }

    @Override
    public CSRFHandler setHeaderName(String headerName) {
        this.headerName = headerName;
        return this;
    }

    @Override
    public CSRFHandler setTimeout(long timeout2) {
        this.timeout = timeout2;
        return this;
    }

    @Override
    public CSRFHandler setNagHttps(boolean nag) {
        this.nagHttps = nag;
        return this;
    }

    private String generateAndStoreToken(RoutingContext ctx) {
        byte[] salt = new byte[32];
        this.random.nextBytes(salt);
        String saltPlusToken = Utils.base64UrlEncode(salt) + "." + System.currentTimeMillis();
        String token2 = this.signature.sign(saltPlusToken);
        Session session = ctx.session();
        if (session != null) {
            session.put(this.headerName, session.id() + "/" + token2);
        }
        return token2;
    }

    private String getTokenFromSession(RoutingContext ctx) {
        int idx;
        Session session = ctx.session();
        if (session == null) {
            return null;
        }
        String sessionToken = (String)session.get(this.headerName);
        if (sessionToken != null && (idx = sessionToken.indexOf(47)) != -1 && session.id() != null && session.id().equals(sessionToken.substring(0, idx))) {
            return sessionToken.substring(idx + 1);
        }
        return null;
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    private static long parseLong(String s) {
        if (CSRFHandlerImpl.isBlank(s)) {
            return -1L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            LOG.trace("Invalid Token format", e);
            return -1L;
        }
    }

    @Override
    public void handle(RoutingContext ctx) {
        String methodName;
        String uri;
        if (((RoutingContextInternal)ctx).seenHandler(16)) {
            ctx.next();
            return;
        }
        ((RoutingContextInternal)ctx).visitHandler(16);
        if (this.nagHttps && LOG.isTraceEnabled() && (uri = ctx.request().absoluteURI()) != null && !uri.startsWith("https:")) {
            LOG.trace("Using session cookies without https could make you susceptible to session hijacking: " + uri);
        }
        if (!Origin.check(this.origin, ctx)) {
            ctx.fail(403, new VertxException("Invalid Origin", true));
            return;
        }
        switch (methodName = ctx.request().method().name()) {
            case "HEAD": 
            case "GET": {
                this.handleSafeMethod(ctx);
                break;
            }
            case "POST": 
            case "PUT": 
            case "DELETE": 
            case "PATCH": {
                this.handleUnsafeMethod(ctx);
                break;
            }
            default: {
                ctx.next();
            }
        }
    }

    private void handleSafeMethod(RoutingContext ctx) {
        String token2;
        boolean sendCookie = true;
        Session session = ctx.session();
        if (session == null) {
            token2 = this.generateAndStoreToken(ctx);
        } else {
            String sessionToken = this.getTokenFromSession(ctx);
            if (sessionToken == null) {
                token2 = this.generateAndStoreToken(ctx);
            } else {
                String[] parts = sessionToken.split("\\.");
                long ts = CSRFHandlerImpl.parseLong(parts[1]);
                if (ts == -1L) {
                    token2 = this.generateAndStoreToken(ctx);
                } else if (System.currentTimeMillis() <= ts + this.timeout) {
                    token2 = sessionToken;
                    Cookie cookie = ctx.request().getCookie(this.cookieName);
                    if (cookie != null && token2.equals(cookie.getValue())) {
                        sendCookie = false;
                    }
                } else {
                    token2 = this.generateAndStoreToken(ctx);
                }
            }
        }
        this.synchronizeWithClient(ctx, token2, sendCookie);
        ctx.next();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleUnsafeMethod(RoutingContext ctx) {
        byte[] cookieBytes;
        Cookie cookie = ctx.request().getCookie(this.cookieName);
        String header = ctx.request().getHeader(this.headerName);
        if (header == null) {
            if (!ctx.body().available()) {
                ctx.fail(new VertxException("BodyHandler is required to process unsafe methods", true));
                return;
            }
            header = ctx.request().getFormAttribute(this.headerName);
        }
        if (header == null || cookie == null || CSRFHandlerImpl.isBlank(header)) {
            ctx.fail(403, new IllegalArgumentException("Token provided via HTTP Header/Form is absent/empty"));
            return;
        }
        String cookieValue = cookie.getValue();
        if (cookieValue == null || CSRFHandlerImpl.isBlank(cookieValue)) {
            ctx.fail(403, new IllegalArgumentException("Token provided via HTTP Header/Form is absent/empty"));
            return;
        }
        byte[] headerBytes = header.getBytes(StandardCharsets.UTF_8);
        if (!MessageDigest.isEqual(headerBytes, cookieBytes = cookieValue.getBytes(StandardCharsets.UTF_8))) {
            ctx.fail(403, new IllegalArgumentException("Token provided via HTTP Header and via Cookie are not equal"));
            return;
        }
        Session session = ctx.session();
        if (session != null) {
            String sessionToken = (String)session.get(this.headerName);
            if (sessionToken == null) {
                ctx.fail(403, new IllegalArgumentException("No Token has been added to the session"));
                return;
            }
            int idx = sessionToken.indexOf(47);
            if (idx != -1 && session.id() != null && session.id().equals(sessionToken.substring(0, idx))) {
                String challenge = sessionToken.substring(idx + 1);
                if (!MessageDigest.isEqual(challenge.getBytes(StandardCharsets.UTF_8), headerBytes)) {
                    ctx.fail(403, new IllegalArgumentException("Token has been used or is outdated"));
                    return;
                }
            } else {
                ctx.fail(403, new IllegalArgumentException("Token has been issued for a different session"));
                return;
            }
        }
        if (!this.signature.verify(header)) {
            ctx.fail(403, new IllegalArgumentException("Token signature does not match"));
            return;
        }
        String[] tokens = header.split("\\.");
        if (tokens.length != 3) {
            if (session != null) {
                session.remove(this.headerName);
            }
            ctx.fail(403);
            return;
        }
        long ts = CSRFHandlerImpl.parseLong(tokens[1]);
        if (ts == -1L) {
            if (session != null) {
                session.remove(this.headerName);
            }
            ctx.fail(403);
            return;
        }
        if (System.currentTimeMillis() <= ts + this.timeout) {
            String token2 = this.generateAndStoreToken(ctx);
            this.synchronizeWithClient(ctx, token2, true);
            ctx.next();
            return;
        }
        if (session != null) {
            session.remove(this.headerName);
        }
        ctx.fail(403, new IllegalArgumentException("CSRF validity expired"));
    }

    private void synchronizeWithClient(RoutingContext ctx, String token2, boolean cookie) {
        if (cookie) {
            ctx.response().addCookie(Cookie.cookie(this.cookieName, token2).setPath(this.cookiePath).setHttpOnly(this.httpOnly).setSecure(this.cookieSecure).setSameSite(CookieSameSite.STRICT));
        }
        ctx.put(this.headerName, token2);
    }
}

