/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.VertxException;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.CorsHandler;
import io.vertx.ext.web.impl.Origin;
import io.vertx.ext.web.impl.RoutingContextInternal;
import io.vertx.ext.web.impl.Utils;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class CorsHandlerImpl
implements CorsHandler {
    private Set<Pattern> regexOrigins = null;
    private Set<Origin> staticOrigins = null;
    private String allowedMethodsString;
    private String allowedHeadersString;
    private String exposedHeadersString;
    private boolean allowCredentials;
    private String maxAgeSeconds;
    private boolean allowPrivateNetwork;
    private final Set<String> allowedMethods = new LinkedHashSet<String>();
    private final Set<String> allowedHeaders = new LinkedHashSet<String>();
    private final Set<String> exposedHeaders = new LinkedHashSet<String>();

    private boolean starOrigin() {
        return this.regexOrigins == null && this.staticOrigins == null;
    }

    private boolean uniqueOrigin() {
        return this.regexOrigins == null && this.staticOrigins != null && this.staticOrigins.size() == 1;
    }

    @Override
    public CorsHandler addOrigin(String origin2) {
        Objects.requireNonNull(origin2, "'origin' cannot be null");
        if (this.staticOrigins == null) {
            if (origin2.equals("*")) {
                return this;
            }
            this.staticOrigins = new LinkedHashSet<Origin>();
        } else if (origin2.equals("*")) {
            throw new IllegalStateException("Cannot mix '*' with explicit origins");
        }
        this.staticOrigins.add(Origin.parse(origin2));
        return this;
    }

    @Override
    public CorsHandler addOrigins(List<String> origins) {
        Objects.requireNonNull(origins, "'origins' cannot be null");
        for (String origin2 : origins) {
            this.addOrigin(origin2);
        }
        return this;
    }

    @Override
    public CorsHandler addOriginWithRegex(String origin2) {
        Objects.requireNonNull(origin2, "'origin' cannot be null");
        if (this.regexOrigins == null) {
            if (origin2.equals(".*")) {
                return this;
            }
            this.regexOrigins = new LinkedHashSet<Pattern>();
        } else if (origin2.equals(".*")) {
            throw new IllegalStateException("Cannot mix '/.*/' (catch all) with other origins");
        }
        this.regexOrigins.add(Pattern.compile(origin2));
        return this;
    }

    @Override
    public CorsHandler addOriginsWithRegex(List<String> origins) {
        Objects.requireNonNull(origins, "'origins' cannot be null");
        for (String origin2 : origins) {
            this.addOriginWithRegex(origin2);
        }
        return this;
    }

    @Override
    public CorsHandler allowedMethod(HttpMethod method) {
        this.allowedMethods.add(method.name());
        this.allowedMethodsString = String.join((CharSequence)",", this.allowedMethods);
        return this;
    }

    @Override
    public CorsHandler allowedMethods(Set<HttpMethod> methods2) {
        for (HttpMethod method : methods2) {
            this.allowedMethods.add(method.name());
        }
        this.allowedMethodsString = String.join((CharSequence)",", this.allowedMethods);
        return this;
    }

    @Override
    public CorsHandler allowedHeader(String headerName) {
        this.allowedHeaders.add(headerName);
        this.allowedHeadersString = String.join((CharSequence)",", this.allowedHeaders);
        return this;
    }

    @Override
    public CorsHandler allowedHeaders(Set<String> headerNames) {
        this.allowedHeaders.addAll(headerNames);
        this.allowedHeadersString = String.join((CharSequence)",", this.allowedHeaders);
        return this;
    }

    @Override
    public CorsHandler exposedHeader(String headerName) {
        this.exposedHeaders.add(headerName);
        this.exposedHeadersString = String.join((CharSequence)",", this.exposedHeaders);
        return this;
    }

    @Override
    public CorsHandler exposedHeaders(Set<String> headerNames) {
        this.exposedHeaders.addAll(headerNames);
        this.exposedHeadersString = String.join((CharSequence)",", this.exposedHeaders);
        return this;
    }

    @Override
    public CorsHandler allowCredentials(boolean allow) {
        this.allowCredentials = allow;
        return this;
    }

    @Override
    public CorsHandler maxAgeSeconds(int maxAgeSeconds) {
        this.maxAgeSeconds = maxAgeSeconds == -1 ? null : String.valueOf(maxAgeSeconds);
        return this;
    }

    @Override
    public CorsHandler allowPrivateNetwork(boolean allow) {
        this.allowPrivateNetwork = allow;
        return this;
    }

    @Override
    public void handle(RoutingContext context2) {
        HttpServerRequest request = context2.request();
        HttpServerResponse response2 = context2.response();
        String origin2 = context2.request().headers().get(HttpHeaders.ORIGIN);
        if (origin2 == null) {
            if (!this.starOrigin() && !this.uniqueOrigin()) {
                Utils.appendToMapIfAbsent(response2.headers(), HttpHeaders.VARY, ",", HttpHeaders.ORIGIN);
            }
            context2.next();
        } else if (this.isValidOrigin(origin2)) {
            String accessControlRequestMethod = request.headers().get(HttpHeaders.ACCESS_CONTROL_REQUEST_METHOD);
            if (request.method() == HttpMethod.OPTIONS && accessControlRequestMethod != null) {
                this.addCredentialsAndOriginHeader(response2, origin2);
                if (this.allowedMethodsString != null) {
                    response2.putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_METHODS, (CharSequence)this.allowedMethodsString);
                }
                if (this.allowedHeadersString != null) {
                    response2.putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS, (CharSequence)this.allowedHeadersString);
                } else if (request.headers().contains(HttpHeaders.ACCESS_CONTROL_REQUEST_HEADERS)) {
                    response2.putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS, (CharSequence)request.getHeader(HttpHeaders.ACCESS_CONTROL_REQUEST_HEADERS));
                    Utils.appendToMapIfAbsent(response2.headers(), HttpHeaders.VARY, ",", HttpHeaders.ACCESS_CONTROL_REQUEST_HEADERS);
                }
                if (this.maxAgeSeconds != null) {
                    response2.putHeader(HttpHeaders.ACCESS_CONTROL_MAX_AGE, (CharSequence)this.maxAgeSeconds);
                }
                if (request.headers().contains(HttpHeaders.ACCESS_CONTROL_REQUEST_PRIVATE_NETWORK) && this.allowPrivateNetwork) {
                    response2.putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_PRIVATE_NETWORK, (CharSequence)"true");
                }
                response2.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)"0").setStatusCode(204).end();
            } else {
                if (!(this.starOrigin() && !this.allowCredentials || this.uniqueOrigin())) {
                    Utils.appendToMapIfAbsent(response2.headers(), HttpHeaders.VARY, ",", HttpHeaders.ORIGIN);
                }
                this.addCredentialsAndOriginHeader(response2, origin2);
                if (this.exposedHeadersString != null) {
                    response2.putHeader(HttpHeaders.ACCESS_CONTROL_EXPOSE_HEADERS, (CharSequence)this.exposedHeadersString);
                }
                ((RoutingContextInternal)context2).visitHandler(4);
                context2.next();
            }
        } else {
            context2.response().setStatusMessage("CORS Rejected - Invalid origin");
            context2.fail(403, new VertxException("CORS Rejected - Invalid origin", true));
        }
    }

    private void addCredentialsAndOriginHeader(HttpServerResponse response2, String origin2) {
        if (this.allowCredentials) {
            response2.putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS, (CharSequence)"true");
            response2.putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, (CharSequence)origin2);
        } else {
            response2.putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, (CharSequence)this.getAllowedOrigin(origin2));
        }
    }

    private boolean isValidOrigin(String origin2) {
        if (this.starOrigin()) {
            return Origin.isValid(origin2);
        }
        if (this.staticOrigins != null) {
            for (Origin origin3 : this.staticOrigins) {
                if (!origin3.sameOrigin(origin2)) continue;
                return true;
            }
        }
        if (this.regexOrigins != null) {
            for (Pattern pattern : this.regexOrigins) {
                if (!pattern.matcher(origin2).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private String getAllowedOrigin(String origin2) {
        if (this.starOrigin()) {
            return "*";
        }
        return origin2;
    }
}

