/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.ErrorHandler;
import io.vertx.ext.web.impl.Utils;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;

public class ErrorHandlerImpl
implements ErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorHandlerImpl.class);
    private final boolean displayExceptionDetails;
    private final String errorTemplate;

    public ErrorHandlerImpl(Vertx vertx, String errorTemplateName, boolean displayExceptionDetails) {
        Objects.requireNonNull(errorTemplateName);
        this.errorTemplate = vertx.fileSystem().readFileBlocking(errorTemplateName).toString(StandardCharsets.UTF_8);
        this.displayExceptionDetails = displayExceptionDetails;
    }

    @Override
    public void handle(RoutingContext context2) {
        HttpServerResponse response2 = context2.response();
        Throwable failure = context2.failure();
        if (response2.headWritten()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Response headers are already written", failure);
            }
            try {
                context2.request().connection().close();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return;
        }
        int errorCode = context2.statusCode();
        if (errorCode == -1) {
            errorCode = 500;
        }
        response2.setStatusCode(errorCode);
        this.answerWithError(context2, errorCode);
    }

    private void answerWithError(RoutingContext context2, int errorCode) {
        if (!this.sendErrorResponseMIME(context2, errorCode) && !this.sendErrorAcceptMIME(context2, errorCode)) {
            this.sendError(context2, "text/plain", errorCode);
        }
    }

    private boolean sendErrorResponseMIME(RoutingContext context2, int errorCode) {
        String mime = context2.response().headers().get(HttpHeaders.CONTENT_TYPE);
        if (mime == null) {
            mime = context2.getAcceptableContentType();
        }
        return mime != null && this.sendError(context2, mime, errorCode);
    }

    private boolean sendErrorAcceptMIME(RoutingContext context2, int errorCode) {
        List<MIMEHeader> acceptableMimes = context2.parsedHeaders().accept();
        for (MIMEHeader accept : acceptableMimes) {
            if (!this.sendError(context2, accept.value(), errorCode)) continue;
            return true;
        }
        return false;
    }

    private boolean sendError(RoutingContext context2, String mime, int errorCode) {
        String title = "An unexpected error occurred";
        HttpServerResponse response2 = context2.response();
        Throwable exception = context2.failure();
        String errorMessage2 = this.displayExceptionDetails ? (exception == null ? response2.getStatusMessage() : exception.getMessage()) : response2.getStatusMessage();
        if (mime.startsWith("text/html")) {
            StringBuilder stack = null;
            if (exception != null && this.displayExceptionDetails) {
                stack = new StringBuilder();
                for (StackTraceElement elem : exception.getStackTrace()) {
                    stack.append("<li>").append(Utils.escapeHTML(elem.toString())).append("</li>");
                }
            }
            response2.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html");
            response2.end(this.errorTemplate.replace("{title}", "An unexpected error occurred").replace("{errorCode}", Integer.toString(errorCode)).replace("{errorMessage}", ErrorHandlerImpl.htmlFormat(errorMessage2)).replace("{stackTrace}", stack == null ? "" : stack.toString()));
            return true;
        }
        if (mime.startsWith("application/json")) {
            JsonObject jsonError = new JsonObject();
            jsonError.put("error", new JsonObject().put("code", errorCode).put("message", errorMessage2));
            if (exception != null && this.displayExceptionDetails) {
                JsonArray stack = new JsonArray();
                for (StackTraceElement elem : exception.getStackTrace()) {
                    stack.add(elem.toString());
                }
                jsonError.put("stack", stack);
            }
            response2.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
            response2.end(jsonError.encode());
            return true;
        }
        if (mime.startsWith("text/plain")) {
            response2.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain");
            StringBuilder sb = new StringBuilder();
            sb.append("Error ");
            sb.append(errorCode);
            sb.append(": ");
            sb.append(errorMessage2);
            if (exception != null && this.displayExceptionDetails) {
                for (StackTraceElement elem : exception.getStackTrace()) {
                    sb.append("\tat ").append(elem).append("\n");
                }
            }
            response2.end(sb.toString());
            return true;
        }
        return false;
    }

    private static String htmlFormat(String errorMessage2) {
        if (errorMessage2 == null) {
            return "";
        }
        String escaped = Utils.escapeHTML(errorMessage2);
        return escaped.replaceAll("\\r?\\n", "<br>");
    }
}

