/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.audit.Marker;
import io.vertx.ext.auth.audit.SecurityAudit;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.FormLoginHandler;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;
import io.vertx.ext.web.impl.RoutingContextInternal;

public class FormLoginHandlerImpl
extends AuthenticationHandlerImpl<AuthenticationProvider>
implements FormLoginHandler {
    private String usernameParam;
    private String passwordParam;
    private String returnURLParam;
    private String directLoggedInOKURL;
    private static final String DEFAULT_DIRECT_LOGGED_IN_OK_PAGE = "<html><body><h1>Login successful</h1></body></html>";

    @Override
    public FormLoginHandler setUsernameParam(String usernameParam) {
        this.usernameParam = usernameParam;
        return this;
    }

    @Override
    public FormLoginHandler setPasswordParam(String passwordParam) {
        this.passwordParam = passwordParam;
        return this;
    }

    @Override
    public FormLoginHandler setReturnURLParam(String returnURLParam) {
        this.returnURLParam = returnURLParam;
        return this;
    }

    @Override
    public FormLoginHandler setDirectLoggedInOKURL(String directLoggedInOKURL) {
        this.directLoggedInOKURL = directLoggedInOKURL;
        return this;
    }

    public FormLoginHandlerImpl(AuthenticationProvider authProvider, String usernameParam, String passwordParam, String returnURLParam, String directLoggedInOKURL) {
        super(authProvider);
        this.usernameParam = usernameParam;
        this.passwordParam = passwordParam;
        this.returnURLParam = returnURLParam;
        this.directLoggedInOKURL = directLoggedInOKURL;
    }

    @Override
    public Future<User> authenticate(RoutingContext context2) {
        HttpServerRequest req = context2.request();
        if (req.method() != HttpMethod.POST) {
            return Future.failedFuture(BAD_METHOD);
        }
        if (!context2.body().available()) {
            return Future.failedFuture("BodyHandler is required to process POST requests");
        }
        MultiMap params = req.formAttributes();
        String username = params.get(this.usernameParam);
        String password = params.get(this.passwordParam);
        if (username == null || password == null) {
            return Future.failedFuture(BAD_REQUEST);
        }
        SecurityAudit audit = ((RoutingContextInternal)context2).securityAudit();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
        audit.credentials(credentials);
        return this.authProvider.authenticate(new UsernamePasswordCredentials(username, password)).andThen(op -> audit.audit(Marker.AUTHENTICATION, op.succeeded())).recover(err -> Future.failedFuture(new HttpException(401, (Throwable)err)));
    }

    @Override
    public void postAuthentication(RoutingContext ctx) {
        String returnURL;
        HttpServerRequest req = ctx.request();
        Session session = ctx.session();
        if (session != null && (returnURL = (String)session.remove(this.returnURLParam)) != null) {
            ctx.redirect(returnURL);
            return;
        }
        if (this.directLoggedInOKURL != null) {
            ctx.redirect(this.directLoggedInOKURL);
        } else {
            req.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html; charset=utf-8").end(DEFAULT_DIRECT_LOGGED_IN_OK_PAGE);
        }
    }
}

