/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Future;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.RedirectAuthHandler;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;

public class RedirectAuthHandlerImpl
extends AuthenticationHandlerImpl<AuthenticationProvider>
implements RedirectAuthHandler {
    private final String loginRedirectURL;
    private final String returnURLParam;

    public RedirectAuthHandlerImpl(AuthenticationProvider authProvider, String loginRedirectURL, String returnURLParam) {
        super(authProvider);
        this.loginRedirectURL = loginRedirectURL;
        this.returnURLParam = returnURLParam;
    }

    @Override
    public Future<User> authenticate(RoutingContext context2) {
        Session session = context2.session();
        if (session != null) {
            session.put(this.returnURLParam, context2.request().uri());
            return Future.failedFuture(new HttpException(302, this.loginRedirectURL));
        }
        return Future.failedFuture("No session - did you forget to include a SessionHandler?");
    }

    @Override
    public boolean performsRedirect() {
        return true;
    }
}

