/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.ext.auth.audit.Marker;
import io.vertx.ext.auth.audit.SecurityAudit;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.SecurityAuditLoggerHandler;
import io.vertx.ext.web.impl.RoutingContextInternal;

public class SecurityAuditLoggerHandlerImpl
implements SecurityAuditLoggerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityAudit.class);

    public SecurityAuditLoggerHandlerImpl() {
        if (!LOGGER.isInfoEnabled()) {
            throw new IllegalStateException("Security audit logger is not enabled. Please check your logging configuration.");
        }
    }

    @Override
    public void handle(RoutingContext ctx) {
        SecurityAudit audit = SecurityAudit.create();
        ((RoutingContextInternal)ctx).setSecurityAudit(audit);
        HttpServerRequest req = ctx.request();
        HttpServerResponse res = ctx.response();
        audit.source(req.remoteAddress()).destination(req.localAddress()).resource(req.version(), req.method(), ctx.normalizedPath());
        ctx.addEndHandler(end2 -> {
            int status = res.getStatusCode();
            audit.status(status).audit(Marker.REQUEST, status < 400);
        });
        ctx.next();
    }
}

