/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.file.FileProps;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.MimeMapping;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.internal.net.RFC3986;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.web.Http2PushMapping;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.FileSystemAccess;
import io.vertx.ext.web.handler.StaticHandler;
import io.vertx.ext.web.impl.LRUCache;
import io.vertx.ext.web.impl.ParsableMIMEValue;
import io.vertx.ext.web.impl.Utils;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StaticHandlerImpl
implements StaticHandler {
    private static final Logger LOG = LoggerFactory.getLogger(StaticHandlerImpl.class);
    private String webRoot = "webroot";
    private long maxAgeSeconds = 86400L;
    private boolean directoryListing = false;
    private String directoryTemplateResource = "META-INF/vertx/web/vertx-web-directory.html";
    private String directoryTemplate;
    private boolean includeHidden = true;
    private boolean filesReadOnly = true;
    private String indexPage = "index.html";
    private List<Http2PushMapping> http2PushMappings;
    private boolean rangeSupport = true;
    private boolean allowRootFileSystemAccess = false;
    private boolean sendVaryHeader = true;
    private String defaultContentEncoding = Charset.defaultCharset().name();
    private Set<String> compressedMediaTypes = Collections.emptySet();
    private Set<String> compressedFileSuffixes = Collections.emptySet();
    private final FSTune tune = new FSTune();
    private final FSPropsCache cache = new FSPropsCache();
    private static final Pattern RANGE = Pattern.compile("^bytes=(\\d+)-(\\d*)$");
    private static final Collection<MIMEHeader> DIRECTORY_LISTING_ACCEPT = Arrays.asList(new ParsableMIMEValue("text/html").forceParse(), new ParsableMIMEValue("text/plain").forceParse(), new ParsableMIMEValue("application/json").forceParse());

    public StaticHandlerImpl(FileSystemAccess visibility, String staticRootDirectory) {
        switch (visibility) {
            case ROOT: {
                this.allowRootFileSystemAccess = true;
                break;
            }
            case RELATIVE: {
                this.allowRootFileSystemAccess = false;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported visibility: " + String.valueOf((Object)visibility));
            }
        }
        this.setRoot(staticRootDirectory != null ? staticRootDirectory : "webroot");
    }

    private String directoryTemplate(FileSystem fileSystem) {
        if (this.directoryTemplate == null) {
            this.directoryTemplate = fileSystem.readFileBlocking(this.directoryTemplateResource).toString(StandardCharsets.UTF_8);
        }
        return this.directoryTemplate;
    }

    private void writeCacheHeaders(HttpServerRequest request, FileProps props) {
        MultiMap headers = request.response().headers();
        if (this.cache.enabled()) {
            Utils.addToMapIfAbsent(headers, HttpHeaders.CACHE_CONTROL, "public, immutable, max-age=" + this.maxAgeSeconds);
            Utils.addToMapIfAbsent(headers, HttpHeaders.LAST_MODIFIED, Utils.formatRFC1123DateTime(props.lastModifiedTime()));
            if (this.sendVaryHeader && request.headers().contains(HttpHeaders.ACCEPT_ENCODING)) {
                Utils.addToMapIfAbsent(headers, HttpHeaders.VARY, "accept-encoding");
            }
        }
        headers.set("date", Utils.formatRFC1123DateTime(System.currentTimeMillis()));
    }

    @Override
    public void handle(RoutingContext context2) {
        HttpServerRequest request = context2.request();
        if (request.method() != HttpMethod.GET && request.method() != HttpMethod.HEAD) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Not GET or HEAD so ignoring request");
            }
            context2.next();
        } else {
            String uriDecodedPath;
            if (!request.isEnded()) {
                request.pause();
            }
            if ((uriDecodedPath = RFC3986.decodeURIComponent(context2.normalizedPath(), false)) == null) {
                LOG.warn("Invalid path: " + context2.request().path());
                context2.next();
                return;
            }
            String path = RFC3986.removeDotSegments(uriDecodedPath.replace('\\', '/'));
            FileSystem fs = context2.vertx().fileSystem();
            this.sendStatic(context2, fs, path, !this.directoryListing && "/".equals(path));
        }
    }

    private void sendStatic(RoutingContext context2, FileSystem fileSystem, String path, boolean index2) {
        Object localFile;
        boolean dirty;
        CacheEntry entry;
        String file = null;
        if (!this.includeHidden) {
            file = this.getFile(path, context2);
            int idx = file.indexOf(47);
            while (idx >= 0) {
                String name = file.substring(idx + 1);
                if (name.length() > 0 && name.charAt(0) == '.') {
                    if (!context2.request().isEnded()) {
                        context2.request().resume();
                    }
                    context2.next();
                    return;
                }
                idx = file.indexOf(47, idx + 1);
            }
        }
        if ((entry = this.cache.get(path)) != null && (this.filesReadOnly || !entry.isOutOfDate())) {
            if (entry.isMissing()) {
                if (!context2.request().isEnded()) {
                    context2.request().resume();
                }
                context2.next();
                return;
            }
            long lastModified = Utils.secondsFactor(entry.props.lastModifiedTime());
            if (Utils.fresh(context2, lastModified)) {
                context2.response().setStatusCode(HttpResponseStatus.NOT_MODIFIED.code()).end();
                return;
            }
        }
        boolean bl = dirty = this.cache.enabled() && entry != null;
        if (file == null) {
            String ctxFile = this.getFile(path, context2);
            localFile = index2 ? ctxFile + this.indexPage : ctxFile;
        } else {
            localFile = index2 ? file + this.indexPage : file;
        }
        fileSystem.exists((String)localFile).onFailure(err -> {
            if (!context2.request().isEnded()) {
                context2.request().resume();
            }
            context2.fail((Throwable)err);
        }).onSuccess(arg_0 -> this.lambda$sendStatic$3(path, context2, fileSystem, (String)localFile, dirty, index2, arg_0));
    }

    private void sendDirectory(RoutingContext context2, FileSystem fileSystem, String path, String file) {
        if (!path.endsWith("/")) {
            context2.response().putHeader(HttpHeaders.LOCATION, (CharSequence)(path + "/")).setStatusCode(301).end();
            return;
        }
        if (this.directoryListing) {
            this.sendDirectoryListing(fileSystem, file, context2);
        } else if (this.indexPage != null) {
            this.sendStatic(context2, fileSystem, path, true);
        } else {
            if (!context2.request().isEnded()) {
                context2.request().resume();
            }
            context2.fail(HttpResponseStatus.FORBIDDEN.code());
        }
    }

    private Future<FileProps> getFileProps(FileSystem fileSystem, String file) {
        if (this.tune.useAsyncFS()) {
            return fileSystem.props(file);
        }
        try {
            boolean tuneEnabled = this.tune.enabled();
            long start2 = tuneEnabled ? System.nanoTime() : 0L;
            FileProps props = fileSystem.propsBlocking(file);
            if (tuneEnabled) {
                this.tune.update(start2, System.nanoTime());
            }
            return Future.succeededFuture(props);
        }
        catch (RuntimeException e) {
            return Future.failedFuture(e.getCause());
        }
    }

    private void sendFile(RoutingContext context2, FileSystem fileSystem, String file, FileProps fileProps) {
        HttpServerRequest request = context2.request();
        HttpServerResponse response2 = context2.response();
        Long offset2 = null;
        Long end2 = null;
        MultiMap headers = null;
        if (response2.closed()) {
            return;
        }
        if (this.rangeSupport) {
            Matcher m;
            String range = request.getHeader("Range");
            end2 = fileProps.size() - 1L;
            if (range != null && (m = RANGE.matcher(range)).matches()) {
                try {
                    String part = m.group(1);
                    offset2 = Long.parseLong(part);
                    if (offset2 < 0L || offset2 >= fileProps.size()) {
                        throw new IndexOutOfBoundsException();
                    }
                    part = m.group(2);
                    if (part != null && part.length() > 0 && (end2 = Long.valueOf(Math.min(end2, Long.parseLong(part)))) < offset2) {
                        throw new IndexOutOfBoundsException();
                    }
                }
                catch (IndexOutOfBoundsException | NumberFormatException e) {
                    context2.response().putHeader(HttpHeaders.CONTENT_RANGE, (CharSequence)("bytes */" + fileProps.size()));
                    if (!context2.request().isEnded()) {
                        context2.request().resume();
                    }
                    context2.fail(HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE.code());
                    return;
                }
            }
            headers = response2.headers();
            headers.set(HttpHeaders.ACCEPT_RANGES, (CharSequence)"bytes");
            headers.set(HttpHeaders.CONTENT_LENGTH, (CharSequence)Long.toString(end2 + 1L - (offset2 == null ? 0L : offset2)));
        }
        this.writeCacheHeaders(request, fileProps);
        if (request.method() == HttpMethod.HEAD) {
            response2.end();
        } else if (this.rangeSupport && offset2 != null) {
            headers.set(HttpHeaders.CONTENT_RANGE, (CharSequence)("bytes " + offset2 + "-" + end2 + "/" + fileProps.size()));
            response2.setStatusCode(HttpResponseStatus.PARTIAL_CONTENT.code());
            long finalOffset = offset2;
            long finalLength = end2 + 1L - offset2;
            String contentType = MimeMapping.mimeTypeForFilename(file);
            if (contentType != null) {
                if (contentType.startsWith("text")) {
                    response2.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)(contentType + ";charset=" + this.defaultContentEncoding));
                } else {
                    response2.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
                }
            }
            response2.sendFile(file, finalOffset, finalLength).onFailure(err -> {
                if (!context2.request().isEnded()) {
                    context2.request().resume();
                }
                context2.fail((Throwable)err);
            });
        } else {
            String extension = this.getFileExtension(file);
            String contentType = MimeMapping.mimeTypeForExtension(extension);
            if (this.compressedMediaTypes.contains(contentType) || this.compressedFileSuffixes.contains(extension)) {
                response2.putHeader(HttpHeaders.CONTENT_ENCODING, HttpHeaders.IDENTITY);
            }
            if (contentType != null) {
                if (contentType.startsWith("text")) {
                    response2.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)(contentType + ";charset=" + this.defaultContentEncoding));
                } else {
                    response2.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
                }
            }
            if (request.version() == HttpVersion.HTTP_2 && this.http2PushMappings != null) {
                for (Http2PushMapping dependency : this.http2PushMappings) {
                    if (dependency.isNoPush()) continue;
                    String dep = this.webRoot + "/" + dependency.getFilePath();
                    this.getFileProps(fileSystem, dep).onSuccess(fprops -> {
                        this.writeCacheHeaders(request, (FileProps)fprops);
                        response2.push(HttpMethod.GET, "/" + dependency.getFilePath()).onSuccess(res -> {
                            String depContentType = MimeMapping.mimeTypeForExtension(file);
                            if (depContentType != null) {
                                if (depContentType.startsWith("text")) {
                                    res.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)(contentType + ";charset=" + this.defaultContentEncoding));
                                } else {
                                    res.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
                                }
                            }
                            res.sendFile(this.webRoot + "/" + dependency.getFilePath());
                        });
                    });
                }
            } else if (this.http2PushMappings != null) {
                ArrayList<String> links = new ArrayList<String>();
                for (Http2PushMapping dependency : this.http2PushMappings) {
                    String dep = this.webRoot + "/" + dependency.getFilePath();
                    this.getFileProps(fileSystem, dep).onSuccess(fprops -> {
                        this.writeCacheHeaders(request, (FileProps)fprops);
                        links.add("<" + dependency.getFilePath() + ">; rel=preload; as=" + dependency.getExtensionTarget() + (dependency.isNoPush() ? "; nopush" : ""));
                    });
                }
                response2.putHeader("Link", links);
            }
            response2.sendFile(file).onFailure(err -> {
                if (!context2.request().isEnded()) {
                    context2.request().resume();
                }
                context2.fail((Throwable)err);
            });
        }
    }

    @Override
    public StaticHandler setFilesReadOnly(boolean readOnly) {
        this.filesReadOnly = readOnly;
        return this;
    }

    @Override
    public StaticHandler setMaxAgeSeconds(long maxAgeSeconds) {
        if (maxAgeSeconds < 0L) {
            throw new IllegalArgumentException("timeout must be >= 0");
        }
        this.maxAgeSeconds = maxAgeSeconds;
        return this;
    }

    @Override
    public StaticHandler setMaxCacheSize(int maxCacheSize) {
        this.cache.setMaxSize(maxCacheSize);
        return this;
    }

    @Override
    public StaticHandler setCachingEnabled(boolean enabled) {
        this.cache.setEnabled(enabled);
        return this;
    }

    @Override
    public StaticHandler setDirectoryListing(boolean directoryListing) {
        this.directoryListing = directoryListing;
        return this;
    }

    @Override
    public StaticHandler setDirectoryTemplate(String directoryTemplate) {
        this.directoryTemplateResource = directoryTemplate;
        this.directoryTemplate = null;
        return this;
    }

    @Override
    public StaticHandler setEnableRangeSupport(boolean enableRangeSupport) {
        this.rangeSupport = enableRangeSupport;
        return this;
    }

    @Override
    public StaticHandler setIncludeHidden(boolean includeHidden) {
        this.includeHidden = includeHidden;
        return this;
    }

    @Override
    public StaticHandler setCacheEntryTimeout(long timeout2) {
        this.cache.setCacheEntryTimeout(timeout2);
        return this;
    }

    @Override
    public StaticHandler setIndexPage(String indexPage) {
        Objects.requireNonNull(indexPage);
        this.indexPage = indexPage.charAt(0) == '/' ? indexPage.substring(1) : indexPage;
        return this;
    }

    @Override
    public StaticHandler setAlwaysAsyncFS(boolean alwaysAsyncFS) {
        this.tune.setAlwaysAsyncFS(alwaysAsyncFS);
        return this;
    }

    @Override
    public StaticHandler setHttp2PushMapping(List<Http2PushMapping> http2PushMap) {
        if (http2PushMap != null) {
            this.http2PushMappings = new ArrayList<Http2PushMapping>(http2PushMap);
        }
        return this;
    }

    @Override
    public StaticHandler skipCompressionForMediaTypes(Set<String> mediaTypes) {
        if (mediaTypes != null) {
            this.compressedMediaTypes = new HashSet<String>(mediaTypes);
        }
        return this;
    }

    @Override
    public StaticHandler skipCompressionForSuffixes(Set<String> fileSuffixes) {
        if (fileSuffixes != null) {
            this.compressedFileSuffixes = new HashSet<String>(fileSuffixes);
        }
        return this;
    }

    @Override
    public synchronized StaticHandler setEnableFSTuning(boolean enableFSTuning) {
        this.tune.setEnabled(enableFSTuning);
        return this;
    }

    @Override
    public StaticHandler setMaxAvgServeTimeNs(long maxAvgServeTimeNanoSeconds) {
        this.tune.maxAvgServeTimeNanoSeconds = maxAvgServeTimeNanoSeconds;
        return this;
    }

    @Override
    public StaticHandler setSendVaryHeader(boolean sendVaryHeader) {
        this.sendVaryHeader = sendVaryHeader;
        return this;
    }

    @Override
    public StaticHandler setDefaultContentEncoding(String contentEncoding) {
        this.defaultContentEncoding = contentEncoding;
        return this;
    }

    private String getFile(String path, RoutingContext context2) {
        String file = this.webRoot + Utils.pathOffset(path, context2);
        if (LOG.isTraceEnabled()) {
            LOG.trace("File to serve is " + file);
        }
        return file;
    }

    private void setRoot(String webRoot) {
        Objects.requireNonNull(webRoot);
        if (!this.allowRootFileSystemAccess) {
            for (File root : File.listRoots()) {
                if (!webRoot.startsWith(root.getAbsolutePath())) continue;
                throw new IllegalArgumentException("root cannot start with '" + root.getAbsolutePath() + "'");
            }
        }
        this.webRoot = webRoot;
    }

    private void sendDirectoryListing(FileSystem fileSystem, String dir, RoutingContext context2) {
        HttpServerResponse response2 = context2.response();
        fileSystem.readDir(dir).onFailure(err -> {
            if (!context2.request().isEnded()) {
                context2.request().resume();
            }
            context2.fail((Throwable)err);
        }).onSuccess(list2 -> {
            MIMEHeader header;
            List<MIMEHeader> accepts = context2.parsedHeaders().accept();
            Object accept = "text/plain";
            if (accepts != null && (header = context2.parsedHeaders().findBestUserAcceptedIn(context2.parsedHeaders().accept(), DIRECTORY_LISTING_ACCEPT)) != null) {
                accept = header.component() + "/" + header.subComponent();
            }
            switch (accept) {
                case "text/html": {
                    Object normalizedDir = context2.normalizedPath();
                    if (!((String)normalizedDir).endsWith("/")) {
                        normalizedDir = (String)normalizedDir + "/";
                    }
                    StringBuilder files = new StringBuilder("<ul id=\"files\">");
                    Collections.sort(list2);
                    for (String s : list2) {
                        String file = s.substring(s.lastIndexOf(File.separatorChar) + 1);
                        if (!this.includeHidden && file.charAt(0) == '.') continue;
                        files.append("<li><a href=\"");
                        files.append((String)normalizedDir);
                        String encodedUriPath = Utils.encodeUriPath(file);
                        files.append(encodedUriPath);
                        files.append("\" title=\"");
                        String escapedHTML = Utils.escapeHTML(file);
                        files.append(escapedHTML);
                        files.append("\">");
                        files.append(escapedHTML);
                        files.append("</a></li>");
                    }
                    files.append("</ul>");
                    int slashPos = 0;
                    for (int i = ((String)normalizedDir).length() - 2; i > 0; --i) {
                        if (((String)normalizedDir).charAt(i) != '/') continue;
                        slashPos = i;
                        break;
                    }
                    String parent2 = "<a href=\"" + ((String)normalizedDir).substring(0, slashPos + 1) + "\">..</a>";
                    response2.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html").end(this.directoryTemplate(fileSystem).replace("{directory}", (CharSequence)normalizedDir).replace("{parent}", parent2).replace("{files}", files.toString()));
                    break;
                }
                case "application/json": {
                    JsonArray json2 = new JsonArray();
                    for (String s : list2) {
                        String file = s.substring(s.lastIndexOf(File.separatorChar) + 1);
                        if (!this.includeHidden && file.charAt(0) == '.') continue;
                        json2.add(file);
                    }
                    response2.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(json2.encode());
                    break;
                }
                default: {
                    StringBuilder buffer = new StringBuilder();
                    for (String s : list2) {
                        String file = s.substring(s.lastIndexOf(File.separatorChar) + 1);
                        if (!this.includeHidden && file.charAt(0) == '.') continue;
                        buffer.append(file);
                        buffer.append('\n');
                    }
                    response2.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain").end(buffer.toString());
                }
            }
        });
    }

    private String getFileExtension(String file) {
        int li = file.lastIndexOf(46);
        if (li != -1 && li != file.length() - 1) {
            return file.substring(li + 1);
        }
        return null;
    }

    private /* synthetic */ void lambda$sendStatic$3(String path, RoutingContext context2, FileSystem fileSystem, String localFile, boolean dirty, boolean index2, Boolean exists) {
        if (!exists.booleanValue()) {
            if (this.cache.enabled()) {
                this.cache.put(path, null);
            }
            if (!context2.request().isEnded()) {
                context2.request().resume();
            }
            context2.next();
            return;
        }
        this.getFileProps(fileSystem, localFile).onSuccess(fprops -> {
            if (fprops == null) {
                if (dirty) {
                    this.cache.remove(path);
                }
                if (!context2.request().isEnded()) {
                    context2.request().resume();
                }
                context2.next();
            } else if (fprops.isDirectory()) {
                if (index2) {
                    if (this.cache.enabled()) {
                        this.cache.put(path, null);
                    }
                    if (!context2.request().isEnded()) {
                        context2.request().resume();
                    }
                    context2.next();
                } else {
                    if (dirty) {
                        this.cache.remove(path);
                    }
                    this.sendDirectory(context2, fileSystem, path, localFile);
                }
            } else {
                if (this.cache.enabled()) {
                    this.cache.put(path, (FileProps)fprops);
                    if (Utils.fresh(context2, Utils.secondsFactor(fprops.lastModifiedTime()))) {
                        context2.response().setStatusCode(HttpResponseStatus.NOT_MODIFIED.code()).end();
                        return;
                    }
                }
                this.sendFile(context2, fileSystem, localFile, (FileProps)fprops);
            }
        }).onFailure(err -> {
            if (!context2.request().isEnded()) {
                context2.request().resume();
            }
            context2.fail((Throwable)err);
        });
    }

    private static class FSPropsCache {
        private Map<String, CacheEntry> propsCache;
        private long cacheEntryTimeout = 30000L;
        private int maxCacheSize = 10000;

        FSPropsCache() {
            this.setEnabled(StaticHandler.DEFAULT_CACHING_ENABLED);
        }

        boolean enabled() {
            return this.propsCache != null;
        }

        synchronized void setMaxSize(int maxCacheSize) {
            if (maxCacheSize < 1) {
                throw new IllegalArgumentException("maxCacheSize must be >= 1");
            }
            if (this.maxCacheSize != maxCacheSize) {
                this.maxCacheSize = maxCacheSize;
                this.setEnabled(this.enabled(), true);
            }
        }

        void setEnabled(boolean enable) {
            this.setEnabled(enable, false);
        }

        private synchronized void setEnabled(boolean enable, boolean force) {
            if (force || enable != this.enabled()) {
                if (this.propsCache != null) {
                    this.propsCache.clear();
                }
                this.propsCache = enable ? new LRUCache<String, CacheEntry>(this.maxCacheSize) : null;
            }
        }

        void setCacheEntryTimeout(long timeout2) {
            if (timeout2 < 1L) {
                throw new IllegalArgumentException("timeout must be >= 1");
            }
            this.cacheEntryTimeout = timeout2;
        }

        private void remove(String path) {
            if (this.propsCache != null) {
                this.propsCache.remove(path);
            }
        }

        CacheEntry get(String key) {
            if (this.propsCache != null) {
                return this.propsCache.get(key);
            }
            return null;
        }

        void put(String path, FileProps props) {
            if (this.propsCache != null) {
                CacheEntry now = new CacheEntry(props, this.cacheEntryTimeout);
                this.propsCache.put(path, now);
            }
        }
    }

    private static class FSTune {
        private static final int NUM_SERVES_TUNING_FS_ACCESS = 1000;
        private volatile boolean enabled = true;
        private volatile boolean useAsyncFS;
        private long totalTime;
        private long numServesBlocking;
        private long nextAvgCheck = 1000L;
        private long maxAvgServeTimeNanoSeconds = 1000000L;
        private boolean alwaysAsyncFS = false;

        private FSTune() {
        }

        boolean enabled() {
            return this.enabled;
        }

        boolean useAsyncFS() {
            return this.alwaysAsyncFS || this.useAsyncFS;
        }

        synchronized void setEnabled(boolean enabled) {
            this.enabled = enabled;
            if (!enabled) {
                this.reset();
            }
        }

        void setAlwaysAsyncFS(boolean alwaysAsyncFS) {
            this.alwaysAsyncFS = alwaysAsyncFS;
        }

        synchronized void update(long start2, long end2) {
            long dur = end2 - start2;
            this.totalTime += dur;
            ++this.numServesBlocking;
            if (this.numServesBlocking == Long.MAX_VALUE) {
                this.reset();
            } else if (this.numServesBlocking == this.nextAvgCheck) {
                double avg = (double)this.totalTime / (double)this.numServesBlocking;
                if (avg > (double)this.maxAvgServeTimeNanoSeconds) {
                    this.useAsyncFS = true;
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Switching to async file system access in static file server as fs access is slow! (Average access time of " + avg + " ns)");
                    }
                    this.enabled = false;
                }
                this.nextAvgCheck += 1000L;
            }
        }

        synchronized void reset() {
            this.nextAvgCheck = 1000L;
            this.totalTime = 0L;
            this.numServesBlocking = 0L;
        }
    }

    private static final class CacheEntry {
        final long createDate = System.currentTimeMillis();
        final FileProps props;
        final long cacheEntryTimeout;

        private CacheEntry(FileProps props, long cacheEntryTimeout) {
            this.props = props;
            this.cacheEntryTimeout = cacheEntryTimeout;
        }

        boolean isOutOfDate() {
            return System.currentTimeMillis() - this.createDate > this.cacheEntryTimeout;
        }

        public boolean isMissing() {
            return this.props == null;
        }
    }
}

