/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.LanguageHeader;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.common.template.TemplateEngine;
import io.vertx.ext.web.handler.TemplateHandler;
import io.vertx.ext.web.impl.Utils;
import java.util.Locale;

public class TemplateHandlerImpl
implements TemplateHandler {
    private final TemplateEngine engine;
    private final String templateDirectory;
    private final String contentType;
    private String indexTemplate;

    public TemplateHandlerImpl(TemplateEngine engine, String templateDirectory, String contentType) {
        this.engine = engine;
        this.templateDirectory = templateDirectory == null || templateDirectory.isEmpty() ? "." : templateDirectory;
        this.contentType = contentType;
        this.indexTemplate = "index";
    }

    @Override
    public void handle(RoutingContext context2) {
        Object file = Utils.pathOffset(context2.normalizedPath(), context2);
        if (((String)file).endsWith("/") && null != this.indexTemplate) {
            file = (String)file + this.indexTemplate;
        }
        if (this.templateDirectory == null || "".equals(this.templateDirectory)) {
            file = ((String)file).substring(1);
        }
        if (!context2.data().containsKey("lang")) {
            for (LanguageHeader acceptableLocale : context2.acceptableLanguages()) {
                try {
                    Locale.forLanguageTag(acceptableLocale.value());
                }
                catch (RuntimeException e) {
                    continue;
                }
                context2.data().put("lang", acceptableLocale.value());
                break;
            }
        }
        if (!context2.request().isEnded()) {
            context2.request().pause();
        }
        this.engine.render(context2.data(), this.templateDirectory + (String)file).onSuccess(data2 -> {
            if (!context2.request().isEnded()) {
                context2.request().resume();
            }
            context2.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)this.contentType).end((Buffer)data2);
        }).onFailure(err -> {
            if (!context2.request().isEnded()) {
                context2.request().resume();
            }
            context2.fail((Throwable)err);
        });
    }

    @Override
    public TemplateHandler setIndexTemplate(String indexTemplate) {
        this.indexTemplate = indexTemplate;
        return this;
    }
}

