/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Timer;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.TimeoutHandler;

public class TimeoutHandlerImpl
implements TimeoutHandler {
    private final long timeout;
    private final int errorCode;

    public TimeoutHandlerImpl(long timeout2, int errorCode) {
        this.timeout = timeout2;
        this.errorCode = errorCode;
    }

    @Override
    public void handle(RoutingContext ctx) {
        Timer timer = ctx.vertx().timer(this.timeout);
        int handlerId = ctx.addEndHandler(v -> timer.cancel());
        timer.onSuccess(v -> {
            if (ctx.removeEndHandler(handlerId)) {
                if (!ctx.request().isEnded()) {
                    ctx.request().resume();
                }
                ctx.fail(this.errorCode);
            }
        });
        ctx.next();
    }
}

