/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.ClusterSerializable;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.UserContextInternal;
import io.vertx.ext.web.impl.Utils;
import java.nio.charset.StandardCharsets;

public class UserHolder
implements ClusterSerializable {
    private RoutingContext context;
    private User user;

    public UserHolder() {
    }

    public UserHolder(RoutingContext context2) {
        this.context = context2;
    }

    public synchronized void refresh(RoutingContext context2) {
        if (this.context != null) {
            this.user = this.context.user();
        }
        this.context = context2;
        if (this.user != null) {
            ((UserContextInternal)this.context.userContext()).setUser(this.user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToBuffer(Buffer buffer) {
        User user;
        UserHolder userHolder = this;
        synchronized (userHolder) {
            user = this.context != null ? this.context.user() : this.user;
            this.context = null;
        }
        if (user instanceof ClusterSerializable) {
            buffer.appendByte((byte)1);
            String className = user.getClass().getName();
            byte[] bytes = className.getBytes(StandardCharsets.UTF_8);
            buffer.appendInt(bytes.length);
            buffer.appendBytes(bytes);
            ClusterSerializable cs = (ClusterSerializable)((Object)user);
            cs.writeToBuffer(buffer);
        } else {
            buffer.appendByte((byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readFromBuffer(int pos, Buffer buffer) {
        block12: {
            byte b;
            if ((b = buffer.getByte(pos++)) == 1) {
                int len = buffer.getInt(pos);
                byte[] bytes = buffer.getBytes(pos += 4, pos + len);
                pos += len;
                String className = new String(bytes, StandardCharsets.UTF_8);
                try {
                    ClusterSerializable obj;
                    if (className.equals("io.vertx.ext.auth.impl.UserImpl")) {
                        obj = (ClusterSerializable)((Object)User.create(new JsonObject()));
                    } else {
                        Class<?> clazz = Utils.getClassLoader().loadClass(className);
                        if (!ClusterSerializable.class.isAssignableFrom(clazz)) {
                            throw new ClassCastException(className + " is not ClusterSerializable");
                        }
                        obj = (ClusterSerializable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    pos = obj.readFromBuffer(pos, buffer);
                    UserHolder userHolder = this;
                    synchronized (userHolder) {
                        this.user = (User)((Object)obj);
                        this.context = null;
                        break block12;
                    }
                }
                catch (Exception e) {
                    throw new VertxException(e);
                }
            }
            UserHolder userHolder = this;
            synchronized (userHolder) {
                this.user = null;
                this.context = null;
            }
        }
        return pos;
    }
}

