/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.ext.web.AllowForwardHeaders;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.RouteImpl;
import io.vertx.ext.web.impl.RouterState;
import io.vertx.ext.web.impl.RoutingContextImpl;
import io.vertx.ext.web.impl.RoutingContextInternal;
import io.vertx.ext.web.impl.RoutingContextWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RouterImpl
implements Router {
    private static final Logger LOG = LoggerFactory.getLogger(RouterImpl.class);
    private final Vertx vertx;
    private volatile RouterState state;

    public RouterImpl(Vertx vertx) {
        this.vertx = vertx;
        this.state = new RouterState(this);
    }

    @Override
    public synchronized Router putMetadata(String key, Object value) {
        this.state = this.state.putMetadata(key, value);
        return this;
    }

    @Override
    public Map<String, Object> metadata() {
        Map<String, Object> metadata2 = this.state.getMetadata();
        return metadata2 != null ? metadata2 : Collections.emptyMap();
    }

    @Override
    public void handle(HttpServerRequest request) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Router: " + System.identityHashCode(this) + " accepting request " + String.valueOf(request.method()) + " " + request.absoluteURI());
        }
        RoutingContextImpl routingContext = new RoutingContextImpl(null, this, request, this.state.getRoutes());
        routingContext.route();
    }

    @Override
    public synchronized Route route() {
        this.state = this.state.incrementOrderSequence();
        return new RouteImpl(this, this.state.getOrderSequence());
    }

    @Override
    public synchronized Route route(HttpMethod method, String path) {
        this.state = this.state.incrementOrderSequence();
        return new RouteImpl(this, this.state.getOrderSequence(), method, path);
    }

    @Override
    public synchronized Route route(String path) {
        this.state = this.state.incrementOrderSequence();
        return new RouteImpl(this, this.state.getOrderSequence(), path);
    }

    @Override
    public synchronized Route routeWithRegex(HttpMethod method, String regex) {
        this.state = this.state.incrementOrderSequence();
        return new RouteImpl(this, this.state.getOrderSequence(), method, regex, true);
    }

    @Override
    public synchronized Route routeWithRegex(String regex) {
        this.state = this.state.incrementOrderSequence();
        return new RouteImpl(this, this.state.getOrderSequence(), regex, true);
    }

    @Override
    public Route get() {
        return this.route().method(HttpMethod.GET);
    }

    @Override
    public Route get(String path) {
        return this.route(HttpMethod.GET, path);
    }

    @Override
    public Route getWithRegex(String path) {
        return this.route().method(HttpMethod.GET).pathRegex(path);
    }

    @Override
    public Route head() {
        return this.route().method(HttpMethod.HEAD);
    }

    @Override
    public Route head(String path) {
        return this.route(HttpMethod.HEAD, path);
    }

    @Override
    public Route headWithRegex(String path) {
        return this.route().method(HttpMethod.HEAD).pathRegex(path);
    }

    @Override
    public Route options() {
        return this.route().method(HttpMethod.OPTIONS);
    }

    @Override
    public Route options(String path) {
        return this.route(HttpMethod.OPTIONS, path);
    }

    @Override
    public Route optionsWithRegex(String path) {
        return this.route().method(HttpMethod.OPTIONS).pathRegex(path);
    }

    @Override
    public Route put() {
        return this.route().method(HttpMethod.PUT);
    }

    @Override
    public Route put(String path) {
        return this.route(HttpMethod.PUT, path);
    }

    @Override
    public Route putWithRegex(String path) {
        return this.route().method(HttpMethod.PUT).pathRegex(path);
    }

    @Override
    public Route post() {
        return this.route().method(HttpMethod.POST);
    }

    @Override
    public Route post(String path) {
        return this.route(HttpMethod.POST, path);
    }

    @Override
    public Route postWithRegex(String path) {
        return this.route().method(HttpMethod.POST).pathRegex(path);
    }

    @Override
    public Route delete() {
        return this.route().method(HttpMethod.DELETE);
    }

    @Override
    public Route delete(String path) {
        return this.route(HttpMethod.DELETE, path);
    }

    @Override
    public Route deleteWithRegex(String path) {
        return this.route().method(HttpMethod.DELETE).pathRegex(path);
    }

    @Override
    public Route trace() {
        return this.route().method(HttpMethod.TRACE);
    }

    @Override
    public Route trace(String path) {
        return this.route(HttpMethod.TRACE, path);
    }

    @Override
    public Route traceWithRegex(String path) {
        return this.route().method(HttpMethod.TRACE).pathRegex(path);
    }

    @Override
    public Route connect() {
        return this.route().method(HttpMethod.CONNECT);
    }

    @Override
    public Route connect(String path) {
        return this.route(HttpMethod.CONNECT, path);
    }

    @Override
    public Route connectWithRegex(String path) {
        return this.route().method(HttpMethod.CONNECT).pathRegex(path);
    }

    @Override
    public Route patch() {
        return this.route().method(HttpMethod.PATCH);
    }

    @Override
    public Route patch(String path) {
        return this.route(HttpMethod.PATCH, path);
    }

    @Override
    public Route patchWithRegex(String path) {
        return this.route().method(HttpMethod.PATCH).pathRegex(path);
    }

    @Override
    public List<Route> getRoutes() {
        return new ArrayList<Route>(this.state.getRoutes());
    }

    @Override
    public synchronized Router clear() {
        this.state = this.state.clearRoutes();
        return this;
    }

    @Override
    public void handleContext(RoutingContext ctx) {
        RoutingContextInternal ctxi = (RoutingContextInternal)ctx;
        new RoutingContextWrapper(this.getAndCheckRoutePath(ctxi), this.state.getRoutes(), ctxi, this).next();
    }

    @Override
    public void handleFailure(RoutingContext ctx) {
        RoutingContextInternal ctxi = (RoutingContextInternal)ctx;
        new RoutingContextWrapper(this.getAndCheckRoutePath(ctxi), this.state.getRoutes(), ctxi, this).next();
    }

    @Override
    public synchronized Router modifiedHandler(Handler<Router> handler) {
        if (this.state.getModifiedHandler() == null) {
            this.state = this.state.setModifiedHandler(handler);
        } else {
            Handler<Router> previousHandler = this.state.getModifiedHandler();
            this.state = this.state.setModifiedHandler(router -> {
                try {
                    previousHandler.handle((Router)router);
                }
                catch (RuntimeException e) {
                    LOG.error("Router modified notification failed", e);
                }
                try {
                    handler.handle((Router)router);
                }
                catch (RuntimeException e) {
                    LOG.error("Router modified notification failed", e);
                }
            });
        }
        return this;
    }

    @Override
    public synchronized Router allowForward(AllowForwardHeaders allowForwardHeaders) {
        this.state = this.state.setAllowForward(allowForwardHeaders);
        return this;
    }

    public AllowForwardHeaders getAllowForward() {
        return this.state.getAllowForward();
    }

    @Override
    public synchronized Router errorHandler(int statusCode, Handler<RoutingContext> errorHandler) {
        this.state = this.state.putErrorHandler(statusCode, errorHandler);
        return this;
    }

    synchronized void add(RouteImpl route) {
        this.state = this.state.addRoute(route);
        if (this.state.getModifiedHandler() != null) {
            this.state.getModifiedHandler().handle(this);
        }
    }

    synchronized void remove(RouteImpl route) {
        this.state = this.state.removeRoute(route);
        if (this.state.getModifiedHandler() != null) {
            this.state.getModifiedHandler().handle(this);
        }
    }

    Vertx vertx() {
        return this.vertx;
    }

    Iterator<RouteImpl> iterator() {
        return this.state.getRoutes().iterator();
    }

    Handler<RoutingContext> getErrorHandlerByStatusCode(int statusCode) {
        return this.state.getErrorHandler(statusCode);
    }

    private String getAndCheckRoutePath(RoutingContextInternal ctx) {
        Route route = ctx.currentRoute();
        if (!route.isRegexPath()) {
            if (route.getPath() == null) {
                return "/";
            }
            return route.getPath();
        }
        if (ctx.restIndex() != -1) {
            return ctx.basePath();
        }
        throw new IllegalStateException("Sub routers must be mounted on paths (constant or parameterized)");
    }

    public String toString() {
        return "RouterImpl@" + System.identityHashCode(this) + "{vertx=" + String.valueOf(this.vertx) + ", state=" + String.valueOf(this.state) + "}";
    }
}

