/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.ext.web.impl.Utils;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Signature {
    private static final Logger LOG = LoggerFactory.getLogger(Signature.class);
    private static final String algorithm = "HmacSHA256";
    private final Mac mac;

    public Signature(String secret) {
        try {
            if (secret.length() <= 8) {
                LOG.warn("Signing secret is very short (<= 8 bytes)");
            }
            this.mac = Mac.getInstance(algorithm);
            this.mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), algorithm));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sign(String data2) {
        String signature2;
        Mac mac = this.mac;
        synchronized (mac) {
            signature2 = Utils.base64UrlEncode(this.mac.doFinal(data2.getBytes(StandardCharsets.US_ASCII)));
        }
        return data2 + "." + signature2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(String signedData) {
        String calculatedSignature;
        String[] parts = signedData.split("\\.");
        if (parts.length < 2) {
            return false;
        }
        String signature2 = parts[parts.length - 1];
        CharSequence[] dataParts = Arrays.copyOfRange(parts, 0, parts.length - 1);
        String data2 = String.join((CharSequence)".", dataParts);
        Mac mac = this.mac;
        synchronized (mac) {
            calculatedSignature = Utils.base64UrlEncode(this.mac.doFinal(data2.getBytes(StandardCharsets.US_ASCII)));
        }
        return MessageDigest.isEqual(calculatedSignature.getBytes(StandardCharsets.US_ASCII), signature2.getBytes(StandardCharsets.US_ASCII));
    }

    public String parse(String signedData) {
        if (!this.verify(signedData)) {
            return null;
        }
        String[] parts = signedData.split("\\.");
        CharSequence[] dataParts = Arrays.copyOfRange(parts, 0, parts.length - 1);
        return String.join((CharSequence)".", dataParts);
    }
}

