/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.internal.net.RFC3986;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Base64;
import java.util.Locale;
import java.util.regex.Pattern;

public class Utils {
    private static final Base64.Encoder BASE64_URL_ENCODER = Base64.getUrlEncoder().withoutPadding();
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static final ZoneId ZONE_GMT = ZoneId.of("GMT");
    private static final DateTimeFormatter STRFTIME = DateTimeFormatter.ofPattern("dd/MMM/yyyy:HH:mm:ss Z").withLocale(Locale.US);
    private static final Pattern CACHE_CONTROL_NO_CACHE_REGEXP = Pattern.compile("(?:^|,)\\s*?no-cache\\s*?(?:,|$)");

    public static String base64UrlEncode(byte[] bytes) {
        return BASE64_URL_ENCODER.encodeToString(bytes);
    }

    public static byte[] base64Decode(String base64) {
        return BASE64_DECODER.decode(base64);
    }

    public static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null && (cl = Utils.class.getClassLoader()) == null) {
            cl = Object.class.getClassLoader();
        }
        return cl;
    }

    public static String formatRFC1123DateTime(long time) {
        return DateTimeFormatter.RFC_1123_DATE_TIME.format(Instant.ofEpochMilli(time).atZone(ZONE_GMT));
    }

    public static String formatStrftimeDateTime(long time) {
        return STRFTIME.format(Instant.ofEpochMilli(time).atZone(ZoneId.systemDefault()));
    }

    public static long parseRFC1123DateTime(String header) {
        try {
            return header == null || header.isEmpty() ? -1L : LocalDateTime.parse(header, DateTimeFormatter.RFC_1123_DATE_TIME).toInstant(ZoneOffset.UTC).toEpochMilli();
        }
        catch (DateTimeParseException ex) {
            return -1L;
        }
    }

    public static String pathOffset(String path, RoutingContext context2) {
        String routePath;
        String rest;
        Route route = context2.currentRoute();
        if (route == null) {
            return path;
        }
        if (!route.isExactPath() && (rest = context2.pathParam("*")) != null) {
            if (rest.length() > 0) {
                if ((rest = RFC3986.removeDotSegments(rest.replace('\\', '/'))).charAt(0) == '/') {
                    return rest;
                }
                return "/" + rest;
            }
            return "/";
        }
        int prefixLen = 0;
        String mountPoint = context2.mountPoint();
        if (mountPoint != null) {
            prefixLen = mountPoint.length();
            if (mountPoint.charAt(mountPoint.length() - 1) == '/') {
                --prefixLen;
            }
        }
        if (!route.isRegexPath() && (routePath = route.getPath()) != null) {
            prefixLen += routePath.length();
            if (routePath.charAt(routePath.length() - 1) == '/') {
                --prefixLen;
            }
        }
        return prefixLen != 0 ? path.substring(prefixLen) : path;
    }

    public static long secondsFactor(long millis) {
        return millis - millis % 1000L;
    }

    public static boolean isJsonContentType(String contentType) {
        return contentType.contains("application/json") || contentType.contains("+json");
    }

    public static boolean isXMLContentType(String contentType) {
        return contentType.contains("application/xml") || contentType.contains("text/xml") || contentType.contains("+xml");
    }

    public static void addToMapIfAbsent(MultiMap map2, CharSequence key, CharSequence value) {
        if (!map2.contains(key)) {
            map2.set(key, value);
        }
    }

    public static void appendToMapIfAbsent(MultiMap map2, CharSequence key, CharSequence sep, CharSequence value) {
        if (!map2.contains(key)) {
            map2.set(key, value);
        } else {
            String existing = map2.get(key);
            map2.set(key, (CharSequence)(existing + String.valueOf(sep) + String.valueOf(value)));
        }
    }

    public static boolean fresh(RoutingContext ctx) {
        return Utils.fresh(ctx, -1L);
    }

    public static boolean fresh(RoutingContext ctx, long lastModified) {
        HttpServerRequest req = ctx.request();
        HttpServerResponse res = ctx.response();
        String modifiedSince = req.getHeader(HttpHeaders.IF_MODIFIED_SINCE);
        String noneMatch = req.getHeader(HttpHeaders.IF_NONE_MATCH);
        if (modifiedSince == null && noneMatch == null) {
            return false;
        }
        String cacheControl = req.getHeader(HttpHeaders.CACHE_CONTROL);
        if (cacheControl != null && CACHE_CONTROL_NO_CACHE_REGEXP.matcher(cacheControl).find()) {
            return false;
        }
        if (noneMatch != null && !"*".equals(noneMatch)) {
            String match;
            String etag = res.headers().get(HttpHeaders.ETAG);
            if (etag == null) {
                return false;
            }
            boolean etagStale = true;
            int end2 = 0;
            int start2 = 0;
            block4: for (int i = 0; i < noneMatch.length(); ++i) {
                switch (noneMatch.charAt(i)) {
                    case ' ': {
                        if (start2 != end2) continue block4;
                        start2 = end2 = i + 1;
                        continue block4;
                    }
                    case ',': {
                        String match2 = noneMatch.substring(start2, end2);
                        if (match2.equals(etag) || match2.equals("W/" + etag) || ("W/" + match2).equals(etag)) {
                            etagStale = false;
                            break block4;
                        }
                        start2 = end2 = i + 1;
                        continue block4;
                    }
                    default: {
                        end2 = i + 1;
                    }
                }
            }
            if (etagStale && !(match = noneMatch.substring(start2, end2)).equals(etag) && !match.equals("W/" + etag) && !("W/" + match).equals(etag)) {
                return false;
            }
        }
        if (modifiedSince != null) {
            if (lastModified == -1L) {
                lastModified = Utils.parseRFC1123DateTime(res.headers().get(HttpHeaders.LAST_MODIFIED));
            }
            boolean modifiedStale = lastModified == -1L || lastModified > Utils.parseRFC1123DateTime(modifiedSince);
            return !modifiedStale;
        }
        return true;
    }

    public static String escapeHTML(String s) {
        StringBuilder out = new StringBuilder(Math.max(16, s.length()));
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f' || c == '\"' || c == '\'' || c == '<' || c == '>' || c == '&') {
                out.append("&#");
                out.append((int)c);
                out.append(';');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String encodeUriPath(String path) {
        byte[] bytes = path.getBytes(StandardCharsets.UTF_8);
        boolean needsReplacement = false;
        for (byte b : bytes) {
            if (!Utils.isAllowedForPath(b)) continue;
            needsReplacement = true;
            break;
        }
        if (!needsReplacement) {
            return path;
        }
        return Utils.replaceCharactersForUriPath(bytes);
    }

    private static String replaceCharactersForUriPath(byte[] bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2 * bytes.length);
        for (byte b : bytes) {
            if (Utils.isAllowedForPath(b)) {
                baos.write(b);
                continue;
            }
            baos.write(37);
            baos.write(Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16)));
            baos.write(Character.toUpperCase(Character.forDigit(b & 0xF, 16)));
        }
        return baos.toString(StandardCharsets.UTF_8);
    }

    private static boolean isAllowedForPath(byte c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || 45 == c || 46 == c || 95 == c || 126 == c || 33 == c || 36 == c || 38 == c || 39 == c || 40 == c || 41 == c || 42 == c || 43 == c || 44 == c || 59 == c || 61 == c || 58 == c || 64 == c || 47 == c;
    }
}

