/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.ClusterSerializable;
import io.vertx.ext.auth.prng.VertxContextPRNG;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.impl.Utils;
import io.vertx.ext.web.sstore.impl.SessionInternal;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public abstract class AbstractSession
implements Session,
SessionInternal {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final byte TYPE_LONG = 1;
    private static final byte TYPE_INT = 2;
    private static final byte TYPE_SHORT = 3;
    private static final byte TYPE_BYTE = 4;
    private static final byte TYPE_DOUBLE = 5;
    private static final byte TYPE_FLOAT = 6;
    private static final byte TYPE_CHAR = 7;
    private static final byte TYPE_BOOLEAN = 8;
    private static final byte TYPE_STRING = 9;
    private static final byte TYPE_BUFFER = 10;
    private static final byte TYPE_BYTES = 11;
    private static final byte TYPE_CLUSTER_SERIALIZABLE = 13;
    private static final char[] HEX = "0123456789abcdef".toCharArray();
    private VertxContextPRNG prng;
    private String id;
    private long timeout;
    private volatile Map<String, Object> data;
    private long lastAccessed;
    private int version;
    private boolean destroyed;
    private boolean renewed;
    private String oldId;
    private int crc;

    protected void setId(String id) {
        this.id = id;
    }

    protected void setTimeout(long timeout2) {
        this.timeout = timeout2;
    }

    protected void setData(Map<String, Object> data2) {
        if (data2 != null) {
            this.data = data2;
            this.crc = this.checksum();
        }
    }

    protected void setData(JsonObject data2) {
        if (data2 != null) {
            this.setData(data2.getMap());
        }
    }

    protected void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    protected void setVersion(int version) {
        this.version = version;
    }

    public AbstractSession() {
    }

    public AbstractSession(VertxContextPRNG random) {
        this.prng = random;
    }

    public AbstractSession(VertxContextPRNG random, long timeout2, int length) {
        this.prng = random;
        this.id = AbstractSession.generateId(this.prng, length);
        this.timeout = timeout2;
        this.lastAccessed = System.currentTimeMillis();
    }

    public void setPRNG(VertxContextPRNG prng) {
        this.prng = prng;
    }

    @Override
    public void flushed(boolean skipCrc) {
        this.renewed = false;
        if (this.oldId != null) {
            if (!skipCrc) {
                this.crc = this.checksum();
            }
            this.oldId = null;
        }
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Session regenerateId() {
        if (this.oldId == null) {
            this.oldId = this.id;
        }
        this.id = AbstractSession.generateId(this.prng, this.oldId.length() / 2);
        this.renewed = true;
        return this;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    @Override
    public <T> @Nullable T get(String key) {
        if (this.isEmpty()) {
            return null;
        }
        Object obj = this.data().get(key);
        return (T)obj;
    }

    @Override
    public Session put(String key, Object obj) {
        Map<String, Object> data2 = this.data();
        if (obj == null) {
            data2.remove(key);
        } else {
            data2.put(key, obj);
        }
        return this;
    }

    @Override
    public Session putIfAbsent(String key, Object obj) {
        this.data().putIfAbsent(key, obj);
        return this;
    }

    @Override
    public Session computeIfAbsent(String key, Function<String, Object> mappingFunction) {
        this.data().computeIfAbsent(key, mappingFunction);
        return this;
    }

    @Override
    public <T> @Nullable T remove(String key) {
        if (this.isEmpty()) {
            return null;
        }
        Object obj = this.data().remove(key);
        return (T)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> data() {
        if (this.data == null) {
            AbstractSession abstractSession = this;
            synchronized (abstractSession) {
                if (this.data == null) {
                    if (this.destroyed) {
                        this.regenerateId();
                        this.destroyed = false;
                    }
                    this.data = new ConcurrentHashMap<String, Object>();
                }
            }
        }
        return this.data;
    }

    @Override
    public boolean isEmpty() {
        return this.data == null || this.data.size() == 0;
    }

    @Override
    public long lastAccessed() {
        return this.lastAccessed;
    }

    @Override
    public void setAccessed() {
        this.lastAccessed = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.destroyed = true;
            this.data = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public boolean isRegenerated() {
        return this.renewed;
    }

    @Override
    public String oldId() {
        return this.oldId;
    }

    public int version() {
        return this.version;
    }

    public void incrementVersion() {
        int old = this.crc;
        this.crc = this.checksum();
        if (this.crc != old) {
            ++this.version;
        }
    }

    private static String generateId(VertxContextPRNG rng, int length) {
        byte[] bytes = new byte[length];
        rng.nextBytes(bytes);
        char[] hex = new char[length * 2];
        for (int j = 0; j < length; ++j) {
            int v = bytes[j] & 0xFF;
            hex[j * 2] = HEX[v >>> 4];
            hex[j * 2 + 1] = HEX[v & 0xF];
        }
        return new String(hex);
    }

    protected int crc() {
        return this.crc;
    }

    protected int checksum() {
        if (this.isEmpty()) {
            return 0;
        }
        int result2 = 1;
        for (Map.Entry<String, Object> kv : this.data.entrySet()) {
            String key = kv.getKey();
            result2 = 31 * result2 + key.hashCode();
            Object value = kv.getValue();
            if (value == null) continue;
            result2 = 31 * result2 + value.hashCode();
        }
        return result2;
    }

    protected void writeDataToBuffer(Buffer buffer) {
        if (this.isEmpty()) {
            buffer.appendInt(0);
        } else {
            Map<String, Object> data2 = this.data();
            buffer.appendInt(data2.size());
            for (Map.Entry<String, Object> entry : data2.entrySet()) {
                byte[] bytes;
                String key = entry.getKey();
                byte[] keyBytes = key.getBytes(UTF8);
                buffer.appendInt(keyBytes.length).appendBytes(keyBytes);
                Object val = entry.getValue();
                if (val instanceof Long) {
                    buffer.appendByte((byte)1).appendLong((Long)val);
                    continue;
                }
                if (val instanceof Integer) {
                    buffer.appendByte((byte)2).appendInt((Integer)val);
                    continue;
                }
                if (val instanceof Short) {
                    buffer.appendByte((byte)3).appendShort((Short)val);
                    continue;
                }
                if (val instanceof Byte) {
                    buffer.appendByte((byte)4).appendByte((Byte)val);
                    continue;
                }
                if (val instanceof Double) {
                    buffer.appendByte((byte)5).appendDouble((Double)val);
                    continue;
                }
                if (val instanceof Float) {
                    buffer.appendByte((byte)6).appendFloat(((Float)val).floatValue());
                    continue;
                }
                if (val instanceof Character) {
                    buffer.appendByte((byte)7).appendShort((short)((Character)val).charValue());
                    continue;
                }
                if (val instanceof Boolean) {
                    buffer.appendByte((byte)8).appendByte((byte)((Boolean)val != false ? 1 : 0));
                    continue;
                }
                if (val instanceof String) {
                    bytes = ((String)val).getBytes(UTF8);
                    buffer.appendByte((byte)9).appendInt(bytes.length).appendBytes(bytes);
                    continue;
                }
                if (val instanceof Buffer) {
                    Buffer buff = (Buffer)val;
                    buffer.appendByte((byte)10).appendInt(buff.length()).appendBuffer(buff);
                    continue;
                }
                if (val instanceof byte[]) {
                    bytes = (byte[])val;
                    buffer.appendByte((byte)11).appendInt(bytes.length).appendBytes(bytes);
                    continue;
                }
                if (val instanceof ClusterSerializable) {
                    buffer.appendByte((byte)13);
                    String className = val.getClass().getName();
                    byte[] classNameBytes = className.getBytes(UTF8);
                    buffer.appendInt(classNameBytes.length).appendBytes(classNameBytes);
                    ((ClusterSerializable)val).writeToBuffer(buffer);
                    continue;
                }
                if (val == null) continue;
                throw new IllegalStateException("Invalid type for data in session: " + String.valueOf(val.getClass()));
            }
        }
    }

    protected int readDataFromBuffer(int pos, Buffer buffer) {
        try {
            int entries2 = buffer.getInt(pos);
            pos += 4;
            if (entries2 > 0) {
                ConcurrentHashMap<String, Object> data2 = new ConcurrentHashMap<String, Object>(entries2);
                for (int i = 0; i < entries2; ++i) {
                    Object val;
                    int keylen = buffer.getInt(pos);
                    byte[] keyBytes = buffer.getBytes(pos += 4, pos + keylen);
                    pos += keylen;
                    String key = new String(keyBytes, UTF8);
                    byte type2 = buffer.getByte(pos++);
                    switch (type2) {
                        case 1: {
                            val = buffer.getLong(pos);
                            pos += 8;
                            break;
                        }
                        case 2: {
                            val = buffer.getInt(pos);
                            pos += 4;
                            break;
                        }
                        case 3: {
                            val = buffer.getShort(pos);
                            pos += 2;
                            break;
                        }
                        case 4: {
                            val = buffer.getByte(pos);
                            ++pos;
                            break;
                        }
                        case 6: {
                            val = Float.valueOf(buffer.getFloat(pos));
                            pos += 4;
                            break;
                        }
                        case 5: {
                            val = buffer.getDouble(pos);
                            pos += 8;
                            break;
                        }
                        case 7: {
                            short s = buffer.getShort(pos);
                            pos += 2;
                            val = Character.valueOf((char)s);
                            break;
                        }
                        case 8: {
                            byte b = buffer.getByte(pos);
                            ++pos;
                            val = b == 1;
                            break;
                        }
                        case 9: {
                            int len = buffer.getInt(pos);
                            byte[] bytes = buffer.getBytes(pos += 4, pos + len);
                            val = new String(bytes, UTF8);
                            pos += len;
                            break;
                        }
                        case 10: {
                            int len = buffer.getInt(pos);
                            byte[] bytes = buffer.getBytes(pos += 4, pos + len);
                            val = Buffer.buffer(bytes);
                            pos += len;
                            break;
                        }
                        case 11: {
                            int len = buffer.getInt(pos);
                            val = buffer.getBytes(pos += 4, pos + len);
                            pos += len;
                            break;
                        }
                        case 13: {
                            int classNameLen = buffer.getInt(pos);
                            byte[] classNameBytes = buffer.getBytes(pos += 4, pos + classNameLen);
                            pos += classNameLen;
                            String className = new String(classNameBytes, UTF8);
                            Class<?> clazz = Utils.getClassLoader().loadClass(className);
                            if (!ClusterSerializable.class.isAssignableFrom(clazz)) {
                                throw new ClassCastException(new String(classNameBytes, StandardCharsets.UTF_8) + " is not assignable from ClusterSerializable");
                            }
                            ClusterSerializable obj = (ClusterSerializable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            pos = obj.readFromBuffer(pos, buffer);
                            val = obj;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Invalid serialized type: " + type2);
                        }
                    }
                    data2.put(key, val);
                }
                this.setData(data2);
            }
            return pos;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new VertxException(e);
        }
    }

    protected void readDataFromBuffer(Buffer buffer) {
        this.readDataFromBuffer(0, buffer);
    }
}

