/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.ext.auth.prng.VertxContextPRNG;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.sstore.AbstractSession;
import io.vertx.ext.web.sstore.ClusteredSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.ext.web.sstore.impl.SharedDataSessionImpl;

public class ClusteredSessionStoreImpl
implements SessionStore,
ClusteredSessionStore {
    private static final String DEFAULT_SESSION_MAP_NAME = "vertx-web.sessions";
    private static final long DEFAULT_RETRY_TIMEOUT = 5000L;
    private VertxInternal vertx;
    private VertxContextPRNG random;
    private String sessionMapName;
    private long retryTimeout;
    private volatile AsyncMap<String, Session> sessionMap;

    @Override
    public SessionStore init(Vertx vertx, JsonObject options2) {
        this.vertx = (VertxInternal)vertx;
        this.sessionMapName = options2.getString("mapName", DEFAULT_SESSION_MAP_NAME);
        this.retryTimeout = options2.getLong("retryTimeout", 5000L);
        this.random = VertxContextPRNG.current(vertx);
        return this;
    }

    @Override
    public long retryTimeout() {
        return this.retryTimeout;
    }

    @Override
    public Session createSession(long timeout2) {
        return new SharedDataSessionImpl(this.random, timeout2, 16);
    }

    @Override
    public Session createSession(long timeout2, int length) {
        return new SharedDataSessionImpl(this.random, timeout2, length);
    }

    @Override
    public Future<@Nullable Session> get(String id) {
        return this.getMap().compose(map2 -> map2.get(id).onSuccess(session -> {
            if (session != null) {
                ((AbstractSession)session).setPRNG(this.random);
            }
        }));
    }

    @Override
    public Future<Void> delete(String id) {
        return this.getMap().compose(map2 -> map2.remove(id)).mapEmpty();
    }

    @Override
    public Future<Void> put(Session session) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        return this.getMap().compose(map2 -> map2.get(session.id()).compose(old -> {
            AbstractSession oldSession = (AbstractSession)old;
            AbstractSession newSession = (AbstractSession)session;
            if (oldSession != null && oldSession.version() != newSession.version()) {
                return ctx.failedFuture("Session version mismatch");
            }
            newSession.incrementVersion();
            return map2.put(session.id(), session, session.timeout());
        }));
    }

    @Override
    public Future<Void> clear() {
        return this.getMap().compose(AsyncMap::clear);
    }

    @Override
    public Future<Integer> size() {
        return this.getMap().compose(AsyncMap::size);
    }

    @Override
    public void close() {
    }

    private Future<AsyncMap<String, Session>> getMap() {
        if (this.sessionMap == null) {
            return this.vertx.sharedData().getClusterWideMap(this.sessionMapName).onSuccess(sessionMap -> {
                this.sessionMap = sessionMap;
            });
        }
        ContextInternal ctx = this.vertx.getOrCreateContext();
        return ctx.succeededFuture(this.sessionMap);
    }
}

