/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.EnumDescriptor;
import kotlinx.serialization.internal.PluginGeneratedSerialDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B%\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0015\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u0005H\u0016R\u001b\u0010\b\u001a\u00020\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lkotlinx/serialization/internal/EnumSerializer;", "T", "", "Lkotlinx/serialization/KSerializer;", "serialName", "", "values", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "(Ljava/lang/String;[Ljava/lang/Enum;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "(Ljava/lang/String;[Ljava/lang/Enum;)V", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor$delegate", "Lkotlin/Lazy;", "overriddenDescriptor", "[Ljava/lang/Enum;", "createUnmarkedDescriptor", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/lang/Enum;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "(Lkotlinx/serialization/encoding/Encoder;Ljava/lang/Enum;)V", "toString", "kotlinx-serialization-core"})
@PublishedApi
@SourceDebugExtension(value={"SMAP\nEnums.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Enums.kt\nkotlinx/serialization/internal/EnumSerializer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,151:1\n13309#2,2:152\n*S KotlinDebug\n*F\n+ 1 Enums.kt\nkotlinx/serialization/internal/EnumSerializer\n*L\n123#1:152,2\n*E\n"})
public final class EnumSerializer<T extends Enum<T>>
implements KSerializer<T> {
    @NotNull
    private final T[] values;
    @Nullable
    private SerialDescriptor overriddenDescriptor;
    @NotNull
    private final Lazy descriptor$delegate;

    public EnumSerializer(@NotNull String serialName, @NotNull T[] values2) {
        Intrinsics.checkNotNullParameter(serialName, "serialName");
        Intrinsics.checkNotNullParameter(values2, "values");
        this.values = values2;
        this.descriptor$delegate = LazyKt.lazy((Function0)new Function0<SerialDescriptor>(this, serialName){
            final /* synthetic */ EnumSerializer<T> this$0;
            final /* synthetic */ String $serialName;
            {
                this.this$0 = $receiver;
                this.$serialName = $serialName;
                super(0);
            }

            @NotNull
            public final SerialDescriptor invoke() {
                SerialDescriptor serialDescriptor = EnumSerializer.access$getOverriddenDescriptor$p(this.this$0);
                if (serialDescriptor == null) {
                    serialDescriptor = EnumSerializer.access$createUnmarkedDescriptor(this.this$0, this.$serialName);
                }
                return serialDescriptor;
            }
        });
    }

    public EnumSerializer(@NotNull String serialName, @NotNull T[] values2, @NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(serialName, "serialName");
        Intrinsics.checkNotNullParameter(values2, "values");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this(serialName, (Enum[])values2);
        this.overriddenDescriptor = descriptor2;
    }

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        Lazy lazy = this.descriptor$delegate;
        return (SerialDescriptor)lazy.getValue();
    }

    private final SerialDescriptor createUnmarkedDescriptor(String serialName) {
        EnumDescriptor d = new EnumDescriptor(serialName, this.values.length);
        T[] $this$forEach$iv = this.values;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            T element$iv;
            T it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            PluginGeneratedSerialDescriptor.addElement$default(d, ((Enum)it).name(), false, 2, null);
        }
        return d;
    }

    @Override
    public void serialize(@NotNull Encoder encoder2, @NotNull T value) {
        Intrinsics.checkNotNullParameter(encoder2, "encoder");
        Intrinsics.checkNotNullParameter(value, "value");
        int index2 = ArraysKt.indexOf(this.values, value);
        if (index2 == -1) {
            StringBuilder stringBuilder = new StringBuilder().append(value).append(" is not a valid enum ").append(this.getDescriptor().getSerialName()).append(", must be one of ");
            String string = Arrays.toString(this.values);
            Intrinsics.checkNotNullExpressionValue(string, "toString(this)");
            throw new SerializationException(stringBuilder.append(string).toString());
        }
        encoder2.encodeEnum(this.getDescriptor(), index2);
    }

    @Override
    @NotNull
    public T deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        int index2 = decoder.decodeEnum(this.getDescriptor());
        if (!(0 <= index2 ? index2 < this.values.length : false)) {
            throw new SerializationException(index2 + " is not among valid " + this.getDescriptor().getSerialName() + " enum values, values size is " + this.values.length);
        }
        return this.values[index2];
    }

    @NotNull
    public String toString() {
        return "kotlinx.serialization.internal.EnumSerializer<" + this.getDescriptor().getSerialName() + '>';
    }

    public static final /* synthetic */ SerialDescriptor access$getOverriddenDescriptor$p(EnumSerializer $this) {
        return $this.overriddenDescriptor;
    }

    public static final /* synthetic */ SerialDescriptor access$createUnmarkedDescriptor(EnumSerializer $this, String serialName) {
        return $this.createUnmarkedDescriptor(serialName);
    }
}

