/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameConverter;
import org.bytedeco.leptonica.AbstractPIX;
import org.bytedeco.leptonica.PIX;
import org.bytedeco.leptonica.global.leptonica;

public class LeptonicaFrameConverter
extends FrameConverter<PIX> {
    PIX pix;
    BytePointer frameData;
    BytePointer pixData;
    ByteBuffer frameBuffer;
    ByteBuffer pixBuffer;

    static boolean isEqual(Frame frame2, PIX pix) {
        return pix != null && frame2 != null && frame2.image != null && frame2.image.length > 0 && frame2.imageWidth == pix.w() && frame2.imageHeight == pix.h() && frame2.imageChannels == pix.d() / 8 && frame2.imageDepth == 8 && (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) || new Pointer(frame2.image[0]).address() == pix.data().address()) && frame2.imageStride * Math.abs(frame2.imageDepth) / 8 == pix.wpl() * 4;
    }

    @Override
    public PIX convert(Frame frame2) {
        if (frame2 == null || frame2.image == null) {
            return null;
        }
        if (frame2.opaque instanceof PIX) {
            return (PIX)frame2.opaque;
        }
        if (!LeptonicaFrameConverter.isEqual(frame2, this.pix)) {
            Pointer data2;
            if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
                if (this.pixData == null || this.pixData.capacity() < (long)(frame2.imageHeight * frame2.imageStride)) {
                    if (this.pixData != null) {
                        this.pixData.releaseReference();
                    }
                    this.pixData = (BytePointer)new BytePointer(frame2.imageHeight * frame2.imageStride).retainReference();
                }
                data2 = this.pixData;
                this.pixBuffer = data2.asByteBuffer().order(ByteOrder.BIG_ENDIAN);
            } else {
                data2 = new Pointer(frame2.image[0].position(0));
            }
            if (this.pix != null) {
                this.pix.releaseReference();
            }
            this.pix = (PIX)PIX.create(frame2.imageWidth, frame2.imageHeight, frame2.imageChannels * 8, data2).wpl(frame2.imageStride / 4 * Math.abs(frame2.imageDepth) / 8).retainReference();
        }
        if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
            ((ByteBuffer)this.pixBuffer.position(0)).asIntBuffer().put(((ByteBuffer)frame2.image[0].position(0)).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer());
        }
        return this.pix;
    }

    @Override
    public Frame convert(PIX pix) {
        if (pix == null) {
            return null;
        }
        PIX tempPix = null;
        if (((PIX)pix).colormap() != null) {
            pix = leptonica.pixRemoveColormap((PIX)pix, 2);
            tempPix = pix;
        } else if (((PIX)pix).d() < 8) {
            switch (((PIX)pix).d()) {
                case 1: {
                    pix = leptonica.pixConvert1To8(null, (PIX)pix, (byte)0, (byte)-1);
                    tempPix = pix;
                    break;
                }
                case 2: {
                    pix = leptonica.pixConvert2To8((PIX)pix, (byte)0, (byte)85, (byte)-86, (byte)-1, 0);
                    tempPix = pix;
                    break;
                }
                case 4: {
                    pix = leptonica.pixConvert4To8((PIX)pix, 0);
                    tempPix = pix;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        if (!LeptonicaFrameConverter.isEqual(this.frame, (PIX)pix)) {
            this.frame = new Frame();
            this.frame.imageWidth = ((PIX)pix).w();
            this.frame.imageHeight = ((PIX)pix).h();
            this.frame.imageDepth = 8;
            this.frame.imageChannels = ((PIX)pix).d() / 8;
            this.frame.imageStride = ((PIX)pix).wpl() * 4;
            if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
                if (this.frameData == null || this.frameData.capacity() < (long)(this.frame.imageHeight * this.frame.imageStride)) {
                    if (this.frameData != null) {
                        this.frameData.releaseReference();
                    }
                    this.frameData = (BytePointer)new BytePointer(this.frame.imageHeight * this.frame.imageStride).retainReference();
                }
                this.frameBuffer = this.frameData.asByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
                this.frame.opaque = this.frameData;
                this.frame.image = new Buffer[]{this.frameBuffer};
            } else {
                if (tempPix != null) {
                    if (this.pix != null) {
                        this.pix.releaseReference();
                    }
                    this.pix = pix = ((PIX)pix).clone();
                }
                this.frame.opaque = pix;
                this.frame.image = new Buffer[]{((AbstractPIX)pix).createBuffer()};
            }
        }
        if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
            ((ByteBuffer)this.frameBuffer.position(0)).asIntBuffer().put(((AbstractPIX)pix).createBuffer().order(ByteOrder.BIG_ENDIAN).asIntBuffer());
        }
        if (tempPix != null) {
            leptonica.pixDestroy(tempPix);
        }
        return this.frame;
    }

    @Override
    public void close() {
        super.close();
        if (this.pix != null) {
            this.pix.releaseReference();
            this.pix = null;
        }
        if (this.pixData != null) {
            this.pixData.releaseReference();
            this.pixData = null;
        }
        if (this.frameData != null) {
            this.frameData.releaseReference();
            this.frameData = null;
        }
    }

    static {
        Loader.load(leptonica.class);
    }
}

