/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacv.Parallel;
import org.bytedeco.opencv.cvkernels;
import org.bytedeco.opencv.opencv_core.CvRect;
import org.bytedeco.opencv.opencv_core.CvScalar;
import org.bytedeco.opencv.opencv_core.IplImage;

public class cvkernels
extends org.bytedeco.opencv.cvkernels {
    private static ThreadLocal<ParallelData[]> parallelData = new ThreadLocal<ParallelData[]>(){

        @Override
        protected ParallelData[] initialValue() {
            ParallelData[] pd = new ParallelData[Parallel.getNumThreads()];
            for (int i = 0; i < pd.length; ++i) {
                pd[i] = new ParallelData();
            }
            return pd;
        }
    };

    public static void multiWarpColorTransform(cvkernels.KernelData data2, CvRect roi, final CvScalar fillColor) {
        int h;
        int w;
        int y2;
        int x2;
        final int size2 = (int)data2.capacity();
        final ParallelData[] pd = parallelData.get();
        for (int i = 0; i < pd.length; ++i) {
            cvkernels.KernelData d;
            int j;
            if (pd[i].data == null || pd[i].data.capacity() < (long)size2) {
                pd[i].data = new cvkernels.KernelData(size2);
                for (j = 0; j < size2; ++j) {
                    d = pd[i].data.position(j);
                    data2.position(j);
                    if (data2.dstDstDot() == null) continue;
                    d.dstDstDot(ByteBuffer.allocateDirect(data2.dstDstDot().capacity() * 8).order(ByteOrder.nativeOrder()).asDoubleBuffer());
                }
            }
            for (j = 0; j < size2; ++j) {
                d = pd[i].data.position(j);
                d.put((Pointer)data2.position(j));
                d.dstDstDot(d.dstDstDot());
            }
        }
        IplImage img = data2.position(0L).srcImg();
        final int depth = img.depth();
        if (roi != null) {
            x2 = roi.x();
            y2 = roi.y();
            w = roi.width();
            h = roi.height();
        } else {
            x2 = 0;
            y2 = 0;
            w = img.width();
            h = img.height();
        }
        Parallel.loop(y2, y2 + h, pd.length, new Parallel.Looper(){

            @Override
            public void loop(int from, int to, int looperID) {
                CvRect r = pd[looperID].roi.x(x2).y(from).width(w).height(to - from);
                if (depth == 32) {
                    org.bytedeco.opencv.cvkernels.multiWarpColorTransform32F(pd[looperID].data.position(0L), size2, r, fillColor);
                } else if (depth == 8) {
                    org.bytedeco.opencv.cvkernels.multiWarpColorTransform8U(pd[looperID].data.position(0L), size2, r, fillColor);
                } else assert (false);
            }
        });
        for (int i = 0; i < size2; ++i) {
            int dstCount = 0;
            int dstCountZero = 0;
            int dstCountOutlier = 0;
            double srcDstDot = 0.0;
            double[] dstDstDot = null;
            if (data2.dstDstDot() != null) {
                dstDstDot = new double[data2.dstDstDot().capacity()];
            }
            for (int j = 0; j < pd.length; ++j) {
                cvkernels.KernelData d = pd[j].data.position(i);
                dstCount += d.dstCount();
                dstCountZero += d.dstCountZero();
                dstCountOutlier += d.dstCountOutlier();
                srcDstDot += d.srcDstDot();
                if (dstDstDot == null || d.dstDstDot() == null) continue;
                for (int k = 0; k < dstDstDot.length; ++k) {
                    int n = k;
                    dstDstDot[n] = dstDstDot[n] + d.dstDstDot().get(k);
                }
            }
            data2.position(i);
            data2.dstCount(dstCount);
            data2.dstCountZero(dstCountZero);
            data2.dstCountOutlier(dstCountOutlier);
            data2.srcDstDot(srcDstDot);
            if (dstDstDot == null || data2.dstDstDot() == null) continue;
            data2.dstDstDot().position(0);
            data2.dstDstDot().put(dstDstDot);
        }
    }

    private static class ParallelData {
        cvkernels.KernelData data = null;
        CvRect roi = new CvRect();

        private ParallelData() {
        }
    }
}

