/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.leptonica;

import java.nio.DoubleBuffer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.Indexable;
import org.bytedeco.leptonica.DPIX;
import org.bytedeco.leptonica.global.leptonica;

@Properties(inherit={org.bytedeco.leptonica.presets.leptonica.class})
public abstract class AbstractDPIX
extends Pointer
implements Indexable {
    public AbstractDPIX(Pointer p) {
        super(p);
    }

    public static DPIX create(int width2, int height2) {
        DPIX p = leptonica.dpixCreate(width2, height2);
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public static DPIX createTemplate(DPIX dpixs) {
        DPIX p = leptonica.dpixCreateTemplate(dpixs);
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public DPIX clone() {
        DPIX p = new DPIX(leptonica.dpixClone((DPIX)this));
        if (p != null) {
            p.deallocator(new DestroyDeallocator(p));
        }
        return p;
    }

    public DoubleBuffer createBuffer() {
        return this.createBuffer(0);
    }

    public DoubleBuffer createBuffer(int index2) {
        int[] w = new int[]{0};
        int[] h = new int[]{0};
        leptonica.dpixGetDimensions((DPIX)this, w, h);
        int wpl = leptonica.dpixGetWpl((DPIX)this);
        DoublePointer data2 = new DoublePointer(leptonica.dpixGetData((DPIX)this)).position(index2).capacity(h[0] * wpl);
        return data2.asBuffer();
    }

    public DoubleIndexer createIndexer() {
        return this.createIndexer(true);
    }

    public DoubleIndexer createIndexer(boolean direct) {
        int[] w = new int[]{0};
        int[] h = new int[]{0};
        leptonica.dpixGetDimensions((DPIX)this, w, h);
        int wpl = leptonica.dpixGetWpl((DPIX)this);
        long[] sizes = new long[]{h[0], w[0], wpl / w[0]};
        long[] strides = new long[]{wpl, wpl / w[0], 1L};
        DoublePointer data2 = new DoublePointer(leptonica.dpixGetData((DPIX)this)).capacity(h[0] * wpl);
        return DoubleIndexer.create(data2, sizes, strides, direct);
    }

    public void destroy() {
        this.deallocate();
    }

    protected static class DestroyDeallocator
    extends DPIX
    implements Pointer.Deallocator {
        DestroyDeallocator(DPIX p) {
            super(p);
        }

        @Override
        public void deallocate() {
            if (this.isNull()) {
                return;
            }
            leptonica.dpixDestroy(this);
            this.setNull();
        }
    }
}

