/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.libfreenect2;

import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.MemberGetter;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Namespace;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.StdString;
import org.bytedeco.libfreenect2.FrameListener;
import org.bytedeco.libfreenect2.presets.freenect2;

@Namespace(value="libfreenect2")
@Properties(inherit={freenect2.class})
public class Freenect2Device
extends Pointer {
    public static final int VendorId;
    public static final int ProductId;
    public static final int ProductIdPreview;

    public Freenect2Device(Pointer p) {
        super(p);
    }

    @MemberGetter
    @Cast(value={"const unsigned int"})
    public static native int VendorId();

    @MemberGetter
    @Cast(value={"const unsigned int"})
    public static native int ProductId();

    @MemberGetter
    @Cast(value={"const unsigned int"})
    public static native int ProductIdPreview();

    @StdString
    public native BytePointer getSerialNumber();

    @StdString
    public native BytePointer getFirmwareVersion();

    @ByVal
    public native ColorCameraParams getColorCameraParams();

    @ByVal
    public native IrCameraParams getIrCameraParams();

    public native void setColorCameraParams(@Const @ByRef ColorCameraParams var1);

    public native void setIrCameraParams(@Const @ByRef IrCameraParams var1);

    public native void setConfiguration(@Const @ByRef Config var1);

    public native void setColorFrameListener(FrameListener var1);

    public native void setIrAndDepthFrameListener(FrameListener var1);

    @Cast(value={"bool"})
    public native boolean start();

    @Cast(value={"bool"})
    public native boolean startStreams(@Cast(value={"bool"}) boolean var1, @Cast(value={"bool"}) boolean var2);

    @Cast(value={"bool"})
    public native boolean stop();

    @Cast(value={"bool"})
    @Name(value={"close"})
    public native boolean _close();

    static {
        Loader.load();
        VendorId = Freenect2Device.VendorId();
        ProductId = Freenect2Device.ProductId();
        ProductIdPreview = Freenect2Device.ProductIdPreview();
    }

    public static class Config
    extends Pointer {
        public Config() {
            super((Pointer)null);
            this.allocate();
        }

        public Config(long size2) {
            super((Pointer)null);
            this.allocateArray(size2);
        }

        public Config(Pointer p) {
            super(p);
        }

        private native void allocate();

        private native void allocateArray(long var1);

        public Config position(long position) {
            return (Config)super.position(position);
        }

        public Config getPointer(long i) {
            return (Config)new Config(this).offsetAddress(i);
        }

        public native float MinDepth();

        public native Config MinDepth(float var1);

        public native float MaxDepth();

        public native Config MaxDepth(float var1);

        @Cast(value={"bool"})
        public native boolean EnableBilateralFilter();

        public native Config EnableBilateralFilter(boolean var1);

        @Cast(value={"bool"})
        public native boolean EnableEdgeAwareFilter();

        public native Config EnableEdgeAwareFilter(boolean var1);

        static {
            Loader.load();
        }
    }

    public static class IrCameraParams
    extends Pointer {
        public IrCameraParams() {
            super((Pointer)null);
            this.allocate();
        }

        public IrCameraParams(long size2) {
            super((Pointer)null);
            this.allocateArray(size2);
        }

        public IrCameraParams(Pointer p) {
            super(p);
        }

        private native void allocate();

        private native void allocateArray(long var1);

        public IrCameraParams position(long position) {
            return (IrCameraParams)super.position(position);
        }

        public IrCameraParams getPointer(long i) {
            return (IrCameraParams)new IrCameraParams(this).offsetAddress(i);
        }

        public native float fx();

        public native IrCameraParams fx(float var1);

        public native float fy();

        public native IrCameraParams fy(float var1);

        public native float cx();

        public native IrCameraParams cx(float var1);

        public native float cy();

        public native IrCameraParams cy(float var1);

        public native float k1();

        public native IrCameraParams k1(float var1);

        public native float k2();

        public native IrCameraParams k2(float var1);

        public native float k3();

        public native IrCameraParams k3(float var1);

        public native float p1();

        public native IrCameraParams p1(float var1);

        public native float p2();

        public native IrCameraParams p2(float var1);

        static {
            Loader.load();
        }
    }

    public static class ColorCameraParams
    extends Pointer {
        public ColorCameraParams() {
            super((Pointer)null);
            this.allocate();
        }

        public ColorCameraParams(long size2) {
            super((Pointer)null);
            this.allocateArray(size2);
        }

        public ColorCameraParams(Pointer p) {
            super(p);
        }

        private native void allocate();

        private native void allocateArray(long var1);

        public ColorCameraParams position(long position) {
            return (ColorCameraParams)super.position(position);
        }

        public ColorCameraParams getPointer(long i) {
            return (ColorCameraParams)new ColorCameraParams(this).offsetAddress(i);
        }

        public native float fx();

        public native ColorCameraParams fx(float var1);

        public native float fy();

        public native ColorCameraParams fy(float var1);

        public native float cx();

        public native ColorCameraParams cx(float var1);

        public native float cy();

        public native ColorCameraParams cy(float var1);

        public native float shift_d();

        public native ColorCameraParams shift_d(float var1);

        public native float shift_m();

        public native ColorCameraParams shift_m(float var1);

        public native float mx_x3y0();

        public native ColorCameraParams mx_x3y0(float var1);

        public native float mx_x0y3();

        public native ColorCameraParams mx_x0y3(float var1);

        public native float mx_x2y1();

        public native ColorCameraParams mx_x2y1(float var1);

        public native float mx_x1y2();

        public native ColorCameraParams mx_x1y2(float var1);

        public native float mx_x2y0();

        public native ColorCameraParams mx_x2y0(float var1);

        public native float mx_x0y2();

        public native ColorCameraParams mx_x0y2(float var1);

        public native float mx_x1y1();

        public native ColorCameraParams mx_x1y1(float var1);

        public native float mx_x1y0();

        public native ColorCameraParams mx_x1y0(float var1);

        public native float mx_x0y1();

        public native ColorCameraParams mx_x0y1(float var1);

        public native float mx_x0y0();

        public native ColorCameraParams mx_x0y0(float var1);

        public native float my_x3y0();

        public native ColorCameraParams my_x3y0(float var1);

        public native float my_x0y3();

        public native ColorCameraParams my_x0y3(float var1);

        public native float my_x2y1();

        public native ColorCameraParams my_x2y1(float var1);

        public native float my_x1y2();

        public native ColorCameraParams my_x1y2(float var1);

        public native float my_x2y0();

        public native ColorCameraParams my_x2y0(float var1);

        public native float my_x0y2();

        public native ColorCameraParams my_x0y2(float var1);

        public native float my_x1y1();

        public native ColorCameraParams my_x1y1(float var1);

        public native float my_x1y0();

        public native ColorCameraParams my_x1y0(float var1);

        public native float my_x0y1();

        public native ColorCameraParams my_x0y1(float var1);

        public native float my_x0y0();

        public native ColorCameraParams my_x0y0(float var1);

        static {
            Loader.load();
        }
    }
}

