/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.ShortIndexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UShortIndexer;
import org.bytedeco.opencv.opencv_core.AbstractArray;
import org.bytedeco.opencv.opencv_core.IplROI;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.presets.opencv_core;

@Properties(inherit={opencv_core.class})
public abstract class AbstractMat
extends AbstractArray {
    public static final Mat EMPTY = null;

    public AbstractMat(Pointer p) {
        super(p);
    }

    public abstract void create(int var1, int var2, int var3);

    public abstract void release();

    public abstract int type();

    public abstract int depth();

    public abstract int channels();

    public abstract int rows();

    public abstract int cols();

    public abstract BytePointer data();

    public abstract int size(int var1);

    public abstract long step(int var1);

    public abstract int dims();

    public abstract long elemSize1();

    @Override
    public int arrayChannels() {
        return this.channels();
    }

    @Override
    public int arrayDepth() {
        switch (this.depth()) {
            case 0: {
                return 8;
            }
            case 1: {
                return -2147483640;
            }
            case 2: {
                return 16;
            }
            case 3: {
                return -2147483632;
            }
            case 4: {
                return -2147483616;
            }
            case 5: {
                return 32;
            }
            case 6: {
                return 64;
            }
        }
        assert (false);
        return -1;
    }

    @Override
    public int arrayOrigin() {
        return 0;
    }

    @Override
    public void arrayOrigin(int origin2) {
    }

    @Override
    public int arrayWidth() {
        return this.cols();
    }

    @Override
    public int arrayHeight() {
        return this.rows();
    }

    @Override
    public IplROI arrayROI() {
        return null;
    }

    @Override
    public long arraySize() {
        return this.step(0) * (long)this.size(0);
    }

    @Override
    public BytePointer arrayData() {
        return this.data();
    }

    @Override
    public long arrayStep() {
        return this.step(0);
    }

    @Override
    public <I extends Indexer> I createIndexer(boolean direct) {
        BytePointer ptr = this.arrayData();
        long size2 = this.arraySize();
        int dims = this.dims();
        int depth = this.depth();
        long elemSize = this.elemSize1();
        long[] sizes = new long[dims + 1];
        long[] strides = new long[dims + 1];
        for (int i = 0; i < dims; ++i) {
            sizes[i] = this.size(i);
            long step = this.step(i);
            if (step % elemSize != 0L) {
                throw new UnsupportedOperationException("Step is not a multiple of element size");
            }
            strides[i] = step / elemSize;
        }
        sizes[dims] = this.arrayChannels();
        strides[dims] = 1L;
        switch (depth) {
            case 0: {
                return (I)UByteIndexer.create(ptr.capacity(size2), sizes, strides, direct).indexable(this);
            }
            case 1: {
                return (I)ByteIndexer.create(ptr.capacity(size2), sizes, strides, direct).indexable(this);
            }
            case 2: {
                return (I)UShortIndexer.create(new ShortPointer(ptr).capacity(size2 / 2L), sizes, strides, direct).indexable(this);
            }
            case 3: {
                return (I)ShortIndexer.create(new ShortPointer(ptr).capacity(size2 / 2L), sizes, strides, direct).indexable(this);
            }
            case 4: {
                return (I)IntIndexer.create(new IntPointer(ptr).capacity(size2 / 4L), sizes, strides, direct).indexable(this);
            }
            case 5: {
                return (I)FloatIndexer.create(new FloatPointer(ptr).capacity(size2 / 4L), sizes, strides, direct).indexable(this);
            }
            case 6: {
                return (I)DoubleIndexer.create(new DoublePointer(ptr).capacity(size2 / 8L), sizes, strides, direct).indexable(this);
            }
        }
        assert (false);
        return null;
    }
}

