/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.Point3i;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<cv::Point3i>"})
@Properties(inherit={opencv_core.class})
public class Point3iVector
extends Pointer {
    public Point3iVector(Pointer p) {
        super(p);
    }

    public Point3iVector(Point3i value) {
        this(1L);
        this.put(0L, value);
    }

    public Point3iVector(Point3i ... array) {
        this(array.length);
        this.put(array);
    }

    public Point3iVector() {
        this.allocate();
    }

    public Point3iVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native Point3iVector put(@ByRef Point3iVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public Point3i front() {
        return this.get(0L);
    }

    public Point3i back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native Point3i get(@Cast(value={"size_t"}) long var1);

    public native Point3iVector put(@Cast(value={"size_t"}) long var1, Point3i var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef Point3i var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Point3i[] get() {
        Point3i[] array = new Point3i[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.get());
    }

    public Point3i pop_back() {
        long size2 = this.size();
        Point3i value = this.get(size2 - 1L);
        this.resize(size2 - 1L);
        return value;
    }

    public Point3iVector push_back(Point3i value) {
        long size2 = this.size();
        this.resize(size2 + 1L);
        return this.put(size2, value);
    }

    public Point3iVector put(Point3i value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public Point3iVector put(Point3i ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native Point3i get();
    }
}

