/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.PointVector;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<std::vector<cv::Point> >"})
@Properties(inherit={opencv_core.class})
public class PointVectorVector
extends Pointer {
    public PointVectorVector(Pointer p) {
        super(p);
    }

    public PointVectorVector(PointVector value) {
        this(1L);
        this.put(0L, value);
    }

    public PointVectorVector(PointVector ... array) {
        this(array.length);
        this.put(array);
    }

    public PointVectorVector() {
        this.allocate();
    }

    public PointVectorVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native PointVectorVector put(@ByRef PointVectorVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public PointVector front() {
        return this.get(0L);
    }

    public PointVector back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native PointVector get(@Cast(value={"size_t"}) long var1);

    public native PointVectorVector put(@Cast(value={"size_t"}) long var1, PointVector var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef PointVector var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public PointVector[] get() {
        PointVector[] array = new PointVector[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.get());
    }

    public PointVector pop_back() {
        long size2 = this.size();
        PointVector value = this.get(size2 - 1L);
        this.resize(size2 - 1L);
        return value;
    }

    public PointVectorVector push_back(PointVector value) {
        long size2 = this.size();
        this.resize(size2 + 1L);
        return this.put(size2, value);
    }

    public PointVectorVector put(PointVector value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public PointVectorVector put(PointVector ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native PointVector get();
    }
}

