/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import org.jsoup.helper.ChangeNotifyingArrayList;
import org.jsoup.helper.Consumer;
import org.jsoup.helper.Validate;
import org.jsoup.internal.NonnullByDefault;
import org.jsoup.internal.Normalizer;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.CDataNode;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.NodeUtils;
import org.jsoup.nodes.Range;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Tag;
import org.jsoup.parser.TokenQueue;
import org.jsoup.select.Collector;
import org.jsoup.select.Elements;
import org.jsoup.select.Evaluator;
import org.jsoup.select.NodeFilter;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.jsoup.select.QueryParser;
import org.jsoup.select.Selector;

@NonnullByDefault
public class Element
extends Node {
    private static final List<Element> EmptyChildren = Collections.emptyList();
    private static final Pattern ClassSplit = Pattern.compile("\\s+");
    private static final String BaseUriKey = Attributes.internalKey("baseUri");
    private Tag tag;
    @Nullable
    private WeakReference<List<Element>> shadowChildrenRef;
    List<Node> childNodes;
    @Nullable
    Attributes attributes;

    public Element(String tag) {
        this(Tag.valueOf(tag), "", null);
    }

    public Element(Tag tag, @Nullable String baseUri, @Nullable Attributes attributes) {
        Validate.notNull(tag);
        this.childNodes = EmptyNodes;
        this.attributes = attributes;
        this.tag = tag;
        if (baseUri != null) {
            this.setBaseUri(baseUri);
        }
    }

    public Element(Tag tag, @Nullable String baseUri) {
        this(tag, baseUri, null);
    }

    protected boolean hasChildNodes() {
        return this.childNodes != EmptyNodes;
    }

    @Override
    protected List<Node> ensureChildNodes() {
        if (this.childNodes == EmptyNodes) {
            this.childNodes = new NodeList(this, 4);
        }
        return this.childNodes;
    }

    @Override
    protected boolean hasAttributes() {
        return this.attributes != null;
    }

    @Override
    public Attributes attributes() {
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        return this.attributes;
    }

    @Override
    public String baseUri() {
        return Element.searchUpForAttribute(this, BaseUriKey);
    }

    private static String searchUpForAttribute(Element start2, String key) {
        for (Element el = start2; el != null; el = el.parent()) {
            if (el.attributes == null || !el.attributes.hasKey(key)) continue;
            return el.attributes.get(key);
        }
        return "";
    }

    @Override
    protected void doSetBaseUri(String baseUri) {
        this.attributes().put(BaseUriKey, baseUri);
    }

    @Override
    public int childNodeSize() {
        return this.childNodes.size();
    }

    @Override
    public String nodeName() {
        return this.tag.getName();
    }

    public String tagName() {
        return this.tag.getName();
    }

    @Override
    public String normalName() {
        return this.tag.normalName();
    }

    public Element tagName(String tagName) {
        Validate.notEmptyParam(tagName, "tagName");
        this.tag = Tag.valueOf(tagName, NodeUtils.parser(this).settings());
        return this;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isBlock() {
        return this.tag.isBlock();
    }

    public String id() {
        return this.attributes != null ? this.attributes.getIgnoreCase("id") : "";
    }

    public Element id(String id) {
        Validate.notNull(id);
        this.attr("id", id);
        return this;
    }

    @Override
    public Element attr(String attributeKey, String attributeValue) {
        super.attr(attributeKey, attributeValue);
        return this;
    }

    public Element attr(String attributeKey, boolean attributeValue) {
        this.attributes().put(attributeKey, attributeValue);
        return this;
    }

    public Map<String, String> dataset() {
        return this.attributes().dataset();
    }

    @Override
    @Nullable
    public final Element parent() {
        return (Element)this.parentNode;
    }

    public Elements parents() {
        Elements parents = new Elements();
        for (Element parent2 = this.parent(); parent2 != null && !parent2.isNode("#root"); parent2 = parent2.parent()) {
            parents.add(parent2);
        }
        return parents;
    }

    public Element child(int index2) {
        return this.childElementsList().get(index2);
    }

    public int childrenSize() {
        return this.childElementsList().size();
    }

    public Elements children() {
        return new Elements(this.childElementsList());
    }

    List<Element> childElementsList() {
        ArrayList<Element> children2;
        if (this.childNodeSize() == 0) {
            return EmptyChildren;
        }
        if (this.shadowChildrenRef == null || (children2 = (ArrayList<Element>)this.shadowChildrenRef.get()) == null) {
            int size2 = this.childNodes.size();
            children2 = new ArrayList<Element>(size2);
            for (int i = 0; i < size2; ++i) {
                Node node = this.childNodes.get(i);
                if (!(node instanceof Element)) continue;
                children2.add((Element)node);
            }
            this.shadowChildrenRef = new WeakReference(children2);
        }
        return children2;
    }

    @Override
    void nodelistChanged() {
        super.nodelistChanged();
        this.shadowChildrenRef = null;
    }

    public List<TextNode> textNodes() {
        ArrayList<TextNode> textNodes = new ArrayList<TextNode>();
        for (Node node : this.childNodes) {
            if (!(node instanceof TextNode)) continue;
            textNodes.add((TextNode)node);
        }
        return Collections.unmodifiableList(textNodes);
    }

    public List<DataNode> dataNodes() {
        ArrayList<DataNode> dataNodes = new ArrayList<DataNode>();
        for (Node node : this.childNodes) {
            if (!(node instanceof DataNode)) continue;
            dataNodes.add((DataNode)node);
        }
        return Collections.unmodifiableList(dataNodes);
    }

    public Elements select(String cssQuery) {
        return Selector.select(cssQuery, this);
    }

    public Elements select(Evaluator evaluator) {
        return Selector.select(evaluator, this);
    }

    @Nullable
    public Element selectFirst(String cssQuery) {
        return Selector.selectFirst(cssQuery, this);
    }

    @Nullable
    public Element selectFirst(Evaluator evaluator) {
        return Collector.findFirst(evaluator, this);
    }

    public Element expectFirst(String cssQuery) {
        return (Element)Validate.ensureNotNull(Selector.selectFirst(cssQuery, this), this.parent() != null ? "No elements matched the query '%s' on element '%s'." : "No elements matched the query '%s' in the document.", cssQuery, this.tagName());
    }

    public boolean is(String cssQuery) {
        return this.is(QueryParser.parse(cssQuery));
    }

    public boolean is(Evaluator evaluator) {
        return evaluator.matches(this.root(), this);
    }

    @Nullable
    public Element closest(String cssQuery) {
        return this.closest(QueryParser.parse(cssQuery));
    }

    @Nullable
    public Element closest(Evaluator evaluator) {
        Validate.notNull(evaluator);
        Element el = this;
        Element root = this.root();
        do {
            if (!evaluator.matches(root, el)) continue;
            return el;
        } while ((el = el.parent()) != null);
        return null;
    }

    public Elements selectXpath(String xpath) {
        return new Elements(NodeUtils.selectXpath(xpath, this, Element.class));
    }

    public <T extends Node> List<T> selectXpath(String xpath, Class<T> nodeType) {
        return NodeUtils.selectXpath(xpath, this, nodeType);
    }

    public Element appendChild(Node child2) {
        Validate.notNull(child2);
        this.reparentChild(child2);
        this.ensureChildNodes();
        this.childNodes.add(child2);
        child2.setSiblingIndex(this.childNodes.size() - 1);
        return this;
    }

    public Element appendChildren(Collection<? extends Node> children2) {
        this.insertChildren(-1, children2);
        return this;
    }

    public Element appendTo(Element parent2) {
        Validate.notNull(parent2);
        parent2.appendChild(this);
        return this;
    }

    public Element prependChild(Node child2) {
        Validate.notNull(child2);
        this.addChildren(0, child2);
        return this;
    }

    public Element prependChildren(Collection<? extends Node> children2) {
        this.insertChildren(0, children2);
        return this;
    }

    public Element insertChildren(int index2, Collection<? extends Node> children2) {
        Validate.notNull(children2, "Children collection to be inserted must not be null.");
        int currentSize = this.childNodeSize();
        if (index2 < 0) {
            index2 += currentSize + 1;
        }
        Validate.isTrue(index2 >= 0 && index2 <= currentSize, "Insert position out of bounds.");
        ArrayList<? extends Node> nodes = new ArrayList<Node>(children2);
        Node[] nodeArray = nodes.toArray(new Node[0]);
        this.addChildren(index2, nodeArray);
        return this;
    }

    public Element insertChildren(int index2, Node ... children2) {
        Validate.notNull(children2, "Children collection to be inserted must not be null.");
        int currentSize = this.childNodeSize();
        if (index2 < 0) {
            index2 += currentSize + 1;
        }
        Validate.isTrue(index2 >= 0 && index2 <= currentSize, "Insert position out of bounds.");
        this.addChildren(index2, children2);
        return this;
    }

    public Element appendElement(String tagName) {
        Element child2 = new Element(Tag.valueOf(tagName, NodeUtils.parser(this).settings()), this.baseUri());
        this.appendChild(child2);
        return child2;
    }

    public Element prependElement(String tagName) {
        Element child2 = new Element(Tag.valueOf(tagName, NodeUtils.parser(this).settings()), this.baseUri());
        this.prependChild(child2);
        return child2;
    }

    public Element appendText(String text2) {
        Validate.notNull(text2);
        TextNode node = new TextNode(text2);
        this.appendChild(node);
        return this;
    }

    public Element prependText(String text2) {
        Validate.notNull(text2);
        TextNode node = new TextNode(text2);
        this.prependChild(node);
        return this;
    }

    public Element append(String html) {
        Validate.notNull(html);
        List<Node> nodes = NodeUtils.parser(this).parseFragmentInput(html, this, this.baseUri());
        this.addChildren(nodes.toArray(new Node[0]));
        return this;
    }

    public Element prepend(String html) {
        Validate.notNull(html);
        List<Node> nodes = NodeUtils.parser(this).parseFragmentInput(html, this, this.baseUri());
        this.addChildren(0, nodes.toArray(new Node[0]));
        return this;
    }

    @Override
    public Element before(String html) {
        return (Element)super.before(html);
    }

    @Override
    public Element before(Node node) {
        return (Element)super.before(node);
    }

    @Override
    public Element after(String html) {
        return (Element)super.after(html);
    }

    @Override
    public Element after(Node node) {
        return (Element)super.after(node);
    }

    @Override
    public Element empty() {
        this.childNodes.clear();
        return this;
    }

    @Override
    public Element wrap(String html) {
        return (Element)super.wrap(html);
    }

    public String cssSelector() {
        if (this.id().length() > 0) {
            String idSel = "#" + TokenQueue.escapeCssIdentifier(this.id());
            Document doc = this.ownerDocument();
            if (doc != null) {
                Elements els = doc.select(idSel);
                if (els.size() == 1 && els.get(0) == this) {
                    return idSel;
                }
            } else {
                return idSel;
            }
        }
        String tagName = TokenQueue.escapeCssIdentifier(this.tagName()).replace("\\:", "|");
        StringBuilder selector = StringUtil.borrowBuilder().append(tagName);
        StringUtil.StringJoiner escapedClasses = new StringUtil.StringJoiner(".");
        for (String name : this.classNames()) {
            escapedClasses.add(TokenQueue.escapeCssIdentifier(name));
        }
        String classes2 = escapedClasses.complete();
        if (classes2.length() > 0) {
            selector.append('.').append(classes2);
        }
        if (this.parent() == null || this.parent() instanceof Document) {
            return StringUtil.releaseBuilder(selector);
        }
        selector.insert(0, " > ");
        if (this.parent().select(selector.toString()).size() > 1) {
            selector.append(String.format(":nth-child(%d)", this.elementSiblingIndex() + 1));
        }
        return this.parent().cssSelector() + StringUtil.releaseBuilder(selector);
    }

    public Elements siblingElements() {
        if (this.parentNode == null) {
            return new Elements(0);
        }
        List<Element> elements = this.parent().childElementsList();
        Elements siblings = new Elements(elements.size() - 1);
        for (Element el : elements) {
            if (el == this) continue;
            siblings.add(el);
        }
        return siblings;
    }

    @Nullable
    public Element nextElementSibling() {
        if (this.parentNode == null) {
            return null;
        }
        List<Element> siblings = this.parent().childElementsList();
        int index2 = Element.indexInList(this, siblings);
        if (siblings.size() > index2 + 1) {
            return siblings.get(index2 + 1);
        }
        return null;
    }

    public Elements nextElementSiblings() {
        return this.nextElementSiblings(true);
    }

    @Nullable
    public Element previousElementSibling() {
        if (this.parentNode == null) {
            return null;
        }
        List<Element> siblings = this.parent().childElementsList();
        int index2 = Element.indexInList(this, siblings);
        if (index2 > 0) {
            return siblings.get(index2 - 1);
        }
        return null;
    }

    public Elements previousElementSiblings() {
        return this.nextElementSiblings(false);
    }

    private Elements nextElementSiblings(boolean next2) {
        Elements els = new Elements();
        if (this.parentNode == null) {
            return els;
        }
        els.add(this);
        return next2 ? els.nextAll() : els.prevAll();
    }

    public Element firstElementSibling() {
        if (this.parent() != null) {
            List<Element> siblings = this.parent().childElementsList();
            return siblings.size() > 1 ? siblings.get(0) : this;
        }
        return this;
    }

    public int elementSiblingIndex() {
        if (this.parent() == null) {
            return 0;
        }
        return Element.indexInList(this, this.parent().childElementsList());
    }

    public Element lastElementSibling() {
        if (this.parent() != null) {
            List<Element> siblings = this.parent().childElementsList();
            return siblings.size() > 1 ? siblings.get(siblings.size() - 1) : this;
        }
        return this;
    }

    private static <E extends Element> int indexInList(Element search, List<E> elements) {
        int size2 = elements.size();
        for (int i = 0; i < size2; ++i) {
            if (elements.get(i) != search) continue;
            return i;
        }
        return 0;
    }

    @Nullable
    public Element firstElementChild() {
        int size2 = this.childNodeSize();
        if (size2 == 0) {
            return null;
        }
        List<Node> children2 = this.ensureChildNodes();
        for (int i = 0; i < size2; ++i) {
            Node node = children2.get(i);
            if (!(node instanceof Element)) continue;
            return (Element)node;
        }
        return null;
    }

    @Nullable
    public Element lastElementChild() {
        int size2 = this.childNodeSize();
        if (size2 == 0) {
            return null;
        }
        List<Node> children2 = this.ensureChildNodes();
        for (int i = size2 - 1; i >= 0; --i) {
            Node node = children2.get(i);
            if (!(node instanceof Element)) continue;
            return (Element)node;
        }
        return null;
    }

    public Elements getElementsByTag(String tagName) {
        Validate.notEmpty(tagName);
        tagName = Normalizer.normalize(tagName);
        return Collector.collect(new Evaluator.Tag(tagName), this);
    }

    @Nullable
    public Element getElementById(String id) {
        Validate.notEmpty(id);
        Elements elements = Collector.collect(new Evaluator.Id(id), this);
        if (elements.size() > 0) {
            return (Element)elements.get(0);
        }
        return null;
    }

    public Elements getElementsByClass(String className) {
        Validate.notEmpty(className);
        return Collector.collect(new Evaluator.Class(className), this);
    }

    public Elements getElementsByAttribute(String key) {
        Validate.notEmpty(key);
        key = key.trim();
        return Collector.collect(new Evaluator.Attribute(key), this);
    }

    public Elements getElementsByAttributeStarting(String keyPrefix) {
        Validate.notEmpty(keyPrefix);
        keyPrefix = keyPrefix.trim();
        return Collector.collect(new Evaluator.AttributeStarting(keyPrefix), this);
    }

    public Elements getElementsByAttributeValue(String key, String value) {
        return Collector.collect(new Evaluator.AttributeWithValue(key, value), this);
    }

    public Elements getElementsByAttributeValueNot(String key, String value) {
        return Collector.collect(new Evaluator.AttributeWithValueNot(key, value), this);
    }

    public Elements getElementsByAttributeValueStarting(String key, String valuePrefix) {
        return Collector.collect(new Evaluator.AttributeWithValueStarting(key, valuePrefix), this);
    }

    public Elements getElementsByAttributeValueEnding(String key, String valueSuffix) {
        return Collector.collect(new Evaluator.AttributeWithValueEnding(key, valueSuffix), this);
    }

    public Elements getElementsByAttributeValueContaining(String key, String match) {
        return Collector.collect(new Evaluator.AttributeWithValueContaining(key, match), this);
    }

    public Elements getElementsByAttributeValueMatching(String key, Pattern pattern) {
        return Collector.collect(new Evaluator.AttributeWithValueMatching(key, pattern), this);
    }

    public Elements getElementsByAttributeValueMatching(String key, String regex) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Pattern syntax error: " + regex, e);
        }
        return this.getElementsByAttributeValueMatching(key, pattern);
    }

    public Elements getElementsByIndexLessThan(int index2) {
        return Collector.collect(new Evaluator.IndexLessThan(index2), this);
    }

    public Elements getElementsByIndexGreaterThan(int index2) {
        return Collector.collect(new Evaluator.IndexGreaterThan(index2), this);
    }

    public Elements getElementsByIndexEquals(int index2) {
        return Collector.collect(new Evaluator.IndexEquals(index2), this);
    }

    public Elements getElementsContainingText(String searchText) {
        return Collector.collect(new Evaluator.ContainsText(searchText), this);
    }

    public Elements getElementsContainingOwnText(String searchText) {
        return Collector.collect(new Evaluator.ContainsOwnText(searchText), this);
    }

    public Elements getElementsMatchingText(Pattern pattern) {
        return Collector.collect(new Evaluator.Matches(pattern), this);
    }

    public Elements getElementsMatchingText(String regex) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Pattern syntax error: " + regex, e);
        }
        return this.getElementsMatchingText(pattern);
    }

    public Elements getElementsMatchingOwnText(Pattern pattern) {
        return Collector.collect(new Evaluator.MatchesOwn(pattern), this);
    }

    public Elements getElementsMatchingOwnText(String regex) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Pattern syntax error: " + regex, e);
        }
        return this.getElementsMatchingOwnText(pattern);
    }

    public Elements getAllElements() {
        return Collector.collect(new Evaluator.AllElements(), this);
    }

    public String text() {
        final StringBuilder accum = StringUtil.borrowBuilder();
        NodeTraversor.traverse(new NodeVisitor(){

            @Override
            public void head(Node node, int depth) {
                if (node instanceof TextNode) {
                    TextNode textNode = (TextNode)node;
                    Element.appendNormalisedText(accum, textNode);
                } else if (node instanceof Element) {
                    Element element = (Element)node;
                    if (accum.length() > 0 && (element.isBlock() || element.isNode("br")) && !TextNode.lastCharIsWhitespace(accum)) {
                        accum.append(' ');
                    }
                }
            }

            @Override
            public void tail(Node node, int depth) {
                if (node instanceof Element) {
                    Element element = (Element)node;
                    Node next2 = node.nextSibling();
                    if (element.isBlock() && (next2 instanceof TextNode || next2 instanceof Element && !((Element)next2).tag.formatAsBlock()) && !TextNode.lastCharIsWhitespace(accum)) {
                        accum.append(' ');
                    }
                }
            }
        }, this);
        return StringUtil.releaseBuilder(accum).trim();
    }

    public String wholeText() {
        StringBuilder accum = StringUtil.borrowBuilder();
        NodeTraversor.traverse((node, depth) -> Element.appendWholeText(node, accum), this);
        return StringUtil.releaseBuilder(accum);
    }

    private static void appendWholeText(Node node, StringBuilder accum) {
        if (node instanceof TextNode) {
            accum.append(((TextNode)node).getWholeText());
        } else if (node.isNode("br")) {
            accum.append("\n");
        }
    }

    public String wholeOwnText() {
        StringBuilder accum = StringUtil.borrowBuilder();
        int size2 = this.childNodeSize();
        for (int i = 0; i < size2; ++i) {
            Node node = this.childNodes.get(i);
            Element.appendWholeText(node, accum);
        }
        return StringUtil.releaseBuilder(accum);
    }

    public String ownText() {
        StringBuilder sb = StringUtil.borrowBuilder();
        this.ownText(sb);
        return StringUtil.releaseBuilder(sb).trim();
    }

    private void ownText(StringBuilder accum) {
        for (int i = 0; i < this.childNodeSize(); ++i) {
            Node child2 = this.childNodes.get(i);
            if (child2 instanceof TextNode) {
                TextNode textNode = (TextNode)child2;
                Element.appendNormalisedText(accum, textNode);
                continue;
            }
            if (!child2.isNode("br") || TextNode.lastCharIsWhitespace(accum)) continue;
            accum.append(" ");
        }
    }

    private static void appendNormalisedText(StringBuilder accum, TextNode textNode) {
        String text2 = textNode.getWholeText();
        if (Element.preserveWhitespace(textNode.parentNode) || textNode instanceof CDataNode) {
            accum.append(text2);
        } else {
            StringUtil.appendNormalisedWhitespace(accum, text2, TextNode.lastCharIsWhitespace(accum));
        }
    }

    static boolean preserveWhitespace(@Nullable Node node) {
        if (node instanceof Element) {
            Element el = (Element)node;
            int i = 0;
            do {
                if (el.tag.preserveWhitespace()) {
                    return true;
                }
                el = el.parent();
            } while (++i < 6 && el != null);
        }
        return false;
    }

    public Element text(String text2) {
        Validate.notNull(text2);
        this.empty();
        Document owner2 = this.ownerDocument();
        if (owner2 != null && owner2.parser().isContentForTagData(this.normalName())) {
            this.appendChild(new DataNode(text2));
        } else {
            this.appendChild(new TextNode(text2));
        }
        return this;
    }

    public boolean hasText() {
        AtomicBoolean hasText = new AtomicBoolean(false);
        this.filter((node, depth) -> {
            TextNode textNode;
            if (node instanceof TextNode && !(textNode = (TextNode)node).isBlank()) {
                hasText.set(true);
                return NodeFilter.FilterResult.STOP;
            }
            return NodeFilter.FilterResult.CONTINUE;
        });
        return hasText.get();
    }

    public String data() {
        StringBuilder sb = StringUtil.borrowBuilder();
        this.traverse((childNode, depth) -> {
            if (childNode instanceof DataNode) {
                DataNode data2 = (DataNode)childNode;
                sb.append(data2.getWholeData());
            } else if (childNode instanceof Comment) {
                Comment comment = (Comment)childNode;
                sb.append(comment.getData());
            } else if (childNode instanceof CDataNode) {
                CDataNode cDataNode = (CDataNode)childNode;
                sb.append(cDataNode.getWholeText());
            }
        });
        return StringUtil.releaseBuilder(sb);
    }

    public String className() {
        return this.attr("class").trim();
    }

    public Set<String> classNames() {
        String[] names = ClassSplit.split(this.className());
        LinkedHashSet<String> classNames2 = new LinkedHashSet<String>(Arrays.asList(names));
        classNames2.remove("");
        return classNames2;
    }

    public Element classNames(Set<String> classNames2) {
        Validate.notNull(classNames2);
        if (classNames2.isEmpty()) {
            this.attributes().remove("class");
        } else {
            this.attributes().put("class", StringUtil.join(classNames2, " "));
        }
        return this;
    }

    public boolean hasClass(String className) {
        if (this.attributes == null) {
            return false;
        }
        String classAttr = this.attributes.getIgnoreCase("class");
        int len = classAttr.length();
        int wantLen = className.length();
        if (len == 0 || len < wantLen) {
            return false;
        }
        if (len == wantLen) {
            return className.equalsIgnoreCase(classAttr);
        }
        boolean inClass = false;
        int start2 = 0;
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(classAttr.charAt(i))) {
                if (!inClass) continue;
                if (i - start2 == wantLen && classAttr.regionMatches(true, start2, className, 0, wantLen)) {
                    return true;
                }
                inClass = false;
                continue;
            }
            if (inClass) continue;
            inClass = true;
            start2 = i;
        }
        if (inClass && len - start2 == wantLen) {
            return classAttr.regionMatches(true, start2, className, 0, wantLen);
        }
        return false;
    }

    public Element addClass(String className) {
        Validate.notNull(className);
        Set<String> classes2 = this.classNames();
        classes2.add(className);
        this.classNames(classes2);
        return this;
    }

    public Element removeClass(String className) {
        Validate.notNull(className);
        Set<String> classes2 = this.classNames();
        classes2.remove(className);
        this.classNames(classes2);
        return this;
    }

    public Element toggleClass(String className) {
        Validate.notNull(className);
        Set<String> classes2 = this.classNames();
        if (classes2.contains(className)) {
            classes2.remove(className);
        } else {
            classes2.add(className);
        }
        this.classNames(classes2);
        return this;
    }

    public String val() {
        if (this.normalName().equals("textarea")) {
            return this.text();
        }
        return this.attr("value");
    }

    public Element val(String value) {
        if (this.normalName().equals("textarea")) {
            this.text(value);
        } else {
            this.attr("value", value);
        }
        return this;
    }

    public Range endSourceRange() {
        return Range.of(this, false);
    }

    boolean shouldIndent(Document.OutputSettings out) {
        return out.prettyPrint() && this.isFormatAsBlock(out) && !this.isInlineable(out);
    }

    @Override
    void outerHtmlHead(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        if (this.shouldIndent(out)) {
            if (accum instanceof StringBuilder) {
                if (((StringBuilder)accum).length() > 0) {
                    this.indent(accum, depth, out);
                }
            } else {
                this.indent(accum, depth, out);
            }
        }
        accum.append('<').append(this.tagName());
        if (this.attributes != null) {
            this.attributes.html(accum, out);
        }
        if (this.childNodes.isEmpty() && this.tag.isSelfClosing()) {
            if (out.syntax() == Document.OutputSettings.Syntax.html && this.tag.isEmpty()) {
                accum.append('>');
            } else {
                accum.append(" />");
            }
        } else {
            accum.append('>');
        }
    }

    @Override
    void outerHtmlTail(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        if (!this.childNodes.isEmpty() || !this.tag.isSelfClosing()) {
            if (out.prettyPrint() && !this.childNodes.isEmpty() && (this.tag.formatAsBlock() || out.outline() && (this.childNodes.size() > 1 || this.childNodes.size() == 1 && this.childNodes.get(0) instanceof Element))) {
                this.indent(accum, depth, out);
            }
            accum.append("</").append(this.tagName()).append('>');
        }
    }

    public String html() {
        StringBuilder accum = StringUtil.borrowBuilder();
        this.html(accum);
        String html = StringUtil.releaseBuilder(accum);
        return NodeUtils.outputSettings(this).prettyPrint() ? html.trim() : html;
    }

    @Override
    public <T extends Appendable> T html(T appendable) {
        int size2 = this.childNodes.size();
        for (int i = 0; i < size2; ++i) {
            this.childNodes.get(i).outerHtml(appendable);
        }
        return appendable;
    }

    public Element html(String html) {
        this.empty();
        this.append(html);
        return this;
    }

    @Override
    public Element clone() {
        return (Element)super.clone();
    }

    @Override
    public Element shallowClone() {
        return new Element(this.tag, this.baseUri(), this.attributes == null ? null : this.attributes.clone());
    }

    @Override
    protected Element doClone(@Nullable Node parent2) {
        Element clone2 = (Element)super.doClone(parent2);
        clone2.attributes = this.attributes != null ? this.attributes.clone() : null;
        clone2.childNodes = new NodeList(clone2, this.childNodes.size());
        clone2.childNodes.addAll(this.childNodes);
        return clone2;
    }

    @Override
    public Element clearAttributes() {
        if (this.attributes != null) {
            super.clearAttributes();
            this.attributes = null;
        }
        return this;
    }

    @Override
    public Element removeAttr(String attributeKey) {
        return (Element)super.removeAttr(attributeKey);
    }

    @Override
    public Element root() {
        return (Element)super.root();
    }

    @Override
    public Element traverse(NodeVisitor nodeVisitor) {
        return (Element)super.traverse(nodeVisitor);
    }

    @Override
    public Element forEachNode(java.util.function.Consumer<? super Node> action) {
        return (Element)super.forEachNode(action);
    }

    public Element forEach(java.util.function.Consumer<? super Element> action) {
        Validate.notNull(action);
        NodeTraversor.traverse((node, depth) -> {
            if (node instanceof Element) {
                action.accept((Element)node);
            }
        }, this);
        return this;
    }

    public Element forEach(Consumer<? super Element> action) {
        Validate.notNull(action);
        NodeTraversor.traverse((node, depth) -> {
            if (node instanceof Element) {
                action.accept((Element)node);
            }
        }, this);
        return this;
    }

    @Override
    public Element filter(NodeFilter nodeFilter) {
        return (Element)super.filter(nodeFilter);
    }

    private boolean isFormatAsBlock(Document.OutputSettings out) {
        return this.tag.formatAsBlock() || this.parent() != null && this.parent().tag().formatAsBlock() || out.outline();
    }

    private boolean isInlineable(Document.OutputSettings out) {
        return this.tag().isInline() && (this.parent() == null || this.parent().isBlock()) && this.previousSibling() != null && !out.outline();
    }

    private static final class NodeList
    extends ChangeNotifyingArrayList<Node> {
        private final Element owner;

        NodeList(Element owner2, int initialCapacity) {
            super(initialCapacity);
            this.owner = owner2;
        }

        @Override
        public void onContentsChanged() {
            this.owner.nodelistChanged();
        }
    }
}

