/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.LeafNode;
import org.jsoup.nodes.Node;

public class TextNode
extends LeafNode {
    public TextNode(String text2) {
        this.value = text2;
    }

    @Override
    public String nodeName() {
        return "#text";
    }

    public String text() {
        return StringUtil.normaliseWhitespace(this.getWholeText());
    }

    public TextNode text(String text2) {
        this.coreValue(text2);
        return this;
    }

    public String getWholeText() {
        return this.coreValue();
    }

    public boolean isBlank() {
        return StringUtil.isBlank(this.coreValue());
    }

    public TextNode splitText(int offset2) {
        String text2 = this.coreValue();
        Validate.isTrue(offset2 >= 0, "Split offset must be not be negative");
        Validate.isTrue(offset2 < text2.length(), "Split offset must not be greater than current text length");
        String head = text2.substring(0, offset2);
        String tail = text2.substring(offset2);
        this.text(head);
        TextNode tailNode = new TextNode(tail);
        if (this.parentNode != null) {
            this.parentNode.addChildren(this.siblingIndex() + 1, tailNode);
        }
        return tailNode;
    }

    @Override
    void outerHtmlHead(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        boolean prettyPrint = out.prettyPrint();
        Element parent2 = this.parentNode instanceof Element ? (Element)this.parentNode : null;
        boolean normaliseWhite = prettyPrint && !Element.preserveWhitespace(this.parentNode);
        boolean trimLikeBlock = parent2 != null && (parent2.tag().isBlock() || parent2.tag().formatAsBlock());
        boolean trimLeading = false;
        boolean trimTrailing = false;
        if (normaliseWhite) {
            boolean couldSkip;
            trimLeading = trimLikeBlock && this.siblingIndex == 0 || this.parentNode instanceof Document;
            trimTrailing = trimLikeBlock && this.nextSibling() == null;
            Node next2 = this.nextSibling();
            Node prev = this.previousSibling();
            boolean isBlank = this.isBlank();
            boolean bl = couldSkip = next2 instanceof Element && ((Element)next2).shouldIndent(out) || next2 instanceof TextNode && ((TextNode)next2).isBlank() || prev instanceof Element && (((Element)prev).isBlock() || prev.isNode("br"));
            if (couldSkip && isBlank) {
                return;
            }
            if (this.siblingIndex == 0 && parent2 != null && parent2.tag().formatAsBlock() && !isBlank || out.outline() && this.siblingNodes().size() > 0 && !isBlank || this.siblingIndex > 0 && TextNode.isNode(prev, "br")) {
                this.indent(accum, depth, out);
            }
        }
        Entities.escape(accum, this.coreValue(), out, false, normaliseWhite, trimLeading, trimTrailing);
    }

    @Override
    void outerHtmlTail(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    @Override
    public TextNode clone() {
        return (TextNode)super.clone();
    }

    public static TextNode createFromEncoded(String encodedText) {
        String text2 = Entities.unescape(encodedText);
        return new TextNode(text2);
    }

    static String normaliseWhitespace(String text2) {
        text2 = StringUtil.normaliseWhitespace(text2);
        return text2;
    }

    static String stripLeadingWhitespace(String text2) {
        return text2.replaceFirst("^\\s+", "");
    }

    static boolean lastCharIsWhitespace(StringBuilder sb) {
        return sb.length() != 0 && sb.charAt(sb.length() - 1) == ' ';
    }
}

