/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.Range;
import org.jsoup.parser.CharacterReader;
import org.jsoup.parser.ParseError;
import org.jsoup.parser.ParseErrorList;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.parser.Token;
import org.jsoup.parser.Tokeniser;

abstract class TreeBuilder {
    protected Parser parser;
    CharacterReader reader;
    Tokeniser tokeniser;
    protected Document doc;
    protected ArrayList<Element> stack;
    protected String baseUri;
    protected Token currentToken;
    protected ParseSettings settings;
    protected Map<String, Tag> seenTags;
    private Token.StartTag start = new Token.StartTag();
    private Token.EndTag end = new Token.EndTag();
    private boolean trackSourceRange;

    TreeBuilder() {
    }

    abstract ParseSettings defaultSettings();

    @ParametersAreNonnullByDefault
    protected void initialiseParse(Reader input, String baseUri, Parser parser) {
        Validate.notNullParam(input, "input");
        Validate.notNullParam(baseUri, "baseUri");
        Validate.notNull(parser);
        this.doc = new Document(baseUri);
        this.doc.parser(parser);
        this.parser = parser;
        this.settings = parser.settings();
        this.reader = new CharacterReader(input);
        this.trackSourceRange = parser.isTrackPosition();
        this.reader.trackNewlines(parser.isTrackErrors() || this.trackSourceRange);
        this.currentToken = null;
        this.tokeniser = new Tokeniser(this.reader, parser.getErrors());
        this.stack = new ArrayList(32);
        this.seenTags = new HashMap<String, Tag>();
        this.baseUri = baseUri;
    }

    @ParametersAreNonnullByDefault
    Document parse(Reader input, String baseUri, Parser parser) {
        this.initialiseParse(input, baseUri, parser);
        this.runParser();
        this.reader.close();
        this.reader = null;
        this.tokeniser = null;
        this.stack = null;
        this.seenTags = null;
        return this.doc;
    }

    abstract TreeBuilder newInstance();

    abstract List<Node> parseFragment(String var1, Element var2, String var3, Parser var4);

    protected void runParser() {
        Token token2;
        Tokeniser tokeniser = this.tokeniser;
        Token.TokenType eof = Token.TokenType.EOF;
        do {
            token2 = tokeniser.read();
            this.process(token2);
            token2.reset();
        } while (token2.type != eof);
    }

    protected abstract boolean process(Token var1);

    protected boolean processStartTag(String name) {
        Token.StartTag start2 = this.start;
        if (this.currentToken == start2) {
            return this.process(new Token.StartTag().name(name));
        }
        return this.process(start2.reset().name(name));
    }

    public boolean processStartTag(String name, Attributes attrs) {
        Token.StartTag start2 = this.start;
        if (this.currentToken == start2) {
            return this.process(new Token.StartTag().nameAttr(name, attrs));
        }
        start2.reset();
        start2.nameAttr(name, attrs);
        return this.process(start2);
    }

    protected boolean processEndTag(String name) {
        if (this.currentToken == this.end) {
            return this.process(new Token.EndTag().name(name));
        }
        return this.process(this.end.reset().name(name));
    }

    protected Element currentElement() {
        int size2 = this.stack.size();
        return size2 > 0 ? this.stack.get(size2 - 1) : this.doc;
    }

    protected boolean currentElementIs(String normalName) {
        if (this.stack.size() == 0) {
            return false;
        }
        Element current = this.currentElement();
        return current != null && current.normalName().equals(normalName);
    }

    protected void error(String msg) {
        this.error(msg, null);
    }

    protected void error(String msg, Object ... args2) {
        ParseErrorList errors = this.parser.getErrors();
        if (errors.canAddError()) {
            errors.add(new ParseError(this.reader, msg, args2));
        }
    }

    protected boolean isContentForTagData(String normalName) {
        return false;
    }

    protected Tag tagFor(String tagName, ParseSettings settings) {
        Tag tag = this.seenTags.get(tagName);
        if (tag == null) {
            tag = Tag.valueOf(tagName, settings);
            this.seenTags.put(tagName, tag);
        }
        return tag;
    }

    protected void onNodeInserted(Node node, @Nullable Token token2) {
        this.trackNodePosition(node, token2, true);
    }

    protected void onNodeClosed(Node node, Token token2) {
        this.trackNodePosition(node, token2, false);
    }

    private void trackNodePosition(Node node, @Nullable Token token2, boolean start2) {
        if (this.trackSourceRange && token2 != null) {
            int startPos = token2.startPos();
            if (startPos == -1) {
                return;
            }
            Range.Position startRange = new Range.Position(startPos, this.reader.lineNumber(startPos), this.reader.columnNumber(startPos));
            int endPos = token2.endPos();
            Range.Position endRange = new Range.Position(endPos, this.reader.lineNumber(endPos), this.reader.columnNumber(endPos));
            Range range = new Range(startRange, endRange);
            range.track(node, start2);
        }
    }
}

