/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.android;

import android.util.Log;
import org.opencv.core.Core;

class StaticHelper {
    private static final String TAG = "OpenCV/StaticHelper";

    StaticHelper() {
    }

    public static boolean initOpenCV(boolean InitCuda) {
        boolean result2;
        String libs = "";
        if (InitCuda) {
            Log.w((String)TAG, (String)"CUDA support was removed!");
        }
        Log.d((String)TAG, (String)"First attempt to load libs");
        if (StaticHelper.loadLibrary("opencv_java4")) {
            Log.d((String)TAG, (String)"First attempt to load libs is OK");
            String eol = System.getProperty("line.separator");
            for (String str : Core.getBuildInformation().split(eol)) {
                Log.i((String)TAG, (String)str);
            }
            result2 = true;
        } else {
            Log.d((String)TAG, (String)"First attempt to load libs fails");
            result2 = false;
        }
        return result2;
    }

    private static boolean loadLibrary(String Name4) {
        boolean result2 = true;
        Log.d((String)TAG, (String)("Trying to load library " + Name4));
        try {
            System.loadLibrary(Name4);
            Log.d((String)TAG, (String)("Library " + Name4 + " loaded"));
        }
        catch (UnsatisfiedLinkError e) {
            Log.d((String)TAG, (String)("Cannot load library \"" + Name4 + "\""));
            e.printStackTrace();
            result2 = false;
        }
        return result2;
    }

    private static native String getLibraryList();
}

