/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import java.nio.ByteBuffer;
import org.opencv.core.CvType;
import org.opencv.core.Point;
import org.opencv.core.Range;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;

public class Mat {
    public final long nativeObj;

    public Mat(long addr) {
        if (addr == 0L) {
            throw new UnsupportedOperationException("Native object address is NULL");
        }
        this.nativeObj = addr;
    }

    public Mat() {
        this.nativeObj = Mat.n_Mat();
    }

    public Mat(int rows, int cols, int type2) {
        this.nativeObj = Mat.n_Mat(rows, cols, type2);
    }

    public Mat(int rows, int cols, int type2, ByteBuffer data2) {
        this.nativeObj = Mat.n_Mat(rows, cols, type2, data2);
    }

    public Mat(int rows, int cols, int type2, ByteBuffer data2, long step) {
        this.nativeObj = Mat.n_Mat(rows, cols, type2, data2, step);
    }

    public Mat(Size size2, int type2) {
        this.nativeObj = Mat.n_Mat(size2.width, size2.height, type2);
    }

    public Mat(int[] sizes, int type2) {
        this.nativeObj = Mat.n_Mat(sizes.length, sizes, type2);
    }

    public Mat(int rows, int cols, int type2, Scalar s) {
        this.nativeObj = Mat.n_Mat(rows, cols, type2, s.val[0], s.val[1], s.val[2], s.val[3]);
    }

    public Mat(Size size2, int type2, Scalar s) {
        this.nativeObj = Mat.n_Mat(size2.width, size2.height, type2, s.val[0], s.val[1], s.val[2], s.val[3]);
    }

    public Mat(int[] sizes, int type2, Scalar s) {
        this.nativeObj = Mat.n_Mat(sizes.length, sizes, type2, s.val[0], s.val[1], s.val[2], s.val[3]);
    }

    public Mat(Mat m, Range rowRange, Range colRange) {
        this.nativeObj = Mat.n_Mat(m.nativeObj, rowRange.start, rowRange.end, colRange.start, colRange.end);
    }

    public Mat(Mat m, Range rowRange) {
        this.nativeObj = Mat.n_Mat(m.nativeObj, rowRange.start, rowRange.end);
    }

    public Mat(Mat m, Range[] ranges) {
        this.nativeObj = Mat.n_Mat(m.nativeObj, ranges);
    }

    public Mat(Mat m, Rect roi) {
        this.nativeObj = Mat.n_Mat(m.nativeObj, roi.y, roi.y + roi.height, roi.x, roi.x + roi.width);
    }

    public Mat adjustROI(int dtop, int dbottom, int dleft, int dright) {
        return new Mat(Mat.n_adjustROI(this.nativeObj, dtop, dbottom, dleft, dright));
    }

    public void assignTo(Mat m, int type2) {
        Mat.n_assignTo(this.nativeObj, m.nativeObj, type2);
    }

    public void assignTo(Mat m) {
        Mat.n_assignTo(this.nativeObj, m.nativeObj);
    }

    public int channels() {
        return Mat.n_channels(this.nativeObj);
    }

    public int checkVector(int elemChannels, int depth, boolean requireContinuous) {
        return Mat.n_checkVector(this.nativeObj, elemChannels, depth, requireContinuous);
    }

    public int checkVector(int elemChannels, int depth) {
        return Mat.n_checkVector(this.nativeObj, elemChannels, depth);
    }

    public int checkVector(int elemChannels) {
        return Mat.n_checkVector(this.nativeObj, elemChannels);
    }

    public Mat clone() {
        return new Mat(Mat.n_clone(this.nativeObj));
    }

    public Mat col(int x2) {
        return new Mat(Mat.n_col(this.nativeObj, x2));
    }

    public Mat colRange(int startcol, int endcol) {
        return new Mat(Mat.n_colRange(this.nativeObj, startcol, endcol));
    }

    public Mat colRange(Range r) {
        return new Mat(Mat.n_colRange(this.nativeObj, r.start, r.end));
    }

    public int dims() {
        return Mat.n_dims(this.nativeObj);
    }

    public int cols() {
        return Mat.n_cols(this.nativeObj);
    }

    public void convertTo(Mat m, int rtype, double alpha2, double beta) {
        Mat.n_convertTo(this.nativeObj, m.nativeObj, rtype, alpha2, beta);
    }

    public void convertTo(Mat m, int rtype, double alpha2) {
        Mat.n_convertTo(this.nativeObj, m.nativeObj, rtype, alpha2);
    }

    public void convertTo(Mat m, int rtype) {
        Mat.n_convertTo(this.nativeObj, m.nativeObj, rtype);
    }

    public void copyTo(Mat m) {
        Mat.n_copyTo(this.nativeObj, m.nativeObj);
    }

    public void copyTo(Mat m, Mat mask) {
        Mat.n_copyTo(this.nativeObj, m.nativeObj, mask.nativeObj);
    }

    public void create(int rows, int cols, int type2) {
        Mat.n_create(this.nativeObj, rows, cols, type2);
    }

    public void create(Size size2, int type2) {
        Mat.n_create(this.nativeObj, size2.width, size2.height, type2);
    }

    public void create(int[] sizes, int type2) {
        Mat.n_create(this.nativeObj, sizes.length, sizes, type2);
    }

    public void copySize(Mat m) {
        Mat.n_copySize(this.nativeObj, m.nativeObj);
    }

    public Mat cross(Mat m) {
        return new Mat(Mat.n_cross(this.nativeObj, m.nativeObj));
    }

    public long dataAddr() {
        return Mat.n_dataAddr(this.nativeObj);
    }

    public int depth() {
        return Mat.n_depth(this.nativeObj);
    }

    public Mat diag(int d) {
        return new Mat(Mat.n_diag(this.nativeObj, d));
    }

    public Mat diag() {
        return new Mat(Mat.n_diag(this.nativeObj, 0));
    }

    public static Mat diag(Mat d) {
        return new Mat(Mat.n_diag(d.nativeObj));
    }

    public double dot(Mat m) {
        return Mat.n_dot(this.nativeObj, m.nativeObj);
    }

    public long elemSize() {
        return Mat.n_elemSize(this.nativeObj);
    }

    public long elemSize1() {
        return Mat.n_elemSize1(this.nativeObj);
    }

    public boolean empty() {
        return Mat.n_empty(this.nativeObj);
    }

    public static Mat eye(int rows, int cols, int type2) {
        return new Mat(Mat.n_eye(rows, cols, type2));
    }

    public static Mat eye(Size size2, int type2) {
        return new Mat(Mat.n_eye(size2.width, size2.height, type2));
    }

    public Mat inv(int method) {
        return new Mat(Mat.n_inv(this.nativeObj, method));
    }

    public Mat inv() {
        return new Mat(Mat.n_inv(this.nativeObj));
    }

    public boolean isContinuous() {
        return Mat.n_isContinuous(this.nativeObj);
    }

    public boolean isSubmatrix() {
        return Mat.n_isSubmatrix(this.nativeObj);
    }

    public void locateROI(Size wholeSize, Point ofs) {
        double[] wholeSize_out = new double[2];
        double[] ofs_out = new double[2];
        Mat.locateROI_0(this.nativeObj, wholeSize_out, ofs_out);
        if (wholeSize != null) {
            wholeSize.width = wholeSize_out[0];
            wholeSize.height = wholeSize_out[1];
        }
        if (ofs != null) {
            ofs.x = ofs_out[0];
            ofs.y = ofs_out[1];
        }
    }

    public Mat mul(Mat m, double scale2) {
        return new Mat(Mat.n_mul(this.nativeObj, m.nativeObj, scale2));
    }

    public Mat mul(Mat m) {
        return new Mat(Mat.n_mul(this.nativeObj, m.nativeObj));
    }

    public Mat matMul(Mat m) {
        return new Mat(Mat.n_matMul(this.nativeObj, m.nativeObj));
    }

    public static Mat ones(int rows, int cols, int type2) {
        return new Mat(Mat.n_ones(rows, cols, type2));
    }

    public static Mat ones(Size size2, int type2) {
        return new Mat(Mat.n_ones(size2.width, size2.height, type2));
    }

    public static Mat ones(int[] sizes, int type2) {
        return new Mat(Mat.n_ones(sizes.length, sizes, type2));
    }

    public void push_back(Mat m) {
        Mat.n_push_back(this.nativeObj, m.nativeObj);
    }

    public void release() {
        Mat.n_release(this.nativeObj);
    }

    public Mat reshape(int cn, int rows) {
        return new Mat(Mat.n_reshape(this.nativeObj, cn, rows));
    }

    public Mat reshape(int cn) {
        return new Mat(Mat.n_reshape(this.nativeObj, cn));
    }

    public Mat reshape(int cn, int[] newshape) {
        return new Mat(Mat.n_reshape_1(this.nativeObj, cn, newshape.length, newshape));
    }

    public Mat row(int y2) {
        return new Mat(Mat.n_row(this.nativeObj, y2));
    }

    public Mat rowRange(int startrow, int endrow) {
        return new Mat(Mat.n_rowRange(this.nativeObj, startrow, endrow));
    }

    public Mat rowRange(Range r) {
        return new Mat(Mat.n_rowRange(this.nativeObj, r.start, r.end));
    }

    public int rows() {
        return Mat.n_rows(this.nativeObj);
    }

    public Mat setTo(Scalar s) {
        return new Mat(Mat.n_setTo(this.nativeObj, s.val[0], s.val[1], s.val[2], s.val[3]));
    }

    public Mat setTo(Scalar value, Mat mask) {
        return new Mat(Mat.n_setTo(this.nativeObj, value.val[0], value.val[1], value.val[2], value.val[3], mask.nativeObj));
    }

    public Mat setTo(Mat value, Mat mask) {
        return new Mat(Mat.n_setTo(this.nativeObj, value.nativeObj, mask.nativeObj));
    }

    public Mat setTo(Mat value) {
        return new Mat(Mat.n_setTo(this.nativeObj, value.nativeObj));
    }

    public Size size() {
        return new Size(Mat.n_size(this.nativeObj));
    }

    public int size(int i) {
        return Mat.n_size_i(this.nativeObj, i);
    }

    public long step1(int i) {
        return Mat.n_step1(this.nativeObj, i);
    }

    public long step1() {
        return Mat.n_step1(this.nativeObj);
    }

    public Mat submat(int rowStart, int rowEnd, int colStart, int colEnd) {
        return new Mat(Mat.n_submat_rr(this.nativeObj, rowStart, rowEnd, colStart, colEnd));
    }

    public Mat submat(Range rowRange, Range colRange) {
        return new Mat(Mat.n_submat_rr(this.nativeObj, rowRange.start, rowRange.end, colRange.start, colRange.end));
    }

    public Mat submat(Range[] ranges) {
        return new Mat(Mat.n_submat_ranges(this.nativeObj, ranges));
    }

    public Mat submat(Rect roi) {
        return new Mat(Mat.n_submat(this.nativeObj, roi.x, roi.y, roi.width, roi.height));
    }

    public Mat t() {
        return new Mat(Mat.n_t(this.nativeObj));
    }

    public long total() {
        return Mat.n_total(this.nativeObj);
    }

    public int type() {
        return Mat.n_type(this.nativeObj);
    }

    public static Mat zeros(int rows, int cols, int type2) {
        return new Mat(Mat.n_zeros(rows, cols, type2));
    }

    public static Mat zeros(Size size2, int type2) {
        return new Mat(Mat.n_zeros(size2.width, size2.height, type2));
    }

    public static Mat zeros(int[] sizes, int type2) {
        return new Mat(Mat.n_zeros(sizes.length, sizes, type2));
    }

    protected void finalize() throws Throwable {
        Mat.n_delete(this.nativeObj);
        super.finalize();
    }

    public String toString() {
        String _dims = this.dims() > 0 ? "" : "-1*-1*";
        for (int i = 0; i < this.dims(); ++i) {
            _dims = _dims + this.size(i) + "*";
        }
        return "Mat [ " + _dims + CvType.typeToString(this.type()) + ", isCont=" + this.isContinuous() + ", isSubmat=" + this.isSubmatrix() + ", nativeObj=0x" + Long.toHexString(this.nativeObj) + ", dataAddr=0x" + Long.toHexString(this.dataAddr()) + " ]";
    }

    public String dump() {
        return Mat.nDump(this.nativeObj);
    }

    public int put(int row, int col, double ... data2) {
        int t = this.type();
        if (data2 == null || data2.length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        return Mat.nPutD(this.nativeObj, row, col, data2.length, data2);
    }

    public int put(int[] idx, double ... data2) {
        int t = this.type();
        if (data2 == null || data2.length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (idx.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        return Mat.nPutDIdx(this.nativeObj, idx, data2.length, data2);
    }

    public int put(int row, int col, float[] data2) {
        int t = this.type();
        if (data2 == null || data2.length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (CvType.depth(t) == 5) {
            return Mat.nPutF(this.nativeObj, row, col, data2.length, data2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + t);
    }

    public int put(int[] idx, float[] data2) {
        int t = this.type();
        if (data2 == null || data2.length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (idx.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        if (CvType.depth(t) == 5) {
            return Mat.nPutFIdx(this.nativeObj, idx, data2.length, data2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + t);
    }

    public int put(int row, int col, int[] data2) {
        int t = this.type();
        if (data2 == null || data2.length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (CvType.depth(t) == 4) {
            return Mat.nPutI(this.nativeObj, row, col, data2.length, data2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + t);
    }

    public int put(int[] idx, int[] data2) {
        int t = this.type();
        if (data2 == null || data2.length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (idx.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        if (CvType.depth(t) == 4) {
            return Mat.nPutIIdx(this.nativeObj, idx, data2.length, data2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + t);
    }

    public int put(int row, int col, short[] data2) {
        int t = this.type();
        if (data2 == null || data2.length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (CvType.depth(t) == 2 || CvType.depth(t) == 3) {
            return Mat.nPutS(this.nativeObj, row, col, data2.length, data2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + t);
    }

    public int put(int[] idx, short[] data2) {
        int t = this.type();
        if (data2 == null || data2.length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (idx.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        if (CvType.depth(t) == 2 || CvType.depth(t) == 3) {
            return Mat.nPutSIdx(this.nativeObj, idx, data2.length, data2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + t);
    }

    public int put(int row, int col, byte[] data2) {
        int t = this.type();
        if (data2 == null || data2.length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (CvType.depth(t) == 0 || CvType.depth(t) == 1) {
            return Mat.nPutB(this.nativeObj, row, col, data2.length, data2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + t);
    }

    public int put(int[] idx, byte[] data2) {
        int t = this.type();
        if (data2 == null || data2.length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (idx.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        if (CvType.depth(t) == 0 || CvType.depth(t) == 1) {
            return Mat.nPutBIdx(this.nativeObj, idx, data2.length, data2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + t);
    }

    public int put(int row, int col, byte[] data2, int offset2, int length) {
        int t = this.type();
        if (data2 == null || length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (CvType.depth(t) == 0 || CvType.depth(t) == 1) {
            return Mat.nPutBwOffset(this.nativeObj, row, col, length, offset2, data2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + t);
    }

    public int put(int[] idx, byte[] data2, int offset2, int length) {
        int t = this.type();
        if (data2 == null || length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (idx.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        if (CvType.depth(t) == 0 || CvType.depth(t) == 1) {
            return Mat.nPutBwIdxOffset(this.nativeObj, idx, length, offset2, data2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + t);
    }

    public int get(int row, int col, byte[] data2) {
        int t = this.type();
        if (data2 == null || data2.length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (CvType.depth(t) == 0 || CvType.depth(t) == 1) {
            return Mat.nGetB(this.nativeObj, row, col, data2.length, data2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + t);
    }

    public int get(int[] idx, byte[] data2) {
        int t = this.type();
        if (data2 == null || data2.length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (idx.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        if (CvType.depth(t) == 0 || CvType.depth(t) == 1) {
            return Mat.nGetBIdx(this.nativeObj, idx, data2.length, data2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + t);
    }

    public int get(int row, int col, short[] data2) {
        int t = this.type();
        if (data2 == null || data2.length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (CvType.depth(t) == 2 || CvType.depth(t) == 3) {
            return Mat.nGetS(this.nativeObj, row, col, data2.length, data2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + t);
    }

    public int get(int[] idx, short[] data2) {
        int t = this.type();
        if (data2 == null || data2.length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (idx.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        if (CvType.depth(t) == 2 || CvType.depth(t) == 3) {
            return Mat.nGetSIdx(this.nativeObj, idx, data2.length, data2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + t);
    }

    public int get(int row, int col, int[] data2) {
        int t = this.type();
        if (data2 == null || data2.length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (CvType.depth(t) == 4) {
            return Mat.nGetI(this.nativeObj, row, col, data2.length, data2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + t);
    }

    public int get(int[] idx, int[] data2) {
        int t = this.type();
        if (data2 == null || data2.length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (idx.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        if (CvType.depth(t) == 4) {
            return Mat.nGetIIdx(this.nativeObj, idx, data2.length, data2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + t);
    }

    public int get(int row, int col, float[] data2) {
        int t = this.type();
        if (data2 == null || data2.length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (CvType.depth(t) == 5) {
            return Mat.nGetF(this.nativeObj, row, col, data2.length, data2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + t);
    }

    public int get(int[] idx, float[] data2) {
        int t = this.type();
        if (data2 == null || data2.length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (idx.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        if (CvType.depth(t) == 5) {
            return Mat.nGetFIdx(this.nativeObj, idx, data2.length, data2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + t);
    }

    public int get(int row, int col, double[] data2) {
        int t = this.type();
        if (data2 == null || data2.length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (CvType.depth(t) == 6) {
            return Mat.nGetD(this.nativeObj, row, col, data2.length, data2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + t);
    }

    public int get(int[] idx, double[] data2) {
        int t = this.type();
        if (data2 == null || data2.length % CvType.channels(t) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (data2 == null ? 0 : data2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(t) + ")");
        }
        if (idx.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        if (CvType.depth(t) == 6) {
            return Mat.nGetDIdx(this.nativeObj, idx, data2.length, data2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + t);
    }

    public double[] get(int row, int col) {
        return Mat.nGet(this.nativeObj, row, col);
    }

    public double[] get(int[] idx) {
        if (idx.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        return Mat.nGetIdx(this.nativeObj, idx);
    }

    public int height() {
        return this.rows();
    }

    public int width() {
        return this.cols();
    }

    public <T> Atable<T> at(Class<T> clazz, int row, int col) {
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return new AtableByte(this, row, col);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return new AtableDouble(this, row, col);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return new AtableFloat(this, row, col);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return new AtableInteger(this, row, col);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return new AtableShort(this, row, col);
        }
        throw new RuntimeException("Unsupported class type");
    }

    public <T> Atable<T> at(Class<T> clazz, int[] idx) {
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return new AtableByte(this, idx);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return new AtableDouble(this, idx);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return new AtableFloat(this, idx);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return new AtableInteger(this, idx);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return new AtableShort(this, idx);
        }
        throw new RuntimeException("Unsupported class parameter");
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    private static native long n_Mat();

    private static native long n_Mat(int var0, int var1, int var2);

    private static native long n_Mat(int var0, int[] var1, int var2);

    private static native long n_Mat(int var0, int var1, int var2, ByteBuffer var3);

    private static native long n_Mat(int var0, int var1, int var2, ByteBuffer var3, long var4);

    private static native long n_Mat(double var0, double var2, int var4);

    private static native long n_Mat(int var0, int var1, int var2, double var3, double var5, double var7, double var9);

    private static native long n_Mat(double var0, double var2, int var4, double var5, double var7, double var9, double var11);

    private static native long n_Mat(int var0, int[] var1, int var2, double var3, double var5, double var7, double var9);

    private static native long n_Mat(long var0, int var2, int var3, int var4, int var5);

    private static native long n_Mat(long var0, int var2, int var3);

    private static native long n_Mat(long var0, Range[] var2);

    private static native long n_adjustROI(long var0, int var2, int var3, int var4, int var5);

    private static native void n_assignTo(long var0, long var2, int var4);

    private static native void n_assignTo(long var0, long var2);

    private static native int n_channels(long var0);

    private static native int n_checkVector(long var0, int var2, int var3, boolean var4);

    private static native int n_checkVector(long var0, int var2, int var3);

    private static native int n_checkVector(long var0, int var2);

    private static native long n_clone(long var0);

    private static native long n_col(long var0, int var2);

    private static native long n_colRange(long var0, int var2, int var3);

    private static native int n_dims(long var0);

    private static native int n_cols(long var0);

    private static native void n_convertTo(long var0, long var2, int var4, double var5, double var7);

    private static native void n_convertTo(long var0, long var2, int var4, double var5);

    private static native void n_convertTo(long var0, long var2, int var4);

    private static native void n_copyTo(long var0, long var2);

    private static native void n_copyTo(long var0, long var2, long var4);

    private static native void n_create(long var0, int var2, int var3, int var4);

    private static native void n_create(long var0, double var2, double var4, int var6);

    private static native void n_create(long var0, int var2, int[] var3, int var4);

    private static native void n_copySize(long var0, long var2);

    private static native long n_cross(long var0, long var2);

    private static native long n_dataAddr(long var0);

    private static native int n_depth(long var0);

    private static native long n_diag(long var0, int var2);

    private static native long n_diag(long var0);

    private static native double n_dot(long var0, long var2);

    private static native long n_elemSize(long var0);

    private static native long n_elemSize1(long var0);

    private static native boolean n_empty(long var0);

    private static native long n_eye(int var0, int var1, int var2);

    private static native long n_eye(double var0, double var2, int var4);

    private static native long n_inv(long var0, int var2);

    private static native long n_inv(long var0);

    private static native boolean n_isContinuous(long var0);

    private static native boolean n_isSubmatrix(long var0);

    private static native void locateROI_0(long var0, double[] var2, double[] var3);

    private static native long n_mul(long var0, long var2, double var4);

    private static native long n_mul(long var0, long var2);

    private static native long n_matMul(long var0, long var2);

    private static native long n_ones(int var0, int var1, int var2);

    private static native long n_ones(double var0, double var2, int var4);

    private static native long n_ones(int var0, int[] var1, int var2);

    private static native void n_push_back(long var0, long var2);

    private static native void n_release(long var0);

    private static native long n_reshape(long var0, int var2, int var3);

    private static native long n_reshape(long var0, int var2);

    private static native long n_reshape_1(long var0, int var2, int var3, int[] var4);

    private static native long n_row(long var0, int var2);

    private static native long n_rowRange(long var0, int var2, int var3);

    private static native int n_rows(long var0);

    private static native long n_setTo(long var0, double var2, double var4, double var6, double var8);

    private static native long n_setTo(long var0, double var2, double var4, double var6, double var8, long var10);

    private static native long n_setTo(long var0, long var2, long var4);

    private static native long n_setTo(long var0, long var2);

    private static native double[] n_size(long var0);

    private static native int n_size_i(long var0, int var2);

    private static native long n_step1(long var0, int var2);

    private static native long n_step1(long var0);

    private static native long n_submat_rr(long var0, int var2, int var3, int var4, int var5);

    private static native long n_submat_ranges(long var0, Range[] var2);

    private static native long n_submat(long var0, int var2, int var3, int var4, int var5);

    private static native long n_t(long var0);

    private static native long n_total(long var0);

    private static native int n_type(long var0);

    private static native long n_zeros(int var0, int var1, int var2);

    private static native long n_zeros(double var0, double var2, int var4);

    private static native long n_zeros(int var0, int[] var1, int var2);

    private static native void n_delete(long var0);

    private static native int nPutD(long var0, int var2, int var3, int var4, double[] var5);

    private static native int nPutDIdx(long var0, int[] var2, int var3, double[] var4);

    private static native int nPutF(long var0, int var2, int var3, int var4, float[] var5);

    private static native int nPutFIdx(long var0, int[] var2, int var3, float[] var4);

    private static native int nPutI(long var0, int var2, int var3, int var4, int[] var5);

    private static native int nPutIIdx(long var0, int[] var2, int var3, int[] var4);

    private static native int nPutS(long var0, int var2, int var3, int var4, short[] var5);

    private static native int nPutSIdx(long var0, int[] var2, int var3, short[] var4);

    private static native int nPutB(long var0, int var2, int var3, int var4, byte[] var5);

    private static native int nPutBIdx(long var0, int[] var2, int var3, byte[] var4);

    private static native int nPutBwOffset(long var0, int var2, int var3, int var4, int var5, byte[] var6);

    private static native int nPutBwIdxOffset(long var0, int[] var2, int var3, int var4, byte[] var5);

    private static native int nGetB(long var0, int var2, int var3, int var4, byte[] var5);

    private static native int nGetBIdx(long var0, int[] var2, int var3, byte[] var4);

    private static native int nGetS(long var0, int var2, int var3, int var4, short[] var5);

    private static native int nGetSIdx(long var0, int[] var2, int var3, short[] var4);

    private static native int nGetI(long var0, int var2, int var3, int var4, int[] var5);

    private static native int nGetIIdx(long var0, int[] var2, int var3, int[] var4);

    private static native int nGetF(long var0, int var2, int var3, int var4, float[] var5);

    private static native int nGetFIdx(long var0, int[] var2, int var3, float[] var4);

    private static native int nGetD(long var0, int var2, int var3, int var4, double[] var5);

    private static native int nGetDIdx(long var0, int[] var2, int var3, double[] var4);

    private static native double[] nGet(long var0, int var2, int var3);

    private static native double[] nGetIdx(long var0, int[] var2);

    private static native String nDump(long var0);

    private static class AtableShort
    extends AtableBase
    implements Atable<Short> {
        public AtableShort(Mat mat, int row, int col) {
            super(mat, row, col);
        }

        public AtableShort(Mat mat, int[] indices) {
            super(mat, indices);
        }

        @Override
        public Short getV() {
            short[] data2 = new short[1];
            this.mat.get(this.indices, data2);
            return data2[0];
        }

        @Override
        public void setV(Short v) {
            short[] data2 = new short[]{v};
            this.mat.put(this.indices, data2);
        }

        @Override
        public Tuple2<Short> getV2c() {
            short[] data2 = new short[2];
            this.mat.get(this.indices, data2);
            return new Tuple2<Short>(data2[0], data2[1]);
        }

        @Override
        public void setV2c(Tuple2<Short> v) {
            short[] data2 = new short[]{(Short)((Tuple2)v)._0, (Short)((Tuple2)v)._1};
            this.mat.put(this.indices, data2);
        }

        @Override
        public Tuple3<Short> getV3c() {
            short[] data2 = new short[3];
            this.mat.get(this.indices, data2);
            return new Tuple3<Short>(data2[0], data2[1], data2[2]);
        }

        @Override
        public void setV3c(Tuple3<Short> v) {
            short[] data2 = new short[]{(Short)((Tuple3)v)._0, (Short)((Tuple3)v)._1, (Short)((Tuple3)v)._2};
            this.mat.put(this.indices, data2);
        }

        @Override
        public Tuple4<Short> getV4c() {
            short[] data2 = new short[4];
            this.mat.get(this.indices, data2);
            return new Tuple4<Short>(data2[0], data2[1], data2[2], data2[3]);
        }

        @Override
        public void setV4c(Tuple4<Short> v) {
            short[] data2 = new short[]{(Short)((Tuple4)v)._0, (Short)((Tuple4)v)._1, (Short)((Tuple4)v)._2, (Short)((Tuple4)v)._3};
            this.mat.put(this.indices, data2);
        }
    }

    private static class AtableInteger
    extends AtableBase
    implements Atable<Integer> {
        public AtableInteger(Mat mat, int row, int col) {
            super(mat, row, col);
        }

        public AtableInteger(Mat mat, int[] indices) {
            super(mat, indices);
        }

        @Override
        public Integer getV() {
            int[] data2 = new int[1];
            this.mat.get(this.indices, data2);
            return data2[0];
        }

        @Override
        public void setV(Integer v) {
            int[] data2 = new int[]{v};
            this.mat.put(this.indices, data2);
        }

        @Override
        public Tuple2<Integer> getV2c() {
            int[] data2 = new int[2];
            this.mat.get(this.indices, data2);
            return new Tuple2<Integer>(data2[0], data2[1]);
        }

        @Override
        public void setV2c(Tuple2<Integer> v) {
            int[] data2 = new int[]{(Integer)((Tuple2)v)._0, (Integer)((Tuple2)v)._1};
            this.mat.put(this.indices, data2);
        }

        @Override
        public Tuple3<Integer> getV3c() {
            int[] data2 = new int[3];
            this.mat.get(this.indices, data2);
            return new Tuple3<Integer>(data2[0], data2[1], data2[2]);
        }

        @Override
        public void setV3c(Tuple3<Integer> v) {
            int[] data2 = new int[]{(Integer)((Tuple3)v)._0, (Integer)((Tuple3)v)._1, (Integer)((Tuple3)v)._2};
            this.mat.put(this.indices, data2);
        }

        @Override
        public Tuple4<Integer> getV4c() {
            int[] data2 = new int[4];
            this.mat.get(this.indices, data2);
            return new Tuple4<Integer>(data2[0], data2[1], data2[2], data2[3]);
        }

        @Override
        public void setV4c(Tuple4<Integer> v) {
            int[] data2 = new int[]{(Integer)((Tuple4)v)._0, (Integer)((Tuple4)v)._1, (Integer)((Tuple4)v)._2, (Integer)((Tuple4)v)._3};
            this.mat.put(this.indices, data2);
        }
    }

    private static class AtableFloat
    extends AtableBase
    implements Atable<Float> {
        public AtableFloat(Mat mat, int row, int col) {
            super(mat, row, col);
        }

        public AtableFloat(Mat mat, int[] indices) {
            super(mat, indices);
        }

        @Override
        public Float getV() {
            float[] data2 = new float[1];
            this.mat.get(this.indices, data2);
            return Float.valueOf(data2[0]);
        }

        @Override
        public void setV(Float v) {
            float[] data2 = new float[]{v.floatValue()};
            this.mat.put(this.indices, data2);
        }

        @Override
        public Tuple2<Float> getV2c() {
            float[] data2 = new float[2];
            this.mat.get(this.indices, data2);
            return new Tuple2<Float>(Float.valueOf(data2[0]), Float.valueOf(data2[1]));
        }

        @Override
        public void setV2c(Tuple2<Float> v) {
            float[] data2 = new float[]{((Float)((Tuple2)v)._0).floatValue(), ((Float)((Tuple2)v)._1).floatValue()};
            this.mat.put(this.indices, data2);
        }

        @Override
        public Tuple3<Float> getV3c() {
            float[] data2 = new float[3];
            this.mat.get(this.indices, data2);
            return new Tuple3<Float>(Float.valueOf(data2[0]), Float.valueOf(data2[1]), Float.valueOf(data2[2]));
        }

        @Override
        public void setV3c(Tuple3<Float> v) {
            float[] data2 = new float[]{((Float)((Tuple3)v)._0).floatValue(), ((Float)((Tuple3)v)._1).floatValue(), ((Float)((Tuple3)v)._2).floatValue()};
            this.mat.put(this.indices, data2);
        }

        @Override
        public Tuple4<Float> getV4c() {
            float[] data2 = new float[4];
            this.mat.get(this.indices, data2);
            return new Tuple4<Float>(Float.valueOf(data2[0]), Float.valueOf(data2[1]), Float.valueOf(data2[2]), Float.valueOf(data2[3]));
        }

        @Override
        public void setV4c(Tuple4<Float> v) {
            double[] data2 = new double[]{((Float)((Tuple4)v)._0).floatValue(), ((Float)((Tuple4)v)._1).floatValue(), ((Float)((Tuple4)v)._2).floatValue(), ((Float)((Tuple4)v)._3).floatValue()};
            this.mat.put(this.indices, data2);
        }
    }

    private static class AtableDouble
    extends AtableBase
    implements Atable<Double> {
        public AtableDouble(Mat mat, int row, int col) {
            super(mat, row, col);
        }

        public AtableDouble(Mat mat, int[] indices) {
            super(mat, indices);
        }

        @Override
        public Double getV() {
            double[] data2 = new double[1];
            this.mat.get(this.indices, data2);
            return data2[0];
        }

        @Override
        public void setV(Double v) {
            double[] data2 = new double[]{v};
            this.mat.put(this.indices, data2);
        }

        @Override
        public Tuple2<Double> getV2c() {
            double[] data2 = new double[2];
            this.mat.get(this.indices, data2);
            return new Tuple2<Double>(data2[0], data2[1]);
        }

        @Override
        public void setV2c(Tuple2<Double> v) {
            double[] data2 = new double[]{(Double)((Tuple2)v)._0, (Double)((Tuple2)v)._1};
            this.mat.put(this.indices, data2);
        }

        @Override
        public Tuple3<Double> getV3c() {
            double[] data2 = new double[3];
            this.mat.get(this.indices, data2);
            return new Tuple3<Double>(data2[0], data2[1], data2[2]);
        }

        @Override
        public void setV3c(Tuple3<Double> v) {
            double[] data2 = new double[]{(Double)((Tuple3)v)._0, (Double)((Tuple3)v)._1, (Double)((Tuple3)v)._2};
            this.mat.put(this.indices, data2);
        }

        @Override
        public Tuple4<Double> getV4c() {
            double[] data2 = new double[4];
            this.mat.get(this.indices, data2);
            return new Tuple4<Double>(data2[0], data2[1], data2[2], data2[3]);
        }

        @Override
        public void setV4c(Tuple4<Double> v) {
            double[] data2 = new double[]{(Double)((Tuple4)v)._0, (Double)((Tuple4)v)._1, (Double)((Tuple4)v)._2, (Double)((Tuple4)v)._3};
            this.mat.put(this.indices, data2);
        }
    }

    private static class AtableByte
    extends AtableBase
    implements Atable<Byte> {
        public AtableByte(Mat mat, int row, int col) {
            super(mat, row, col);
        }

        public AtableByte(Mat mat, int[] indices) {
            super(mat, indices);
        }

        @Override
        public Byte getV() {
            byte[] data2 = new byte[1];
            this.mat.get(this.indices, data2);
            return data2[0];
        }

        @Override
        public void setV(Byte v) {
            byte[] data2 = new byte[]{v};
            this.mat.put(this.indices, data2);
        }

        @Override
        public Tuple2<Byte> getV2c() {
            byte[] data2 = new byte[2];
            this.mat.get(this.indices, data2);
            return new Tuple2<Byte>(data2[0], data2[1]);
        }

        @Override
        public void setV2c(Tuple2<Byte> v) {
            byte[] data2 = new byte[]{(Byte)((Tuple2)v)._0, (Byte)((Tuple2)v)._1};
            this.mat.put(this.indices, data2);
        }

        @Override
        public Tuple3<Byte> getV3c() {
            byte[] data2 = new byte[3];
            this.mat.get(this.indices, data2);
            return new Tuple3<Byte>(data2[0], data2[1], data2[2]);
        }

        @Override
        public void setV3c(Tuple3<Byte> v) {
            byte[] data2 = new byte[]{(Byte)((Tuple3)v)._0, (Byte)((Tuple3)v)._1, (Byte)((Tuple3)v)._2};
            this.mat.put(this.indices, data2);
        }

        @Override
        public Tuple4<Byte> getV4c() {
            byte[] data2 = new byte[4];
            this.mat.get(this.indices, data2);
            return new Tuple4<Byte>(data2[0], data2[1], data2[2], data2[3]);
        }

        @Override
        public void setV4c(Tuple4<Byte> v) {
            byte[] data2 = new byte[]{(Byte)((Tuple4)v)._0, (Byte)((Tuple4)v)._1, (Byte)((Tuple4)v)._2, (Byte)((Tuple4)v)._3};
            this.mat.put(this.indices, data2);
        }
    }

    private static class AtableBase {
        protected final Mat mat;
        protected final int[] indices;

        protected AtableBase(Mat mat, int row, int col) {
            this.mat = mat;
            this.indices = new int[2];
            this.indices[0] = row;
            this.indices[1] = col;
        }

        protected AtableBase(Mat mat, int[] indices) {
            this.mat = mat;
            this.indices = indices;
        }
    }

    public static interface Atable<T> {
        public T getV();

        public void setV(T var1);

        public Tuple2<T> getV2c();

        public void setV2c(Tuple2<T> var1);

        public Tuple3<T> getV3c();

        public void setV3c(Tuple3<T> var1);

        public Tuple4<T> getV4c();

        public void setV4c(Tuple4<T> var1);
    }

    public static class Tuple4<T> {
        private final T _0;
        private final T _1;
        private final T _2;
        private final T _3;

        public Tuple4(T _0, T _1, T _2, T _3) {
            this._0 = _0;
            this._1 = _1;
            this._2 = _2;
            this._3 = _3;
        }

        public T get_0() {
            return this._0;
        }

        public T get_1() {
            return this._1;
        }

        public T get_2() {
            return this._2;
        }

        public T get_3() {
            return this._3;
        }
    }

    public static class Tuple3<T> {
        private final T _0;
        private final T _1;
        private final T _2;

        public Tuple3(T _0, T _1, T _2) {
            this._0 = _0;
            this._1 = _1;
            this._2 = _2;
        }

        public T get_0() {
            return this._0;
        }

        public T get_1() {
            return this._1;
        }

        public T get_2() {
            return this._2;
        }
    }

    public static class Tuple2<T> {
        private final T _0;
        private final T _1;

        public Tuple2(T _0, T _1) {
            this._0 = _0;
            this._1 = _1;
        }

        public T get_0() {
            return this._0;
        }

        public T get_1() {
            return this._1;
        }
    }
}

