/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.face;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Scalar;
import org.opencv.face.Facemark;
import org.opencv.utils.Converters;

public class Face {
    public static Facemark createFacemarkAAM() {
        return Facemark.__fromPtr__(Face.createFacemarkAAM_0());
    }

    public static Facemark createFacemarkLBF() {
        return Facemark.__fromPtr__(Face.createFacemarkLBF_0());
    }

    public static Facemark createFacemarkKazemi() {
        return Facemark.__fromPtr__(Face.createFacemarkKazemi_0());
    }

    public static boolean getFacesHAAR(Mat image, Mat faces, String face_cascade_name) {
        return Face.getFacesHAAR_0(image.nativeObj, faces.nativeObj, face_cascade_name);
    }

    public static boolean loadDatasetList(String imageList, String annotationList, List<String> images, List<String> annotations2) {
        return Face.loadDatasetList_0(imageList, annotationList, images, annotations2);
    }

    public static boolean loadTrainingData(String filename, List<String> images, Mat facePoints, char delim, float offset2) {
        return Face.loadTrainingData_0(filename, images, facePoints.nativeObj, delim, offset2);
    }

    public static boolean loadTrainingData(String filename, List<String> images, Mat facePoints, char delim) {
        return Face.loadTrainingData_1(filename, images, facePoints.nativeObj, delim);
    }

    public static boolean loadTrainingData(String filename, List<String> images, Mat facePoints) {
        return Face.loadTrainingData_2(filename, images, facePoints.nativeObj);
    }

    public static boolean loadTrainingData(String imageList, String groundTruth, List<String> images, Mat facePoints, float offset2) {
        return Face.loadTrainingData_3(imageList, groundTruth, images, facePoints.nativeObj, offset2);
    }

    public static boolean loadTrainingData(String imageList, String groundTruth, List<String> images, Mat facePoints) {
        return Face.loadTrainingData_4(imageList, groundTruth, images, facePoints.nativeObj);
    }

    public static boolean loadTrainingData(List<String> filename, List<MatOfPoint2f> trainlandmarks, List<String> trainimages) {
        ArrayList<Mat> trainlandmarks_tmplm = new ArrayList<Mat>(trainlandmarks != null ? trainlandmarks.size() : 0);
        Mat trainlandmarks_mat = Converters.vector_vector_Point2f_to_Mat(trainlandmarks, trainlandmarks_tmplm);
        return Face.loadTrainingData_5(filename, trainlandmarks_mat.nativeObj, trainimages);
    }

    public static boolean loadFacePoints(String filename, Mat points, float offset2) {
        return Face.loadFacePoints_0(filename, points.nativeObj, offset2);
    }

    public static boolean loadFacePoints(String filename, Mat points) {
        return Face.loadFacePoints_1(filename, points.nativeObj);
    }

    public static void drawFacemarks(Mat image, Mat points, Scalar color2) {
        Face.drawFacemarks_0(image.nativeObj, points.nativeObj, color2.val[0], color2.val[1], color2.val[2], color2.val[3]);
    }

    public static void drawFacemarks(Mat image, Mat points) {
        Face.drawFacemarks_1(image.nativeObj, points.nativeObj);
    }

    private static native long createFacemarkAAM_0();

    private static native long createFacemarkLBF_0();

    private static native long createFacemarkKazemi_0();

    private static native boolean getFacesHAAR_0(long var0, long var2, String var4);

    private static native boolean loadDatasetList_0(String var0, String var1, List<String> var2, List<String> var3);

    private static native boolean loadTrainingData_0(String var0, List<String> var1, long var2, char var4, float var5);

    private static native boolean loadTrainingData_1(String var0, List<String> var1, long var2, char var4);

    private static native boolean loadTrainingData_2(String var0, List<String> var1, long var2);

    private static native boolean loadTrainingData_3(String var0, String var1, List<String> var2, long var3, float var5);

    private static native boolean loadTrainingData_4(String var0, String var1, List<String> var2, long var3);

    private static native boolean loadTrainingData_5(List<String> var0, long var1, List<String> var3);

    private static native boolean loadFacePoints_0(String var0, long var1, float var3);

    private static native boolean loadFacePoints_1(String var0, long var1);

    private static native void drawFacemarks_0(long var0, long var2, double var4, double var6, double var8, double var10);

    private static native void drawFacemarks_1(long var0, long var2);
}

