/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.objdetect;

import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.Size;

public class FaceDetectorYN {
    protected final long nativeObj;

    protected FaceDetectorYN(long addr) {
        this.nativeObj = addr;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static FaceDetectorYN __fromPtr__(long addr) {
        return new FaceDetectorYN(addr);
    }

    public void setInputSize(Size input_size) {
        FaceDetectorYN.setInputSize_0(this.nativeObj, input_size.width, input_size.height);
    }

    public Size getInputSize() {
        return new Size(FaceDetectorYN.getInputSize_0(this.nativeObj));
    }

    public void setScoreThreshold(float score_threshold) {
        FaceDetectorYN.setScoreThreshold_0(this.nativeObj, score_threshold);
    }

    public float getScoreThreshold() {
        return FaceDetectorYN.getScoreThreshold_0(this.nativeObj);
    }

    public void setNMSThreshold(float nms_threshold) {
        FaceDetectorYN.setNMSThreshold_0(this.nativeObj, nms_threshold);
    }

    public float getNMSThreshold() {
        return FaceDetectorYN.getNMSThreshold_0(this.nativeObj);
    }

    public void setTopK(int top_k) {
        FaceDetectorYN.setTopK_0(this.nativeObj, top_k);
    }

    public int getTopK() {
        return FaceDetectorYN.getTopK_0(this.nativeObj);
    }

    public int detect(Mat image, Mat faces) {
        return FaceDetectorYN.detect_0(this.nativeObj, image.nativeObj, faces.nativeObj);
    }

    public static FaceDetectorYN create(String model, String config2, Size input_size, float score_threshold, float nms_threshold, int top_k, int backend_id, int target_id) {
        return FaceDetectorYN.__fromPtr__(FaceDetectorYN.create_0(model, config2, input_size.width, input_size.height, score_threshold, nms_threshold, top_k, backend_id, target_id));
    }

    public static FaceDetectorYN create(String model, String config2, Size input_size, float score_threshold, float nms_threshold, int top_k, int backend_id) {
        return FaceDetectorYN.__fromPtr__(FaceDetectorYN.create_1(model, config2, input_size.width, input_size.height, score_threshold, nms_threshold, top_k, backend_id));
    }

    public static FaceDetectorYN create(String model, String config2, Size input_size, float score_threshold, float nms_threshold, int top_k) {
        return FaceDetectorYN.__fromPtr__(FaceDetectorYN.create_2(model, config2, input_size.width, input_size.height, score_threshold, nms_threshold, top_k));
    }

    public static FaceDetectorYN create(String model, String config2, Size input_size, float score_threshold, float nms_threshold) {
        return FaceDetectorYN.__fromPtr__(FaceDetectorYN.create_3(model, config2, input_size.width, input_size.height, score_threshold, nms_threshold));
    }

    public static FaceDetectorYN create(String model, String config2, Size input_size, float score_threshold) {
        return FaceDetectorYN.__fromPtr__(FaceDetectorYN.create_4(model, config2, input_size.width, input_size.height, score_threshold));
    }

    public static FaceDetectorYN create(String model, String config2, Size input_size) {
        return FaceDetectorYN.__fromPtr__(FaceDetectorYN.create_5(model, config2, input_size.width, input_size.height));
    }

    public static FaceDetectorYN create(String framework, MatOfByte bufferModel, MatOfByte bufferConfig, Size input_size, float score_threshold, float nms_threshold, int top_k, int backend_id, int target_id) {
        MatOfByte bufferModel_mat = bufferModel;
        MatOfByte bufferConfig_mat = bufferConfig;
        return FaceDetectorYN.__fromPtr__(FaceDetectorYN.create_6(framework, bufferModel_mat.nativeObj, bufferConfig_mat.nativeObj, input_size.width, input_size.height, score_threshold, nms_threshold, top_k, backend_id, target_id));
    }

    public static FaceDetectorYN create(String framework, MatOfByte bufferModel, MatOfByte bufferConfig, Size input_size, float score_threshold, float nms_threshold, int top_k, int backend_id) {
        MatOfByte bufferModel_mat = bufferModel;
        MatOfByte bufferConfig_mat = bufferConfig;
        return FaceDetectorYN.__fromPtr__(FaceDetectorYN.create_7(framework, bufferModel_mat.nativeObj, bufferConfig_mat.nativeObj, input_size.width, input_size.height, score_threshold, nms_threshold, top_k, backend_id));
    }

    public static FaceDetectorYN create(String framework, MatOfByte bufferModel, MatOfByte bufferConfig, Size input_size, float score_threshold, float nms_threshold, int top_k) {
        MatOfByte bufferModel_mat = bufferModel;
        MatOfByte bufferConfig_mat = bufferConfig;
        return FaceDetectorYN.__fromPtr__(FaceDetectorYN.create_8(framework, bufferModel_mat.nativeObj, bufferConfig_mat.nativeObj, input_size.width, input_size.height, score_threshold, nms_threshold, top_k));
    }

    public static FaceDetectorYN create(String framework, MatOfByte bufferModel, MatOfByte bufferConfig, Size input_size, float score_threshold, float nms_threshold) {
        MatOfByte bufferModel_mat = bufferModel;
        MatOfByte bufferConfig_mat = bufferConfig;
        return FaceDetectorYN.__fromPtr__(FaceDetectorYN.create_9(framework, bufferModel_mat.nativeObj, bufferConfig_mat.nativeObj, input_size.width, input_size.height, score_threshold, nms_threshold));
    }

    public static FaceDetectorYN create(String framework, MatOfByte bufferModel, MatOfByte bufferConfig, Size input_size, float score_threshold) {
        MatOfByte bufferModel_mat = bufferModel;
        MatOfByte bufferConfig_mat = bufferConfig;
        return FaceDetectorYN.__fromPtr__(FaceDetectorYN.create_10(framework, bufferModel_mat.nativeObj, bufferConfig_mat.nativeObj, input_size.width, input_size.height, score_threshold));
    }

    public static FaceDetectorYN create(String framework, MatOfByte bufferModel, MatOfByte bufferConfig, Size input_size) {
        MatOfByte bufferModel_mat = bufferModel;
        MatOfByte bufferConfig_mat = bufferConfig;
        return FaceDetectorYN.__fromPtr__(FaceDetectorYN.create_11(framework, bufferModel_mat.nativeObj, bufferConfig_mat.nativeObj, input_size.width, input_size.height));
    }

    protected void finalize() throws Throwable {
        FaceDetectorYN.delete(this.nativeObj);
    }

    private static native void setInputSize_0(long var0, double var2, double var4);

    private static native double[] getInputSize_0(long var0);

    private static native void setScoreThreshold_0(long var0, float var2);

    private static native float getScoreThreshold_0(long var0);

    private static native void setNMSThreshold_0(long var0, float var2);

    private static native float getNMSThreshold_0(long var0);

    private static native void setTopK_0(long var0, int var2);

    private static native int getTopK_0(long var0);

    private static native int detect_0(long var0, long var2, long var4);

    private static native long create_0(String var0, String var1, double var2, double var4, float var6, float var7, int var8, int var9, int var10);

    private static native long create_1(String var0, String var1, double var2, double var4, float var6, float var7, int var8, int var9);

    private static native long create_2(String var0, String var1, double var2, double var4, float var6, float var7, int var8);

    private static native long create_3(String var0, String var1, double var2, double var4, float var6, float var7);

    private static native long create_4(String var0, String var1, double var2, double var4, float var6);

    private static native long create_5(String var0, String var1, double var2, double var4);

    private static native long create_6(String var0, long var1, long var3, double var5, double var7, float var9, float var10, int var11, int var12, int var13);

    private static native long create_7(String var0, long var1, long var3, double var5, double var7, float var9, float var10, int var11, int var12);

    private static native long create_8(String var0, long var1, long var3, double var5, double var7, float var9, float var10, int var11);

    private static native long create_9(String var0, long var1, long var3, double var5, double var7, float var9, float var10);

    private static native long create_10(String var0, long var1, long var3, double var5, double var7, float var9);

    private static native long create_11(String var0, long var1, long var3, double var5, double var7);

    private static native void delete(long var0);
}

