/*
 * Decompiled with CFR 0.152.
 */
package ui2;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.internal.StabilityInferred;
import arhitecture.Chapter;
import arhitecture.Character;
import arhitecture.InteractiveOption;
import arhitecture.Place;
import arhitecture.Scene;
import arhitecture.SoundLayer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ui2.DialogType;
import ui2.edit_dialogs.ImageGenerationConfig;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\u000eJ\u0006\u0010\"\u001a\u00020\u000eJ\u0012\u0010#\u001a\u00020\u000e2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010 J\u000e\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020\u000e2\u0006\u0010/\u001a\u000200J\u000e\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u00020\u000eJ\u0010\u00106\u001a\u00020\u000e2\b\u00107\u001a\u0004\u0018\u000108J\u0006\u00109\u001a\u00020\u000eJ\u0006\u0010:\u001a\u00020\u000eJ\u0006\u0010;\u001a\u00020\u000eR+\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR/\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0004\u001a\u0004\u0018\u00010\u000f8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R/\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0004\u001a\u0004\u0018\u00010\u00168F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006<"}, d2={"Lui2/MovieStateManager;", "", "<init>", "()V", "<set-?>", "", "refreshTrigger", "getRefreshTrigger", "()I", "setRefreshTrigger", "(I)V", "refreshTrigger$delegate", "Landroidx/compose/runtime/MutableState;", "triggerRefresh", "", "Lui2/DialogType;", "currentDialog", "getCurrentDialog", "()Lui2/DialogType;", "setCurrentDialog", "(Lui2/DialogType;)V", "currentDialog$delegate", "", "errorMessage", "getErrorMessage", "()Ljava/lang/String;", "setErrorMessage", "(Ljava/lang/String;)V", "errorMessage$delegate", "openImageViewDialog", "imageFile", "imageGenerationConfig", "Lui2/edit_dialogs/ImageGenerationConfig;", "openAboutDialog", "openSettingsDialog", "openImageGenerationDialog", "initialConfig", "openCharacterDialog", "character", "Larhitecture/Character;", "openPlaceDialog", "place", "Larhitecture/Place;", "openSceneDialog", "scene", "Larhitecture/Scene;", "openChapterDialog", "chapter", "Larhitecture/Chapter;", "openInteractiveOptionsDialog", "openInteractiveOptionDialog", "option", "Larhitecture/InteractiveOption;", "openVideoSelectionDialog", "openSoundEffectDialog", "soundLayer", "Larhitecture/SoundLayer;", "openVoiceGenerationDialog", "closeDialog", "saveMovie", "app.red-mycelium.com"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nMovieStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MovieStateManager.kt\nui2/MovieStateManager\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,89:1\n81#2:90\n107#2,2:91\n81#2:93\n107#2,2:94\n81#2:96\n107#2,2:97\n*S KotlinDebug\n*F\n+ 1 MovieStateManager.kt\nui2/MovieStateManager\n*L\n13#1:90\n13#1:91,2\n20#1:93\n20#1:94,2\n22#1:96\n22#1:97,2\n*E\n"})
public final class MovieStateManager {
    @NotNull
    private final MutableState refreshTrigger$delegate = SnapshotStateKt.mutableStateOf$default(0, null, 2, null);
    @NotNull
    private final MutableState currentDialog$delegate = SnapshotStateKt.mutableStateOf$default(null, null, 2, null);
    @NotNull
    private final MutableState errorMessage$delegate = SnapshotStateKt.mutableStateOf$default(null, null, 2, null);
    public static final int $stable;

    /*
     * WARNING - void declaration
     */
    public final int getRefreshTrigger() {
        void $this$getValue$iv;
        State state2 = this.refreshTrigger$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setRefreshTrigger(int n) {
        void $this$setValue$iv;
        MutableState mutableState = this.refreshTrigger$delegate;
        Object var3_3 = null;
        Integer value$iv = n;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(value$iv);
    }

    public final void triggerRefresh() {
        int n = this.getRefreshTrigger();
        this.setRefreshTrigger(n + 1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final DialogType getCurrentDialog() {
        void $this$getValue$iv;
        State state2 = this.currentDialog$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (DialogType)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setCurrentDialog(DialogType dialogType) {
        void $this$setValue$iv;
        MutableState mutableState = this.currentDialog$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(dialogType);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getErrorMessage() {
        void $this$getValue$iv;
        State state2 = this.errorMessage$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (String)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setErrorMessage(@Nullable String string) {
        void $this$setValue$iv;
        MutableState mutableState = this.errorMessage$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(string);
    }

    public final void openImageViewDialog(@NotNull String imageFile, @NotNull ImageGenerationConfig imageGenerationConfig) {
        Intrinsics.checkNotNullParameter(imageFile, "imageFile");
        Intrinsics.checkNotNullParameter(imageGenerationConfig, "imageGenerationConfig");
        this.setCurrentDialog(new DialogType.ImageViewDialog(imageFile, imageGenerationConfig));
    }

    public final void openAboutDialog() {
        this.setCurrentDialog(DialogType.AboutDialog.INSTANCE);
    }

    public final void openSettingsDialog() {
        this.setCurrentDialog(DialogType.SettingsDialog.INSTANCE);
    }

    public final void openImageGenerationDialog(@Nullable ImageGenerationConfig initialConfig) {
        this.setCurrentDialog(new DialogType.ImageGeneration(initialConfig));
    }

    public static /* synthetic */ void openImageGenerationDialog$default(MovieStateManager movieStateManager, ImageGenerationConfig imageGenerationConfig, int n, Object object) {
        if ((n & 1) != 0) {
            imageGenerationConfig = null;
        }
        movieStateManager.openImageGenerationDialog(imageGenerationConfig);
    }

    public final void openCharacterDialog(@NotNull Character character) {
        Intrinsics.checkNotNullParameter(character, "character");
        this.setCurrentDialog(new DialogType.CharacterEdit(character));
    }

    public final void openPlaceDialog(@NotNull Place place2) {
        Intrinsics.checkNotNullParameter(place2, "place");
        this.setCurrentDialog(new DialogType.PlaceEdit(place2));
    }

    public final void openSceneDialog(@NotNull Scene scene2) {
        Intrinsics.checkNotNullParameter(scene2, "scene");
        this.setCurrentDialog(new DialogType.SceneEdit(scene2));
    }

    public final void openChapterDialog(@NotNull Chapter chapter) {
        Intrinsics.checkNotNullParameter(chapter, "chapter");
        this.setCurrentDialog(new DialogType.ChapterEdit(chapter));
    }

    public final void openInteractiveOptionsDialog(@NotNull Chapter chapter) {
        Intrinsics.checkNotNullParameter(chapter, "chapter");
        this.setCurrentDialog(new DialogType.InteractiveOptionsEdit(chapter));
    }

    public final void openInteractiveOptionDialog(@NotNull InteractiveOption option) {
        Intrinsics.checkNotNullParameter(option, "option");
        this.setCurrentDialog(new DialogType.InteractiveOptionEdit(option));
    }

    public final void openVideoSelectionDialog() {
        this.setCurrentDialog(DialogType.VideoSelectionDialog.INSTANCE);
    }

    public final void openSoundEffectDialog(@Nullable SoundLayer soundLayer) {
        this.setCurrentDialog(new DialogType.SoundEffect(soundLayer));
    }

    public final void openVoiceGenerationDialog() {
        this.setCurrentDialog(DialogType.VoiceGenerationDialog.INSTANCE);
    }

    public final void closeDialog() {
        this.setCurrentDialog(null);
    }

    public final void saveMovie() {
        ProjectConfig.INSTANCE.getMovie().save();
    }
}

