/*
 * Decompiled with CFR 0.152.
 */
package util;

import androidx.compose.runtime.internal.StabilityInferred;
import arhitecture.FullScenario;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\b\u001a\u00020\t*\u00020\tJ\n\u0010\n\u001a\u00020\t*\u00020\tJ\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0001J\u001a\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\t2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lutil/XmlJsonConverter;", "", "<init>", "()V", "xmlMapper", "Lcom/fasterxml/jackson/dataformat/xml/XmlMapper;", "jsonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "cutJsonObject", "", "cutJsonArray", "scenarioToXml", "scenario", "Larhitecture/FullScenario;", "xmlToScenario", "xmlString", "anyToXml", "obj", "xmlToAny", "clazz", "Ljava/lang/Class;", "xmlToGsonJsonObject", "Lcom/google/gson/JsonObject;", "app.red-mycelium.com"})
@StabilityInferred(parameters=0)
public final class XmlJsonConverter {
    @NotNull
    public static final XmlJsonConverter INSTANCE = new XmlJsonConverter();
    @NotNull
    private static final XmlMapper xmlMapper;
    @NotNull
    private static final ObjectMapper jsonMapper;
    public static final int $stable;

    private XmlJsonConverter() {
    }

    @NotNull
    public final String cutJsonObject(@NotNull String $this$cutJsonObject) {
        Intrinsics.checkNotNullParameter($this$cutJsonObject, "<this>");
        return "{" + StringsKt.substringBeforeLast$default(StringsKt.substringAfter$default($this$cutJsonObject, "{", null, 2, null), "}", null, 2, null) + "}";
    }

    @NotNull
    public final String cutJsonArray(@NotNull String $this$cutJsonArray) {
        Intrinsics.checkNotNullParameter($this$cutJsonArray, "<this>");
        return "[" + StringsKt.substringBeforeLast$default(StringsKt.substringAfter$default($this$cutJsonArray, "[", null, 2, null), "]", null, 2, null) + "]";
    }

    @NotNull
    public final String scenarioToXml(@NotNull FullScenario scenario2) {
        Intrinsics.checkNotNullParameter(scenario2, "scenario");
        String string = xmlMapper.writeValueAsString(scenario2);
        Intrinsics.checkNotNullExpressionValue(string, "writeValueAsString(...)");
        return string;
    }

    @NotNull
    public final FullScenario xmlToScenario(@NotNull String xmlString) {
        Intrinsics.checkNotNullParameter(xmlString, "xmlString");
        FullScenario fullScenario = xmlMapper.readValue(xmlString, FullScenario.class);
        Intrinsics.checkNotNullExpressionValue(fullScenario, "readValue(...)");
        return fullScenario;
    }

    @NotNull
    public final String anyToXml(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        String string = xmlMapper.writeValueAsString(obj);
        Intrinsics.checkNotNullExpressionValue(string, "writeValueAsString(...)");
        return string;
    }

    @NotNull
    public final Object xmlToAny(@NotNull String xmlString, @NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(xmlString, "xmlString");
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Object obj = xmlMapper.readValue(xmlString, clazz);
        Intrinsics.checkNotNullExpressionValue(obj, "readValue(...)");
        return obj;
    }

    @NotNull
    public final JsonObject xmlToGsonJsonObject(@NotNull String xmlString) {
        Intrinsics.checkNotNullParameter(xmlString, "xmlString");
        JsonNode jsonNode = xmlMapper.readTree(xmlString);
        String jsonString = jsonMapper.writeValueAsString(jsonNode);
        JsonObject jsonObject = JsonParser.parseString(jsonString).getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue(jsonObject, "getAsJsonObject(...)");
        return jsonObject;
    }

    static {
        ObjectMapper objectMapper = new XmlMapper();
        XmlMapper $this$xmlMapper_u24lambda_u240 = objectMapper;
        boolean bl = false;
        $this$xmlMapper_u24lambda_u240.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        xmlMapper = objectMapper;
        ObjectMapper $this$jsonMapper_u24lambda_u241 = objectMapper = new ObjectMapper();
        boolean bl2 = false;
        $this$jsonMapper_u24lambda_u241.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        $this$jsonMapper_u24lambda_u241.enable(SerializationFeature.INDENT_OUTPUT);
        jsonMapper = objectMapper;
        $stable = 8;
    }
}

