/*
 * Decompiled with CFR 0.152.
 */
package video;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\t\u0010#\u001a\u00020\u000bH\u00c6\u0003JE\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\u0005H\u00d6\u0001J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000fR\u0011\u0010\u001c\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000f\u00a8\u0006*"}, d2={"Lvideo/VideoInfo;", "", "filePath", "", "durationMs", "", "width", "height", "frameRate", "", "fileSize", "", "<init>", "(Ljava/lang/String;IIIDJ)V", "getFilePath", "()Ljava/lang/String;", "getDurationMs", "()I", "getWidth", "getHeight", "getFrameRate", "()D", "getFileSize", "()J", "formattedDuration", "getFormattedDuration", "formattedFileSize", "getFormattedFileSize", "resolution", "getResolution", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "app.red-mycelium.com"})
@StabilityInferred(parameters=1)
public final class VideoInfo {
    @NotNull
    private final String filePath;
    private final int durationMs;
    private final int width;
    private final int height;
    private final double frameRate;
    private final long fileSize;
    public static final int $stable;

    public VideoInfo(@NotNull String filePath, int durationMs, int width2, int height2, double frameRate, long fileSize) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        this.filePath = filePath;
        this.durationMs = durationMs;
        this.width = width2;
        this.height = height2;
        this.frameRate = frameRate;
        this.fileSize = fileSize;
    }

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    public final int getDurationMs() {
        return this.durationMs;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final double getFrameRate() {
        return this.frameRate;
    }

    public final long getFileSize() {
        return this.fileSize;
    }

    @NotNull
    public final String getFormattedDuration() {
        int minutes = this.durationMs / 60000;
        int seconds = this.durationMs % 60000 / 1000;
        String string = "%02d:%02d";
        Object[] objectArray = new Object[]{minutes, seconds};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @NotNull
    public final String getFormattedFileSize() {
        return this.fileSize < 1024L ? this.fileSize + " B" : (this.fileSize < 0x100000L ? this.fileSize / (long)1024 + " KB" : (this.fileSize < 0x40000000L ? this.fileSize / (long)0x100000 + " MB" : this.fileSize / (long)0x40000000 + " GB"));
    }

    @NotNull
    public final String getResolution() {
        return this.width + "x" + this.height;
    }

    @NotNull
    public final String component1() {
        return this.filePath;
    }

    public final int component2() {
        return this.durationMs;
    }

    public final int component3() {
        return this.width;
    }

    public final int component4() {
        return this.height;
    }

    public final double component5() {
        return this.frameRate;
    }

    public final long component6() {
        return this.fileSize;
    }

    @NotNull
    public final VideoInfo copy(@NotNull String filePath, int durationMs, int width2, int height2, double frameRate, long fileSize) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        return new VideoInfo(filePath, durationMs, width2, height2, frameRate, fileSize);
    }

    public static /* synthetic */ VideoInfo copy$default(VideoInfo videoInfo, String string, int n, int n2, int n3, double d, long l, int n4, Object object) {
        if ((n4 & 1) != 0) {
            string = videoInfo.filePath;
        }
        if ((n4 & 2) != 0) {
            n = videoInfo.durationMs;
        }
        if ((n4 & 4) != 0) {
            n2 = videoInfo.width;
        }
        if ((n4 & 8) != 0) {
            n3 = videoInfo.height;
        }
        if ((n4 & 0x10) != 0) {
            d = videoInfo.frameRate;
        }
        if ((n4 & 0x20) != 0) {
            l = videoInfo.fileSize;
        }
        return videoInfo.copy(string, n, n2, n3, d, l);
    }

    @NotNull
    public String toString() {
        return "VideoInfo(filePath=" + this.filePath + ", durationMs=" + this.durationMs + ", width=" + this.width + ", height=" + this.height + ", frameRate=" + this.frameRate + ", fileSize=" + this.fileSize + ")";
    }

    public int hashCode() {
        int result2 = this.filePath.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.durationMs);
        result2 = result2 * 31 + Integer.hashCode(this.width);
        result2 = result2 * 31 + Integer.hashCode(this.height);
        result2 = result2 * 31 + Double.hashCode(this.frameRate);
        result2 = result2 * 31 + Long.hashCode(this.fileSize);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VideoInfo)) {
            return false;
        }
        VideoInfo videoInfo = (VideoInfo)other;
        if (!Intrinsics.areEqual(this.filePath, videoInfo.filePath)) {
            return false;
        }
        if (this.durationMs != videoInfo.durationMs) {
            return false;
        }
        if (this.width != videoInfo.width) {
            return false;
        }
        if (this.height != videoInfo.height) {
            return false;
        }
        if (Double.compare(this.frameRate, videoInfo.frameRate) != 0) {
            return false;
        }
        return this.fileSize == videoInfo.fileSize;
    }
}

