/*
 * Decompiled with CFR 0.152.
 */
package video;

import androidx.compose.runtime.internal.StabilityInferred;
import arhitecture.Scene;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.Java2DFrameConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import video.VideoInfo;
import video.VideoProcessor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u001e\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0007J&\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0019H\u0082@\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u001eH\u0082@\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010 \u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020!H\u0082@\u00a2\u0006\u0002\u0010\"J\u001e\u0010#\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020$H\u0082@\u00a2\u0006\u0002\u0010%J\u001e\u0010&\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020'H\u0082@\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020*H\u0002J2\u0010+\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u001e2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020.0-H\u0082@\u00a2\u0006\u0002\u0010/J<\u00100\u001a\u00020\t2\u0006\u00101\u001a\u0002022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u001e2\u0006\u00103\u001a\u0002042\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020.0-H\u0002J \u00105\u001a\u0002062\u0006\u00107\u001a\u0002062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00108\u001a\u00020.H\u0002J\u0010\u00109\u001a\u00020\r2\u0006\u0010:\u001a\u00020\rH\u0002J0\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u0002062\u0006\u0010>\u001a\u00020\r2\u0006\u0010?\u001a\u00020\r2\u0006\u0010:\u001a\u00020\r2\u0006\u00108\u001a\u00020.H\u0002J\u0018\u0010@\u001a\u00020<2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020.H\u0002J\u0010\u0010D\u001a\u00020B2\u0006\u0010A\u001a\u00020BH\u0002J\u0018\u0010E\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020FH\u0002J\u0018\u0010G\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020HH\u0002J<\u0010I\u001a\u00020<2\u0006\u0010J\u001a\u0002022\u0006\u0010K\u001a\u00020\r2\u0006\u0010L\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00100NH\u0082@\u00a2\u0006\u0002\u0010O\u00a8\u0006P"}, d2={"Lvideo/VideoProcessor;", "", "<init>", "()V", "getVideoInfo", "Lvideo/VideoInfo;", "videoFilePath", "", "extractLastFrame", "", "outputImagePath", "extractFrameAtTime", "timeMs", "", "applyEffect", "scene", "Larhitecture/Scene;", "metaData", "LMetaData;", "effect", "LEffect;", "(Larhitecture/Scene;LMetaData;LEffect;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyEffectToVideo", "videoMetaData", "LVideoMetaData;", "LVideoEffect;", "(LVideoMetaData;LVideoEffect;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyEffectToSound", "soundMetaData", "LSoundMetaData;", "LSoundEffect;", "(LSoundMetaData;LSoundEffect;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyCutEffectToVideo", "LVideoEffect$Cut;", "(LVideoMetaData;LVideoEffect$Cut;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applySoundCutEffect", "LSoundEffect$Cut;", "(LSoundMetaData;LSoundEffect$Cut;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applySoundMuteEffect", "LSoundEffect$SoundMute;", "(LSoundMetaData;LSoundEffect$SoundMute;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applySoundClearVoiceEffect", "LSoundEffect$SoundClearVoice;", "applySoundFadeEffect", "volumeFunction", "Lkotlin/Function1;", "", "(LSoundMetaData;LSoundEffect;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyVolumeEffectToAudioFile", "audioFile", "Ljava/io/File;", "currentTimeInEffect", "", "applyVolumeToAudioData", "", "audioBytes", "volumeFactor", "getBytesPerSample", "sampleFormat", "processSample", "", "bytes", "start", "bytesPerSample", "applyAlphaToImage", "image", "Ljava/awt/image/BufferedImage;", "alpha", "convertToBlackAndWhite", "applyFadeInToFrames", "LVideoEffect$FadeIn;", "applyFadeOutToFrames", "LVideoEffect$FadeOut;", "deleteFramesInRange", "framesDir", "startTimeMs", "endTimeMs", "allScenes", "", "(Ljava/io/File;IILarhitecture/Scene;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "app.red-mycelium.com"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nVideoProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoProcessor.kt\nvideo/VideoProcessor\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1353:1\n535#2:1354\n520#2,6:1355\n535#2:1371\n520#2,6:1372\n535#2:1380\n520#2,6:1381\n535#2:1392\n520#2,6:1393\n535#2:1407\n520#2,6:1408\n1053#3:1361\n1557#3:1362\n1628#3,3:1363\n1567#3:1366\n1598#3,4:1367\n1053#3:1389\n1053#3:1399\n1557#3:1400\n1628#3,3:1401\n1872#3,3:1404\n1053#3:1414\n1557#3:1415\n1628#3,3:1416\n1872#3,3:1419\n216#4,2:1378\n216#4,2:1387\n216#4,2:1390\n*S KotlinDebug\n*F\n+ 1 VideoProcessor.kt\nvideo/VideoProcessor\n*L\n267#1:1354\n267#1:1355,6\n299#1:1371\n299#1:1372,6\n308#1:1380\n308#1:1381,6\n1053#1:1392\n1053#1:1393,6\n1083#1:1407\n1083#1:1408,6\n270#1:1361\n270#1:1362\n270#1:1363,3\n273#1:1366\n273#1:1367,4\n316#1:1389\n1057#1:1399\n1057#1:1400\n1057#1:1401,3\n1060#1:1404,3\n1087#1:1414\n1087#1:1415\n1087#1:1416,3\n1090#1:1419,3\n300#1:1378,2\n309#1:1387,2\n354#1:1390,2\n*E\n"})
public final class VideoProcessor {
    @NotNull
    public static final VideoProcessor INSTANCE = new VideoProcessor();
    public static final int $stable;

    private VideoProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final VideoInfo getVideoInfo(@NotNull String videoFilePath) {
        Intrinsics.checkNotNullParameter(videoFilePath, "videoFilePath");
        File file = new File(videoFilePath);
        if (!file.exists()) {
            throw new IllegalArgumentException("Video file does not exist: " + videoFilePath);
        }
        Closeable closeable = new FFmpegFrameGrabber(file);
        Throwable throwable = null;
        try {
            FFmpegFrameGrabber grabber = (FFmpegFrameGrabber)closeable;
            boolean bl = false;
            grabber.start();
            int durationMs = (int)(grabber.getLengthInTime() / (long)1000);
            int width2 = grabber.getImageWidth();
            int height2 = grabber.getImageHeight();
            double frameRate = grabber.getFrameRate();
            grabber.stop();
            VideoInfo videoInfo = new VideoInfo(videoFilePath, durationMs, width2, height2, frameRate, file.length());
            return videoInfo;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean extractLastFrame(@NotNull String videoFilePath, @NotNull String outputImagePath) {
        Intrinsics.checkNotNullParameter(videoFilePath, "videoFilePath");
        Intrinsics.checkNotNullParameter(outputImagePath, "outputImagePath");
        File file = new File(videoFilePath);
        if (!file.exists()) {
            return false;
        }
        Closeable closeable = new FFmpegFrameGrabber(file);
        Throwable throwable = null;
        try {
            FFmpegFrameGrabber grabber = (FFmpegFrameGrabber)closeable;
            boolean bl = false;
            grabber.start();
            int totalFrames = grabber.getLengthInFrames();
            if (totalFrames <= 0) {
                grabber.stop();
                boolean bl2 = false;
                return bl2;
            }
            BufferedImage bufferedImage = null;
            Java2DFrameConverter converter = new Java2DFrameConverter();
            for (int frameStep = 1; frameStep < 5 && bufferedImage == null; ++frameStep) {
                grabber.setFrameNumber(totalFrames - frameStep);
                Frame frame2 = grabber.grabImage();
                bufferedImage = converter.convert(frame2);
            }
            grabber.stop();
            converter.close();
            boolean bl3 = bufferedImage != null ? ImageIO.write((RenderedImage)bufferedImage, "png", new File(outputImagePath)) : false;
            return bl3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean extractFrameAtTime(@NotNull String videoFilePath, int timeMs, @NotNull String outputImagePath) {
        Intrinsics.checkNotNullParameter(videoFilePath, "videoFilePath");
        Intrinsics.checkNotNullParameter(outputImagePath, "outputImagePath");
        File file = new File(videoFilePath);
        if (!file.exists()) {
            return false;
        }
        Closeable closeable = new FFmpegFrameGrabber(file);
        Throwable throwable = null;
        try {
            FFmpegFrameGrabber grabber = (FFmpegFrameGrabber)closeable;
            boolean bl = false;
            grabber.start();
            grabber.setTimestamp((long)timeMs * 1000L);
            Java2DFrameConverter converter = new Java2DFrameConverter();
            Frame frame2 = grabber.grabImage();
            BufferedImage bufferedImage = converter.convert(frame2);
            grabber.stop();
            converter.close();
            boolean bl2 = bufferedImage != null ? ImageIO.write((RenderedImage)bufferedImage, "png", new File(outputImagePath)) : false;
            return bl2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public final Object applyEffect(@NotNull Scene var1_1, @NotNull MetaData var2_2, @NotNull Effect var3_3, @NotNull Continuation<? super Boolean> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[SWITCH], 15[CASE]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final Object applyEffectToVideo(VideoMetaData videoMetaData, VideoEffect effect, Continuation<? super Boolean> $completion) {
        boolean bl;
        VideoEffect videoEffect = effect;
        if (videoEffect instanceof VideoEffect.Cut) {
            return this.applyCutEffectToVideo(videoMetaData, (VideoEffect.Cut)effect, $completion);
        }
        if (videoEffect instanceof VideoEffect.FadeIn) {
            bl = this.applyFadeInToFrames(videoMetaData, (VideoEffect.FadeIn)effect);
        } else if (videoEffect instanceof VideoEffect.FadeOut) {
            bl = this.applyFadeOutToFrames(videoMetaData, (VideoEffect.FadeOut)effect);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Boxing.boxBoolean(bl);
    }

    private final Object applyEffectToSound(SoundMetaData soundMetaData, SoundEffect effect, Continuation<? super Boolean> $completion) {
        SoundEffect soundEffect = effect;
        if (soundEffect instanceof SoundEffect.FadeIn) {
            return this.applySoundFadeEffect(soundMetaData, effect, VideoProcessor::applyEffectToSound$lambda$3, $completion);
        }
        if (soundEffect instanceof SoundEffect.FadeOut) {
            return this.applySoundFadeEffect(soundMetaData, effect, VideoProcessor::applyEffectToSound$lambda$4, $completion);
        }
        if (soundEffect instanceof SoundEffect.Cut) {
            return this.applySoundCutEffect(soundMetaData, (SoundEffect.Cut)effect, $completion);
        }
        if (soundEffect instanceof SoundEffect.SoundMute) {
            return this.applySoundMuteEffect(soundMetaData, (SoundEffect.SoundMute)effect, $completion);
        }
        if (!(soundEffect instanceof SoundEffect.SoundClearVoice)) {
            throw new NoWhenBranchMatchedException();
        }
        return Boxing.boxBoolean(this.applySoundClearVoiceEffect(soundMetaData, (SoundEffect.SoundClearVoice)effect));
    }

    /*
     * Unable to fully structure code
     */
    private final Object applyCutEffectToVideo(VideoMetaData var1_1, VideoEffect.Cut var2_2, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof applyCutEffectToVideo.1)) ** GOTO lbl-1000
        var21_4 = $completion;
        if ((var21_4.label & -2147483648) != 0) {
            var21_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ VideoProcessor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return VideoProcessor.access$applyCutEffectToVideo(this.this$0, null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var22_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                cutEndTime = effect.getStartTimeMs() + effect.getDurationMs();
                $this$filter$iv = videoMetaData.getFrameToFileName();
                $i$f$filter = false;
                var8_11 = $this$filter$iv;
                destination$iv$iv = new LinkedHashMap<K, V>();
                $i$f$filterTo = false;
                for (Map.Entry<K, V> element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
                    var13_20 = element$iv$iv;
                    $i$a$-filter-VideoProcessor$applyCutEffectToVideo$newVideoFiles$1 = false;
                    index = ((Number)var13_20.getKey()).longValue();
                    sceneTime = (long)(1000.0 * (double)index / videoMetaData.getFrameRate());
                    if (!(sceneTime < (long)effect.getStartTimeMs() || sceneTime >= (long)cutEndTime)) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                $this$sortedBy$iv = MapsKt.toList(destination$iv$iv);
                $i$f$sortedBy = false;
                $this$map$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)a;
                        boolean bl = false;
                        Comparable comparable = (Long)it.getFirst();
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)((Long)it.getFirst()));
                    }
                });
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (Map.Entry<K, V> item$iv$iv : $this$mapTo$iv$iv) {
                    var13_20 = (Pair)item$iv$iv;
                    var19_27 = destination$iv$iv;
                    $i$a$-map-VideoProcessor$applyCutEffectToVideo$newVideoFiles$3 = false;
                    var19_27.add((String)it.getSecond());
                }
                newVideoFiles = (List)destination$iv$iv;
                $this$mapIndexed$iv = newVideoFiles;
                $i$f$mapIndexed = false;
                destination$iv$iv = $this$mapIndexed$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
                $i$f$mapIndexedTo = false;
                index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    if ((var15_24 = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    var16_30 = (String)item$iv$iv;
                    sceneTime = var15_24;
                    var19_27 = destination$iv$iv;
                    $i$a$-mapIndexed-VideoProcessor$applyCutEffectToVideo$frameToFileName$1 = false;
                    var19_27.add(TuplesKt.to(Boxing.boxLong((long)index), fileName));
                }
                frameToFileName = MapsKt.toMap((List)destination$iv$iv);
                updatedVideoMetaData = VideoMetaData.copy$default((VideoMetaData)videoMetaData, null, frameToFileName, 0.0, (long)((double)((long)frameToFileName.size() * 1000L) / videoMetaData.getFrameRate()), 5, null);
                $continuation.label = 1;
                v0 = updatedVideoMetaData.save($continuation);
                ** if (v0 != var22_6) goto lbl66
lbl65:
                // 1 sources

                return var22_6;
lbl66:
                // 1 sources

                ** GOTO lbl72
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure($result);
                    v0 = $result;
lbl72:
                    // 2 sources

                    var4_7 = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    var4_7 = false;
                }
                return Boxing.boxBoolean(var4_7 != false);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final Object applySoundCutEffect(SoundMetaData var1_1, SoundEffect.Cut var2_2, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof applySoundCutEffect.1)) ** GOTO lbl-1000
        var18_4 = $completion;
        if ((var18_4.label & -2147483648) != 0) {
            var18_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ VideoProcessor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return VideoProcessor.access$applySoundCutEffect(this.this$0, null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var19_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                cutEndTime = effect.getStartTimeMs() + effect.getDurationMs();
                newMap = new HashMap<K, V>();
                $this$filter$iv = soundMetaData.getTimeToFileName();
                $i$f$filter = false;
                var9_13 = $this$filter$iv;
                destination$iv$iv = new LinkedHashMap<K, V>();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
                    it = element$iv$iv;
                    $i$a$-filter-VideoProcessor$applySoundCutEffect$before$1 = false;
                    if (!(((Number)it.getKey()).longValue() < (long)effect.getStartTimeMs())) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                $this$forEach$iv = before = destination$iv$iv;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv.entrySet()) {
                    it = element$iv;
                    $i$a$-forEach-VideoProcessor$applySoundCutEffect$2 = false;
                    ((Map)newMap).put(it.getKey(), it.getValue());
                }
                $this$filter$iv = soundMetaData.getTimeToFileName();
                $i$f$filter = false;
                element$iv = $this$filter$iv;
                destination$iv$iv = new LinkedHashMap<K, V>();
                $i$f$filterTo = false;
                element$iv$iv = $this$filterTo$iv$iv.entrySet().iterator();
                while (element$iv$iv.hasNext()) {
                    it = element$iv$iv = (Map.Entry)element$iv$iv.next();
                    $i$a$-filter-VideoProcessor$applySoundCutEffect$after$1 = false;
                    if (!(((Number)it.getKey()).longValue() >= (long)cutEndTime)) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                $this$forEach$iv = after = destination$iv$iv;
                $i$f$forEach = false;
                $this$filterTo$iv$iv = $this$forEach$iv.entrySet().iterator();
                while ($this$filterTo$iv$iv.hasNext()) {
                    it = element$iv = $this$filterTo$iv$iv.next();
                    $i$a$-forEach-VideoProcessor$applySoundCutEffect$3 = false;
                    newTime = ((Number)it.getKey()).longValue() - (long)effect.getDurationMs();
                    var16_33 = Boxing.boxLong(newTime);
                    ((Map)newMap).put(var16_33, it.getValue());
                }
                $this$sortedBy$iv = MapsKt.toList((Map)newMap);
                $i$f$sortedBy = false;
                updatedSoundMetaData = SoundMetaData.copy$default((SoundMetaData)soundMetaData, null, MapsKt.toMap((Iterable)CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)a;
                        boolean bl = false;
                        Comparable comparable = (Long)it.getFirst();
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)((Long)it.getFirst()));
                    }
                })), 0, 0, 0, soundMetaData.getDurationMs() - (long)effect.getDurationMs(), 29, null);
                $continuation.label = 1;
                v0 = updatedSoundMetaData.save($continuation);
                ** if (v0 != var19_6) goto lbl69
lbl68:
                // 1 sources

                return var19_6;
lbl69:
                // 1 sources

                ** GOTO lbl75
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure($result);
                    v0 = $result;
lbl75:
                    // 2 sources

                    SceneMetadataManager.INSTANCE.clearCash();
                    var4_7 = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    var4_7 = false;
                }
                return Boxing.boxBoolean(var4_7 != false);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object applySoundMuteEffect(SoundMetaData soundMetaData, SoundEffect.SoundMute effect, Continuation<? super Boolean> $completion) {
        return this.applySoundFadeEffect(soundMetaData, effect, VideoProcessor::applySoundMuteEffect$lambda$14, $completion);
    }

    private final boolean applySoundClearVoiceEffect(SoundMetaData soundMetaData, SoundEffect.SoundClearVoice effect) {
        System.out.println((Object)("SoundClearVoice effect applied to " + soundMetaData.getFolderPath()));
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final Object applySoundFadeEffect(SoundMetaData var1_1, SoundEffect var2_2, Function1<? super Float, Float> var3_3, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof applySoundFadeEffect.1)) ** GOTO lbl-1000
        var17_5 = $completion;
        if ((var17_5.label & -2147483648) != 0) {
            var17_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ VideoProcessor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return VideoProcessor.access$applySoundFadeEffect(this.this$0, null, null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var18_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                effectEndTime = effect.getStartTimeMs() + effect.getDurationMs();
                $this$forEach$iv = soundMetaData.getTimeToFileName();
                $i$f$forEach = false;
                var8_11 = $this$forEach$iv.entrySet().iterator();
                while (var8_11.hasNext()) {
                    var10_13 = element$iv = var8_11.next();
                    $i$a$-forEach-VideoProcessor$applySoundFadeEffect$2 = false;
                    time = ((Number)var10_13.getKey()).longValue();
                    fileName = var10_13.getValue();
                    if (time < (long)effect.getStartTimeMs() || time >= (long)effectEndTime) continue;
                    audioFile = new File(soundMetaData.getFolderPath(), fileName);
                    VideoProcessor.INSTANCE.applyVolumeEffectToAudioFile(audioFile, (SoundMetaData)soundMetaData, (SoundEffect)effect, time - (long)effect.getStartTimeMs(), (Function1<? super Float, Float>)volumeFunction);
                }
                $continuation.label = 1;
                v0 = soundMetaData.save($continuation);
                if (v0 == var18_7) {
                    return var18_7;
                }
                ** GOTO lbl35
            }
            case 1: {
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl35:
                // 2 sources

                return Boxing.boxBoolean(true);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean applyVolumeEffectToAudioFile(File audioFile, SoundMetaData soundMetaData, SoundEffect effect, long currentTimeInEffect, Function1<? super Float, Float> volumeFunction) {
        boolean bl;
        try {
            if (!audioFile.exists()) {
                return false;
            }
            byte[] audioBytes = FilesKt.readBytes(audioFile);
            float progress2 = (float)currentTimeInEffect / (float)effect.getDurationMs();
            float volumeFactor = ((Number)volumeFunction.invoke(Float.valueOf(RangesKt.coerceIn(progress2, 0.0f, 1.0f)))).floatValue();
            byte[] processedAudioBytes = this.applyVolumeToAudioData(audioBytes, soundMetaData, volumeFactor);
            FilesKt.writeBytes(audioFile, processedAudioBytes);
            bl = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private final byte[] applyVolumeToAudioData(byte[] audioBytes, SoundMetaData soundMetaData, float volumeFactor) {
        byte[] byArray = Arrays.copyOf(audioBytes, audioBytes.length);
        Intrinsics.checkNotNullExpressionValue(byArray, "copyOf(...)");
        byte[] processedBytes = byArray;
        int bytesPerSample = this.getBytesPerSample(soundMetaData.getSampleFormat());
        IntProgression intProgression = RangesKt.step(RangesKt.until(0, audioBytes.length), bytesPerSample * soundMetaData.getAudioChannels());
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                int n3 = soundMetaData.getAudioChannels();
                for (int channel = 0; channel < n3; ++channel) {
                    int sampleStart = i + channel * bytesPerSample;
                    if (sampleStart + bytesPerSample > audioBytes.length) continue;
                    this.processSample(processedBytes, sampleStart, bytesPerSample, soundMetaData.getSampleFormat(), volumeFactor);
                }
                if (i == n) break;
                i += n2;
            }
        }
        return processedBytes;
    }

    private final int getBytesPerSample(int sampleFormat) {
        return switch (sampleFormat) {
            case 0, 5 -> 1;
            case 1, 6 -> 2;
            case 2, 3, 7, 8 -> 4;
            case 4, 9 -> 8;
            default -> 2;
        };
    }

    private final void processSample(byte[] bytes, int start2, int bytesPerSample, int sampleFormat, float volumeFactor) {
        switch (sampleFormat) {
            case 1: {
                int sample2 = (bytes[start2 + 1] & 0xFF) << 8 | bytes[start2] & 0xFF;
                int processedSample = (int)((float)((short)sample2) * volumeFactor);
                bytes[start2] = (byte)(processedSample & 0xFF);
                bytes[start2 + 1] = (byte)(processedSample >> 8 & 0xFF);
                break;
            }
            case 2: {
                int sample3 = (bytes[start2 + 3] & 0xFF) << 24 | (bytes[start2 + 2] & 0xFF) << 16 | (bytes[start2 + 1] & 0xFF) << 8 | bytes[start2] & 0xFF;
                int processedSample = (int)((float)sample3 * volumeFactor);
                bytes[start2] = (byte)(processedSample & 0xFF);
                bytes[start2 + 1] = (byte)(processedSample >> 8 & 0xFF);
                bytes[start2 + 2] = (byte)(processedSample >> 16 & 0xFF);
                bytes[start2 + 3] = (byte)(processedSample >> 24 & 0xFF);
                break;
            }
            case 3: {
                float sample4 = ByteBuffer.wrap(bytes, start2, 4).order(ByteOrder.LITTLE_ENDIAN).getFloat();
                float processedSample = sample4 * volumeFactor;
                byte[] byteArray = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(processedSample).array();
                System.arraycopy(byteArray, 0, bytes, start2, 4);
                break;
            }
            case 4: {
                double sample5 = ByteBuffer.wrap(bytes, start2, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                double processedSample = sample5 * (double)volumeFactor;
                byte[] byteArray = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putDouble(processedSample).array();
                System.arraycopy(byteArray, 0, bytes, start2, 8);
                break;
            }
            case 0: {
                int sample6 = bytes[start2] & 0xFF;
                int processedSample = RangesKt.coerceIn((int)((float)sample6 * volumeFactor), 0, 255);
                bytes[start2] = (byte)processedSample;
                break;
            }
            case 8: {
                float sample7 = ByteBuffer.wrap(bytes, start2, 4).order(ByteOrder.LITTLE_ENDIAN).getFloat();
                float processedSample = sample7 * volumeFactor;
                byte[] byteArray = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(processedSample).array();
                System.arraycopy(byteArray, 0, bytes, start2, 4);
                break;
            }
            default: {
                for (int j = 0; j < bytesPerSample; ++j) {
                    int byteValue = bytes[start2 + j] & 0xFF;
                    int processedByte = RangesKt.coerceIn((int)((float)byteValue * volumeFactor), 0, 255);
                    bytes[start2 + j] = (byte)processedByte;
                }
            }
        }
    }

    private final void applyAlphaToImage(BufferedImage image, float alpha2) {
        int n = image.getWidth();
        for (int x2 = 0; x2 < n; ++x2) {
            int n2 = image.getHeight();
            for (int y2 = 0; y2 < n2; ++y2) {
                int rgb = image.getRGB(x2, y2);
                float r = (float)(rgb >> 16 & 0xFF) * alpha2;
                float g = (float)(rgb >> 8 & 0xFF) * alpha2;
                float b = (float)(rgb & 0xFF) * alpha2;
                int newRgb = (int)r << 16 | (int)g << 8 | (int)b | 0xFF000000;
                image.setRGB(x2, y2, newRgb);
            }
        }
    }

    private final BufferedImage convertToBlackAndWhite(BufferedImage image) {
        BufferedImage result2 = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        Graphics2D graphics = result2.createGraphics();
        graphics.drawImage((Image)image, 0, 0, null);
        graphics.dispose();
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean applyFadeInToFrames(VideoMetaData videoMetaData, VideoEffect.FadeIn effect) {
        boolean bl;
        try {
            File it;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object each;
            void $this$filterTo$iv$iv;
            Map<Long, String> $this$filter$iv = videoMetaData.getFrameToFileName();
            boolean $i$f$filter = false;
            Map<Long, String> map2 = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
                each = element$iv$iv;
                boolean bl2 = false;
                long index2 = ((Number)each.getKey()).longValue();
                double time = (double)((long)1000 * index2) / videoMetaData.getFrameRate();
                if (!(time >= (double)effect.getStartTimeMs() && time <= (double)(effect.getStartTimeMs() + effect.getDurationMs()))) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Iterable $this$sortedBy$iv = MapsKt.toList(destination$iv$iv);
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Long)it.getFirst();
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Long)it.getFirst()));
                }
            });
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
                each = (Pair)((Object)item$iv$iv);
                Object object = destination$iv$iv;
                boolean bl3 = false;
                object.add(new File((String)((Pair)((Object)it)).getSecond()));
            }
            List frameFiles = (List)destination$iv$iv;
            Java2DFrameConverter converter = new Java2DFrameConverter();
            Iterable $this$forEachIndexed$iv = frameFiles;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void file;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                it = (File)item$iv;
                int index3 = n;
                boolean bl4 = false;
                float progress2 = (float)index3 / (float)frameFiles.size();
                float alpha2 = RangesKt.coerceIn(progress2, 0.0f, 1.0f);
                File frameFile = new File(new File(videoMetaData.getFolderPath()), file.getName());
                BufferedImage image = ImageIO.read(frameFile);
                Intrinsics.checkNotNull(image);
                INSTANCE.applyAlphaToImage(image, alpha2);
                ImageIO.write((RenderedImage)image, "png", frameFile);
            }
            converter.close();
            bl = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean applyFadeOutToFrames(VideoMetaData videoMetaData, VideoEffect.FadeOut effect) {
        boolean bl;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object each;
            void $this$filterTo$iv$iv;
            Map<Long, String> $this$filter$iv = videoMetaData.getFrameToFileName();
            boolean $i$f$filter = false;
            Map<Long, String> map2 = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
                each = element$iv$iv;
                boolean bl2 = false;
                long index2 = ((Number)each.getKey()).longValue();
                double time = (double)((long)1000 * index2) / videoMetaData.getFrameRate();
                if (!(time >= (double)effect.getStartTimeMs() && time <= (double)(effect.getStartTimeMs() + effect.getDurationMs()))) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Iterable $this$sortedBy$iv = MapsKt.toList(destination$iv$iv);
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Long)it.getFirst();
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Long)it.getFirst()));
                }
            });
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                each = (Pair)item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl3 = false;
                object.add(new File((String)it.getSecond()));
            }
            List frameFiles = (List)destination$iv$iv;
            Iterable $this$forEachIndexed$iv = frameFiles;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void file;
                int n;
                Object item$iv$iv;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                item$iv$iv = (File)item$iv;
                int index3 = n;
                boolean bl4 = false;
                float progress2 = (float)index3 / (float)frameFiles.size();
                float alpha2 = 1.0f - RangesKt.coerceIn(progress2, 0.0f, 1.0f);
                File frameFile = new File(new File(videoMetaData.getFolderPath()), file.getName());
                BufferedImage image = ImageIO.read(frameFile);
                Intrinsics.checkNotNull(image);
                INSTANCE.applyAlphaToImage(image, alpha2);
                ImageIO.write((RenderedImage)image, "png", frameFile);
            }
            bl = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private final Object deleteFramesInRange(File framesDir, int startTimeMs, int endTimeMs, Scene scene2, List<Scene> allScenes, Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    private static final float applyEffectToSound$lambda$3(float progress2) {
        return progress2;
    }

    private static final float applyEffectToSound$lambda$4(float progress2) {
        return 1.0f - progress2;
    }

    private static final float applySoundMuteEffect$lambda$14(float it) {
        return 0.0f;
    }

    public static final /* synthetic */ Object access$applyEffectToVideo(VideoProcessor $this, VideoMetaData videoMetaData, VideoEffect effect, Continuation $completion) {
        return $this.applyEffectToVideo(videoMetaData, effect, $completion);
    }

    public static final /* synthetic */ Object access$applyEffectToSound(VideoProcessor $this, SoundMetaData soundMetaData, SoundEffect effect, Continuation $completion) {
        return $this.applyEffectToSound(soundMetaData, effect, $completion);
    }

    public static final /* synthetic */ Object access$applyCutEffectToVideo(VideoProcessor $this, VideoMetaData videoMetaData, VideoEffect.Cut effect, Continuation $completion) {
        return $this.applyCutEffectToVideo(videoMetaData, effect, $completion);
    }

    public static final /* synthetic */ Object access$applySoundCutEffect(VideoProcessor $this, SoundMetaData soundMetaData, SoundEffect.Cut effect, Continuation $completion) {
        return $this.applySoundCutEffect(soundMetaData, effect, $completion);
    }

    public static final /* synthetic */ Object access$applySoundMuteEffect(VideoProcessor $this, SoundMetaData soundMetaData, SoundEffect.SoundMute effect, Continuation $completion) {
        return $this.applySoundMuteEffect(soundMetaData, effect, $completion);
    }

    public static final /* synthetic */ Object access$applySoundFadeEffect(VideoProcessor $this, SoundMetaData soundMetaData, SoundEffect effect, Function1 volumeFunction, Continuation $completion) {
        return $this.applySoundFadeEffect(soundMetaData, effect, volumeFunction, $completion);
    }

    public static final /* synthetic */ Object access$deleteFramesInRange(VideoProcessor $this, File framesDir, int startTimeMs, int endTimeMs, Scene scene2, List allScenes, Continuation $completion) {
        return $this.deleteFramesInRange(framesDir, startTimeMs, endTimeMs, scene2, allScenes, $completion);
    }
}

